/*
 * Decompiled with CFR 0.152.
 */
package com.mhuss.AstroLib;

import com.mhuss.AstroLib.AstroOps;
import com.mhuss.AstroLib.LocationElements;
import com.mhuss.AstroLib.Lunar;
import com.mhuss.AstroLib.MathOps;
import com.mhuss.AstroLib.NoInitException;
import com.mhuss.AstroLib.ObsInfo;
import com.mhuss.AstroLib.Pluto2;
import com.mhuss.AstroLib.Vsop;

public class PlanetData {
    public static final double AU = 1.49597870691E8;
    protected boolean m_initComplete;
    protected int m_planet;
    protected double m_jd;
    protected double m_centuries;
    protected double m_hourAngle;
    protected double m_rightAscension;
    protected double m_declination;
    protected LocationElements g_polarLEs;
    protected LocationElements m_polarLEs;
    protected LocationElements m_eclipticLEs;
    protected LocationElements m_equatorialLEs;
    protected LocationElements m_altAzLEs;
    private static final String NoInit = "Call PlanetData.calc() first.";

    public PlanetData() {
        this.m_planet = -1;
        this.m_initComplete = false;
    }

    public PlanetData(int planet, double jd, double deltaT, ObsInfo oi) {
        this.calc(planet, jd, deltaT, oi);
    }

    public PlanetData(int planet, double jd, ObsInfo oi) {
        this.calc(planet, jd, oi);
    }

    public double calcLon(int planet, double jd, ObsInfo oi) {
        if (0 == planet) {
            planet = 3;
        }
        this.m_jd = jd;
        this.m_planet = planet;
        this.m_centuries = AstroOps.toMillenia(jd);
        this.m_polarLEs = new LocationElements();
        if (10 == planet) {
            Lunar luna = new Lunar();
            try {
                luna.calcAllLEs(this.m_polarLEs, this.m_centuries);
                this.m_polarLEs.setRadius(this.m_polarLEs.getRadius() / 1.49597870691E8);
            }
            catch (NoInitException ni) {}
        } else if (9 == planet) {
            double[] lbr = new double[3];
            Pluto2.ln_get_pluto_helio_coords(jd, lbr);
            this.m_polarLEs.setLongitude(lbr[0]);
            this.m_polarLEs.setLatitude(lbr[1]);
            this.m_polarLEs.setRadius(lbr[2]);
        } else {
            Vsop.calcAllLEs(this.m_polarLEs, this.m_centuries, planet);
            if (3 == planet) {
                this.m_polarLEs.setLongitude(this.m_polarLEs.getLongitude() + Math.PI);
                this.m_polarLEs.setLatitude(this.m_polarLEs.getLatitude() * -1.0);
            }
        }
        return this.m_polarLEs.getLongitude();
    }

    public void calc(int planet, double jd, double deltaT, ObsInfo oi) {
        this.calc(planet, jd, deltaT, oi, true, true);
    }

    public void calc(int planet, double jd, ObsInfo oi) {
        this.calc(planet, jd, 0.0, oi, false, false);
    }

    public void calc(int planet, double jd, double deltaT, ObsInfo oi, boolean topoc_Corr, boolean lightT_Corr) {
        double localSiderealTime = AstroOps.greenwichSiderealTime(jd - deltaT) + oi.getLongitudeRad();
        double obliquity = AstroOps.meanObliquity(this.m_centuries);
        double[] tmpVec = new double[3];
        double[] tmpVec2 = new double[3];
        double lightTimeCorrection = 0.0;
        int passNo = 1;
        if (!lightT_Corr) {
            passNo = 2;
        }
        do {
            this.calcLon(planet, jd - lightTimeCorrection, oi);
            MathOps.polarToCartesian(tmpVec, this.m_polarLEs.getLongitude(), this.m_polarLEs.getLatitude(), this.m_polarLEs.getRadius());
            this.g_polarLEs = new LocationElements();
            if (!(planet == 3 || planet == 0 || passNo != 1 && lightT_Corr)) {
                Vsop.calcAllLEs(this.g_polarLEs, this.m_centuries, 3);
                MathOps.polarToCartesian(tmpVec2, this.g_polarLEs.getLongitude(), this.g_polarLEs.getLatitude(), this.g_polarLEs.getRadius());
            }
            if (planet != 10 && planet != 3 && planet != 0) {
                tmpVec[0] = tmpVec[0] - tmpVec2[0];
                tmpVec[1] = tmpVec[1] - tmpVec2[1];
                tmpVec[2] = tmpVec[2] - tmpVec2[2];
            }
            if (planet == 10 || planet == 3 || planet == 0) {
                passNo = 2;
            }
            if (passNo == 2) {
                if (topoc_Corr) {
                    PlanetData.TopocReductionEcl(tmpVec, localSiderealTime, oi.getLatitudeRad(), obliquity);
                }
                if (planet != 10) continue;
                tmpVec2[0] = tmpVec2[0] + tmpVec[0];
                tmpVec2[1] = tmpVec2[1] + tmpVec[1];
                tmpVec2[2] = tmpVec2[2] + tmpVec[2];
                double[] tmpVec3 = new double[3];
                MathOps.cartesianToPolar(tmpVec2, tmpVec3);
                this.m_polarLEs = new LocationElements(tmpVec3);
                continue;
            }
            double LIGHTSPEED = 299792.458;
            lightTimeCorrection = Math.sqrt(tmpVec[0] * tmpVec[0] + tmpVec[1] * tmpVec[1] + tmpVec[2] * tmpVec[2]) * 1.49597870691E8 / 2.5902068371199997E10;
        } while (++passNo <= 2);
        this.m_eclipticLEs = new LocationElements(tmpVec);
        MathOps.rotateVector(tmpVec, obliquity, 0);
        this.m_equatorialLEs = new LocationElements(tmpVec);
        this.m_rightAscension = Math.atan2(this.m_equatorialLEs.getY(), this.m_equatorialLEs.getX());
        this.m_declination = Math.atan2(this.m_equatorialLEs.getZ(), Math.sqrt(this.m_equatorialLEs.getX() * this.m_equatorialLEs.getX() + this.m_equatorialLEs.getY() * this.m_equatorialLEs.getY()));
        MathOps.rotateVector(tmpVec, -localSiderealTime, 2);
        this.m_hourAngle = Math.atan2(-tmpVec[1], tmpVec[0]);
        MathOps.rotateVector(tmpVec, oi.getLatitudeRad() - 1.5707963267948966, 1);
        this.m_altAzLEs = new LocationElements(tmpVec);
        this.m_initComplete = true;
    }

    static void TopocReductionEqu(double[] cartVec, double localSiderealTime, double latRad) {
        double AE = 1.49597870691E8;
        double R_EARTH = 6368.0;
        double[] tmpVec2 = new double[3];
        MathOps.polarToCartesian(tmpVec2, localSiderealTime, latRad, 4.256745079716637E-5);
        cartVec[0] = cartVec[0] - tmpVec2[0];
        cartVec[1] = cartVec[1] - tmpVec2[1];
        cartVec[2] = cartVec[2] - tmpVec2[2];
    }

    protected static void TopocReductionEcl(double[] cartVec, double localSiderealTime, double latRad, double obliquity) {
        double AE = 1.49597870691E8;
        double R_EARTH = 6368.0;
        double[] tmpVec2 = new double[3];
        MathOps.polarToCartesian(tmpVec2, localSiderealTime, latRad, 4.256745079716637E-5);
        MathOps.rotateVector(tmpVec2, -obliquity, 0);
        cartVec[0] = cartVec[0] - tmpVec2[0];
        cartVec[1] = cartVec[1] - tmpVec2[1];
        cartVec[2] = cartVec[2] - tmpVec2[2];
    }

    public int planet() {
        return this.m_planet;
    }

    public double jd() throws NoInitException {
        if (!this.m_initComplete) {
            throw new NoInitException(NoInit);
        }
        return this.m_jd;
    }

    public double hourAngle() throws NoInitException {
        if (!this.m_initComplete) {
            throw new NoInitException(NoInit);
        }
        return this.m_hourAngle;
    }

    public double getPolarLat() throws NoInitException {
        if (!this.m_initComplete) {
            throw new NoInitException(NoInit);
        }
        return this.m_polarLEs.getLatitude();
    }

    public double getPolarLon() throws NoInitException {
        if (!this.m_initComplete) {
            throw new NoInitException(NoInit);
        }
        return this.m_polarLEs.getLongitude();
    }

    public double getPolarRadius() throws NoInitException {
        if (!this.m_initComplete) {
            throw new NoInitException(NoInit);
        }
        return this.m_polarLEs.getRadius();
    }

    public double getSolarLat() throws NoInitException {
        if (!this.m_initComplete) {
            throw new NoInitException(NoInit);
        }
        if (this.g_polarLEs.getRadius() == -1.0) {
            Vsop.calcAllLEs(this.g_polarLEs, this.m_centuries, 3);
        }
        return -this.g_polarLEs.getLatitude();
    }

    public double getSolarLon() throws NoInitException {
        if (!this.m_initComplete) {
            throw new NoInitException(NoInit);
        }
        if (this.g_polarLEs.getRadius() == -1.0) {
            Vsop.calcAllLEs(this.g_polarLEs, this.m_centuries, 3);
        }
        return this.g_polarLEs.getLongitude() + Math.PI;
    }

    public double getSolarRadius() throws NoInitException {
        if (!this.m_initComplete) {
            throw new NoInitException(NoInit);
        }
        if (this.g_polarLEs.getRadius() == -1.0) {
            Vsop.calcAllLEs(this.g_polarLEs, this.m_centuries, 3);
        }
        return this.g_polarLEs.getRadius();
    }

    public LocationElements getEclipticXYZ() throws NoInitException {
        if (!this.m_initComplete) {
            throw new NoInitException(NoInit);
        }
        return this.m_eclipticLEs;
    }

    public double getEclipticLat() throws NoInitException {
        if (!this.m_initComplete) {
            throw new NoInitException(NoInit);
        }
        return Math.atan2(this.m_eclipticLEs.getZ(), Math.sqrt(this.m_eclipticLEs.getX() * this.m_eclipticLEs.getX() + this.m_eclipticLEs.getY() * this.m_eclipticLEs.getY()));
    }

    public double getEclipticLon() throws NoInitException {
        if (!this.m_initComplete) {
            throw new NoInitException(NoInit);
        }
        return Math.atan2(this.m_eclipticLEs.getY(), this.m_eclipticLEs.getX());
    }

    public double getEclipticRadius() throws NoInitException {
        if (!this.m_initComplete) {
            throw new NoInitException(NoInit);
        }
        return Math.sqrt(this.m_eclipticLEs.getX() * this.m_eclipticLEs.getX() + this.m_eclipticLEs.getY() * this.m_eclipticLEs.getY() + this.m_eclipticLEs.getZ() * this.m_eclipticLEs.getZ());
    }

    public double getEquatorialLat() throws NoInitException {
        if (!this.m_initComplete) {
            throw new NoInitException(NoInit);
        }
        return this.m_equatorialLEs.getLatitude();
    }

    public double getEquatorialLon() throws NoInitException {
        if (!this.m_initComplete) {
            throw new NoInitException(NoInit);
        }
        return this.m_equatorialLEs.getLongitude();
    }

    public double getEquatorialRadius() throws NoInitException {
        if (!this.m_initComplete) {
            throw new NoInitException(NoInit);
        }
        return this.m_equatorialLEs.getRadius();
    }

    public double getAltAzLat() throws NoInitException {
        if (!this.m_initComplete) {
            throw new NoInitException(NoInit);
        }
        return Math.atan2(this.m_altAzLEs.getZ(), Math.sqrt(this.m_altAzLEs.getX() * this.m_altAzLEs.getX() + this.m_altAzLEs.getY() * this.m_altAzLEs.getY()));
    }

    public double getAltAzLon() throws NoInitException {
        if (!this.m_initComplete) {
            throw new NoInitException(NoInit);
        }
        return Math.atan2(this.m_altAzLEs.getY(), this.m_altAzLEs.getX());
    }

    public double getAltAzRadius() throws NoInitException {
        if (!this.m_initComplete) {
            throw new NoInitException(NoInit);
        }
        return Math.sqrt(this.m_altAzLEs.getX() * this.m_altAzLEs.getX() + this.m_altAzLEs.getY() * this.m_altAzLEs.getY() + this.m_altAzLEs.getZ() * this.m_altAzLEs.getZ());
    }

    public double getRightAscension() throws NoInitException {
        if (!this.m_initComplete) {
            throw new NoInitException(NoInit);
        }
        return this.m_rightAscension;
    }

    public double getDeclination() throws NoInitException {
        if (!this.m_initComplete) {
            throw new NoInitException(NoInit);
        }
        return this.m_declination;
    }
}

