/*
 * Decompiled with CFR 0.152.
 */
package com.mhuss.AstroLib;

import com.mhuss.AstroLib.DarkCalData;
import com.mhuss.AstroLib.DarkCalInput;
import com.mhuss.AstroLib.DateOps;
import com.mhuss.AstroLib.Latitude;
import com.mhuss.AstroLib.Longitude;
import com.mhuss.AstroLib.ObsInfo;
import com.mhuss.AstroLib.PlanetData;
import com.mhuss.AstroLib.RiseSet;
import com.mhuss.AstroLib.TimePair;

public class DarkCalCalc {
    DarkCalData dcd;

    private DarkCalCalc() {
    }

    public DarkCalCalc(DarkCalInput dci, boolean ignoreDst) {
        this.calc(dci, ignoreDst);
    }

    private void findDark(int i) {
        double moonSet;
        double moonRise;
        if (i > 31) {
            System.err.println("illegal index");
            return;
        }
        double a_ = this.dcd.astTwi[i].b;
        double b_ = this.dcd.astTwi[i + 1].a;
        this.dcd.dark[i] = new TimePair(a_, b_);
        double darkStart = this.dcd.astTwi[i].b + (double)i;
        double darkEnd = this.dcd.astTwi[i + 1].a + (double)(i + 1);
        if (this.dcd.moonRS2[i].a < 0.0 || this.dcd.moonRS2[i].b > this.dcd.moonRS2[i].a) {
            moonRise = this.dcd.moonRS2[i + 1].a + (double)(i + 1);
            this.dcd.moonRS2[i].a = this.dcd.moonRS2[i + 1].a;
        } else {
            moonRise = this.dcd.moonRS2[i].a + (double)i;
        }
        if (this.dcd.moonRS2[i].b < 0.0 || this.dcd.moonRS2[i].a > this.dcd.moonRS2[i].b) {
            moonSet = this.dcd.moonRS2[i + 1].b + (double)(i + 1);
            this.dcd.moonRS2[i].b = this.dcd.moonRS2[i + 1].b;
        } else {
            moonSet = this.dcd.moonRS2[i].b + (double)i;
        }
        if (moonSet > darkStart && moonSet < darkEnd) {
            darkStart = moonSet;
            this.dcd.dark[i].a = this.dcd.moonRS2[i].b;
        }
        if (moonRise > darkStart && moonRise < darkEnd) {
            darkEnd = moonRise;
            this.dcd.dark[i].b = this.dcd.moonRS2[i].a;
        }
        this.dcd.noDarkness[i] = moonRise < darkStart && moonSet > darkEnd;
    }

    void calc(DarkCalInput dci, boolean ignoreDst) {
        int i;
        this.dcd = new DarkCalData(dci, ignoreDst);
        this.dcd.jdStart = DateOps.dmyToDay(1, dci.month, dci.year);
        this.dcd.jdEnd = dci.month < 12 ? DateOps.dmyToDay(1, dci.month + 1, dci.year) : DateOps.dmyToDay(1, 1, dci.year + 1);
        int end = (int)(this.dcd.jdEnd - this.dcd.jdStart);
        double tzAdj = (double)dci.tz * 0.041666666666666664;
        this.dcd.dstStart = DateOps.dstStart(dci.year);
        this.dcd.dstEnd = DateOps.dstEnd(dci.year);
        PlanetData pd = new PlanetData();
        ObsInfo oi = new ObsInfo(new Latitude(dci.lat), new Longitude(dci.lon), dci.tz);
        for (i = 0; i <= end + 1; ++i) {
            long day = this.dcd.jdStart + (long)i;
            double dstAdj = false == ignoreDst && day >= this.dcd.dstStart && day < this.dcd.dstEnd ? 0.041666666666666664 : 0.0;
            this.dcd.jd[i] = (double)day - (tzAdj + dstAdj) - 0.5;
            this.dcd.sunRS[i] = RiseSet.getTimes(0, this.dcd.jd[i], oi, pd);
            this.dcd.astTwi[i] = RiseSet.getTimes(4, this.dcd.jd[i], oi, pd);
            this.dcd.moonRS[i] = RiseSet.getTimes(1, this.dcd.jd[i], oi, pd);
        }
        for (int j = 0; j < this.dcd.moonRS.length; ++j) {
            this.dcd.moonRS2[j] = new TimePair(this.dcd.moonRS[j]);
        }
        for (i = 0; i <= end; ++i) {
            this.findDark(i);
        }
    }
}

