/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.zirkel.tools;

import carmetal.construction.Selector;
import carmetal.constructors.ObjectConstructor;
import carmetal.objects.ConstructionObject;
import carmetal.objects.ExpressionObject;
import carmetal.objects.PointObject;
import carmetal.objects.PrimitiveCircleObject;
import carmetal.objects.PrimitiveLineObject;
import carmetal.objects.SegmentObject;
import carmetal.rene.gui.Global;
import carmetal.rene.zirkel.ZirkelCanvas;
import java.awt.event.MouseEvent;

public class JSmacroTool
extends ObjectConstructor
implements Selector {
    ObjectConstructor OC;
    String MSG;
    String TYPE;

    public JSmacroTool(ZirkelCanvas zc, String msg, String type, ObjectConstructor oc) {
        this.OC = oc;
        this.MSG = msg;
        this.TYPE = type;
        zc.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        ConstructionObject o = null;
        if (this.TYPE.equals("Point")) {
            o = zc.selectCreatePoint(e2.getX(), e2.getY(), e2.isAltDown());
            Global.setJSO(o);
        } else if (this.TYPE.equals("Segment")) {
            o = zc.selectSegment(e2.getX(), e2.getY());
            Global.setJSO(o);
        } else if (this.TYPE.equals("Line")) {
            o = zc.selectLine(e2.getX(), e2.getY());
            Global.setJSO(o);
        } else if (this.TYPE.equals("Circle")) {
            o = zc.selectCircle(e2.getX(), e2.getY());
            Global.setJSO(o);
        } else if (this.TYPE.equals("Expression")) {
            o = zc.selectObject(e2.getX(), e2.getY());
            Global.setJSO(o);
        }
        if (Global.getJSO() != null) {
            o.setSelected(true);
        } else {
            Global.setJSquit(true);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e2, ZirkelCanvas zc, boolean simple) {
        if (this.TYPE.equals("Point")) {
            zc.indicateCreatePoint(e2.getX(), e2.getY(), true);
        } else {
            zc.indicateWithSelector(e2.getX(), e2.getY(), this);
        }
    }

    @Override
    public boolean isAdmissible(ZirkelCanvas zc, ConstructionObject o) {
        if (o instanceof PointObject && this.TYPE.equals("Point")) {
            return true;
        }
        if (o instanceof PrimitiveLineObject && this.TYPE.equals("Line")) {
            return true;
        }
        if (o instanceof PrimitiveCircleObject && this.TYPE.equals("Circle")) {
            return true;
        }
        if (o instanceof SegmentObject && this.TYPE.equals("Segment")) {
            return true;
        }
        return o instanceof ExpressionObject && this.TYPE.equals("Expression");
    }

    @Override
    public void showStatus(ZirkelCanvas zc) {
        zc.showStatus(this.MSG);
    }

    @Override
    public void reset(ZirkelCanvas zc) {
        super.reset(zc);
        zc.setTool(this.OC);
        zc.validate();
        zc.repaint();
    }

    @Override
    public boolean useSmartBoard() {
        return false;
    }
}

