/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.zirkel.tools;

import carmetal.construction.Selector;
import carmetal.constructors.ObjectConstructor;
import carmetal.eric.bar.JPropertiesBar;
import carmetal.objects.ConstructionObject;
import carmetal.objects.InsideObject;
import carmetal.objects.PointObject;
import carmetal.objects.PointonObject;
import carmetal.rene.gui.Global;
import carmetal.rene.zirkel.ZirkelCanvas;
import java.awt.event.MouseEvent;

public class BinderTool
extends ObjectConstructor
implements Selector {
    ObjectConstructor OC;
    PointObject P;
    boolean Control;

    public BinderTool(ZirkelCanvas zc, PointObject p, ObjectConstructor oc) {
        this.P = p;
        this.OC = oc;
        this.P.setSelected(true);
        zc.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        this.Control = e2.isControlDown();
        ConstructionObject o = zc.selectWithSelector(e2.getX(), e2.getY(), this);
        if (o == null) {
            return;
        }
        if (this.Control && !(o instanceof InsideObject)) {
            return;
        }
        if (zc.getConstruction().dependsOn(o, this.P)) {
            return;
        }
        this.P.setBound(o.getName());
        if (o instanceof InsideObject) {
            if (this.Control || !(o instanceof PointonObject)) {
                this.P.setInside(true);
            }
        } else {
            this.P.setUseAlpha(!e2.isShiftDown());
        }
        zc.getConstruction().updateCircleDep();
        zc.repaint();
        this.reset(zc);
        JPropertiesBar.EditObject(this.P, false, false);
    }

    @Override
    public void mouseMoved(MouseEvent e2, ZirkelCanvas zc, boolean simple) {
        this.Control = e2.isControlDown();
        zc.indicateWithSelector(e2.getX(), e2.getY(), this);
    }

    @Override
    public boolean isAdmissible(ZirkelCanvas zc, ConstructionObject o) {
        return (o instanceof InsideObject || o instanceof PointonObject) && !zc.getConstruction().dependsOn(o, this.P);
    }

    @Override
    public void showStatus(ZirkelCanvas zc) {
        zc.showStatus(Global.name("message.bindpoint"));
    }

    @Override
    public void reset(ZirkelCanvas zc) {
        super.reset(zc);
        zc.setTool(this.OC);
        zc.validate();
        zc.repaint();
    }

    @Override
    public boolean useSmartBoard() {
        return false;
    }
}

