/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.zirkel.tools;

import carmetal.construction.Selector;
import carmetal.constructors.ObjectConstructor;
import carmetal.objects.CircleObject;
import carmetal.objects.ConstructionObject;
import carmetal.objects.PointObject;
import carmetal.objects.PrimitiveCircleObject;
import carmetal.objects.SegmentObject;
import carmetal.rene.gui.Global;
import carmetal.rene.util.xml.XmlWriter;
import carmetal.rene.zirkel.ZirkelCanvas;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;

public class AnimatorTool
extends ObjectConstructor
implements Runnable,
Selector {
    PointObject P;
    ZirkelCanvas ZC;
    boolean Running = false;
    boolean Interactive = true;
    boolean Complete = false;
    boolean Negative = false;
    boolean Original = false;
    double Delay = 50.0;
    boolean Stopped = false;

    public AnimatorTool() {
        this.P = null;
    }

    public AnimatorTool(PointObject p, Vector v, ZirkelCanvas zc, boolean negative, boolean original, String delay) {
        this.P = p;
        if (!this.P.moveable()) {
            return;
        }
        Enumeration e2 = v.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = zc.getConstruction().find((String)e2.nextElement());
            if (o instanceof SegmentObject || o instanceof PrimitiveCircleObject || o instanceof PointObject) continue;
            return;
        }
        this.Stopped = false;
        this.ZC = zc;
        this.Complete = true;
        this.Negative = negative;
        this.Original = original;
        try {
            this.Delay = 50.0;
            this.Delay = new Double(delay);
        }
        catch (Exception exception) {
            // empty catch block
        }
        new Thread(this).start();
    }

    public void setInteractive(boolean flag) {
        this.Interactive = flag;
    }

    @Override
    public boolean isAdmissible(ZirkelCanvas zc, ConstructionObject o) {
        if (o instanceof CircleObject && ((CircleObject)o).getP2() == this.P) {
            return true;
        }
        return !zc.depends(o, this.P);
    }

    @Override
    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        ConstructionObject o = zc.selectAnimationObject(e2.getX(), e2.getY());
        if (o != null) {
            if (zc.isAnimated(o)) {
                o.setSelected(false);
                zc.removeAnimation(o);
            } else {
                o.setSelected(true);
                zc.addAnimation(o);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e2, ZirkelCanvas zc, boolean simple) {
        zc.indicateAnimationObjects(e2.getX(), e2.getY());
    }

    @Override
    public synchronized void reset(ZirkelCanvas zc) {
        zc.selectAnimationPoints();
    }

    @Override
    public void showStatus(ZirkelCanvas zc) {
        if (this.P == null) {
            zc.showStatus(Global.name("message.animator.point"));
        } else if (!this.Complete) {
            zc.showStatus(Global.name("message.animator.segment"));
        } else {
            zc.showStatus(Global.name("message.animator.running"));
        }
    }

    public void save(XmlWriter xml) {
        this.ZC.getAnimations().printArgs(xml);
    }

    @Override
    public void run() {
    }

    @Override
    public synchronized void invalidate(ZirkelCanvas zc) {
        this.Stopped = true;
    }

    @Override
    public boolean useSmartBoard() {
        return false;
    }
}

