/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.lister;

import carmetal.rene.gui.Global;
import carmetal.rene.lister.Element;
import carmetal.rene.lister.Lister;
import carmetal.rene.lister.ListerMouseEvent;
import carmetal.rene.util.MyVector;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ListerPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final MyVector V;
    int Top;
    Image I;
    int W;
    int H;
    int panelHeight;
    Graphics IG;
    Font F;
    FontMetrics FM;
    int Leading;
    int Height;
    int Ascent;
    int Descent;
    int PageSize;
    int HOffset;
    boolean ShowLast;
    Lister LD;
    String Name;
    public Color ListingBackground = null;
    public boolean MultipleSelection = true;
    public boolean EasyMultipleSelection = false;
    public boolean ReportSingleClick = false;
    public boolean RightMouseClick = false;
    int State = 0;
    Vector VAL = new Vector();
    MyVector Selected = new MyVector();

    public ListerPanel(Lister ld, String name) {
        this.setLayout(new BoxLayout(this, 1));
        this.LD = ld;
        this.Name = name;
        this.V = new MyVector();
        this.Top = 0;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                ListerPanel.this.clicked(e2);
            }
        });
        this.init();
    }

    public ListerPanel(Lister ld) {
        this(ld, "");
    }

    @Override
    public void paintComponent(Graphics g) {
        this.W = this.getSize().width;
        this.H = this.getHeight();
        this.I = this.createImage(this.W, this.H);
        if (this.I == null) {
            return;
        }
        this.IG = this.I.getGraphics();
        this.init();
        this.dopaint(this.IG);
        g.drawImage(this.I, 0, 0, this.W, this.H, this);
        if (this.V.size() > 1) {
            double vp = (double)this.Top / (double)this.V.size();
        } else {
            double vp = 0.0;
        }
        if (this.V.size() > 2 * this.PageSize) {
            double vs = (double)this.PageSize / (double)this.V.size();
        } else {
            double vs = 0.5;
        }
        if (this.HOffset < 10 * this.W) {
            double hp = (double)this.HOffset / (double)(10 * this.W);
        } else {
            double hp = 0.9;
        }
        double hs = 0.1;
    }

    void init() {
        this.F = new Font("Monospaced", 1, 14);
        this.setFont(this.F);
        this.FM = this.getFontMetrics(this.F);
        this.Leading = this.FM.getLeading() + Global.getParameter("fixedfont.spacing", -1);
        this.Height = this.FM.getHeight() + 3;
        this.Ascent = this.FM.getAscent();
        this.Descent = this.FM.getDescent();
        this.PageSize = this.Height + this.Leading > 0 ? this.H / (this.Height + this.Leading) : 10;
        this.Top = 0;
    }

    public synchronized void dopaint(Graphics g) {
        int line;
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.white);
        g2.fillRect(0, 0, this.W, this.H);
        g2.setFont(this.F);
        g2.setColor(Color.black);
        int h = this.Leading + this.Ascent;
        if (line < 0) {
            return;
        }
        for (line = this.Top; line - this.Top < this.PageSize && line < this.V.size(); ++line) {
            Color col;
            Element el = (Element)this.V.elementAt(line);
            if (this.isSelected(line)) {
                g2.setColor(this.getBackground().darker());
                g2.fillRect(0, h - this.Ascent, this.W, this.Height);
                g2.setColor(Color.black);
            }
            if ((col = el.getElementColor()) != null) {
                g2.setColor(col);
            } else {
                g2.setColor(Color.black);
            }
            g2.drawString(el.getElementString(this.State), 2 - this.HOffset, h + 1);
            h += this.Leading + this.Height;
        }
    }

    @Override
    public int getHeight() {
        return this.V.size() * (this.Leading + this.Height);
    }

    public void fixsize() {
        ListerPanel.fixsize(this, this.W, this.getHeight());
    }

    private static void fixsize(JComponent cp, int w, int h) {
        Dimension d2 = new Dimension(w, h);
        cp.setMaximumSize(d2);
        cp.setMinimumSize(d2);
        cp.setPreferredSize(d2);
        cp.setSize(d2);
    }

    public void setState(int s) {
        this.State = s;
    }

    public synchronized void add(Element e2) {
        this.V.addElement(e2);
    }

    public synchronized void up(int n) {
        this.Top += n;
        if (this.Top >= this.V.size()) {
            this.Top = this.V.size() - 1;
        }
        if (this.Top < 0) {
            this.Top = 0;
        }
        this.repaint();
    }

    public synchronized void down(int n) {
        this.Top -= n;
        if (this.Top < 0) {
            this.Top = 0;
        }
        this.repaint();
    }

    public synchronized void pageUp() {
        this.up(this.PageSize - 1);
        this.repaint();
    }

    public synchronized void pageDown() {
        this.down(this.PageSize - 1);
        this.repaint();
    }

    public synchronized void setVerticalPos(double x) {
        this.Top = (int)(x * (double)this.V.size());
        if (this.Top >= this.V.size()) {
            this.Top = this.V.size() - 1;
        }
        this.repaint();
    }

    public synchronized void setHorizontalPos(double x) {
        this.HOffset = (int)(x * 10.0 * (double)this.W);
        this.repaint();
    }

    public synchronized void clear() {
        this.Selected.removeAllElements();
        this.V.removeAllElements();
        this.Top = 0;
    }

    public synchronized void showLast() {
        this.ShowLast = true;
        this.LD.getVerticalScrollBar().setValue(this.LD.getVerticalScrollBar().getMaximum());
    }

    public synchronized boolean isSelected(int sel) {
        Enumeration e2 = this.Selected.elements();
        while (e2.hasMoreElements()) {
            int n = (Integer)e2.nextElement();
            if (n != sel) continue;
            return true;
        }
        return false;
    }

    public synchronized void toggleSelect(int sel) {
        Enumeration e2 = this.Selected.elements();
        while (e2.hasMoreElements()) {
            Integer i = (Integer)e2.nextElement();
            if (i != sel) continue;
            this.Selected.removeElement(i);
            return;
        }
        this.Selected.addElement(new Integer(sel));
    }

    public synchronized void expandSelect(int sel) {
        int i;
        int i2;
        int max = -1;
        Enumeration e2 = this.Selected.elements();
        while (e2.hasMoreElements()) {
            i2 = (Integer)e2.nextElement();
            if (i2 <= max || i2 >= sel) continue;
            max = i2;
        }
        if (max >= 0) {
            for (i2 = max + 1; i2 <= sel; ++i2) {
                this.select(i2);
            }
            return;
        }
        int min = this.V.size();
        e2 = this.Selected.elements();
        while (e2.hasMoreElements()) {
            i = (Integer)e2.nextElement();
            if (i >= min || i <= sel) continue;
            min = i;
        }
        if (min < this.V.size()) {
            for (i = sel; i <= min; ++i) {
                this.select(i);
            }
        }
    }

    public synchronized void select(int sel) {
        if (!this.isSelected(sel)) {
            this.Selected.addElement(new Integer(sel));
        }
    }

    public void addActionListener(ActionListener al) {
        this.VAL.addElement(al);
    }

    public void removeActionListener(ActionListener al) {
        this.VAL.removeElement(al);
    }

    public void clicked(MouseEvent e2) {
        block12: {
            int n;
            block11: {
                n = e2.getY() / (this.Leading + this.Height);
                if (!e2.isMetaDown() || !this.RightMouseClick) break block11;
                Enumeration en = this.VAL.elements();
                while (en.hasMoreElements()) {
                    ((ActionListener)en.nextElement()).actionPerformed(new ListerMouseEvent((Object)this.LD, this.Name, e2));
                }
                break block12;
            }
            if (this.Top + n >= this.V.size()) {
                return;
            }
            int sel = n + this.Top;
            if (e2.getClickCount() >= 2) {
                if (!this.MultipleSelection) {
                    this.Selected.removeAllElements();
                }
                this.select(sel);
            } else if (this.MultipleSelection && (e2.isControlDown() || this.EasyMultipleSelection || e2.isShiftDown())) {
                if (e2.isControlDown() || this.EasyMultipleSelection) {
                    this.toggleSelect(sel);
                } else if (e2.isShiftDown()) {
                    this.expandSelect(sel);
                }
            } else {
                this.Selected.removeAllElements();
                this.Selected.addElement(new Integer(sel));
            }
            Graphics g = this.getGraphics();
            this.paint(g);
            g.dispose();
            if (e2.getClickCount() < 2 && !this.ReportSingleClick) break block12;
            Enumeration en = this.VAL.elements();
            while (en.hasMoreElements()) {
                ((ActionListener)en.nextElement()).actionPerformed(new ListerMouseEvent((Object)this.LD, this.Name, e2));
            }
        }
    }

    public synchronized Element getElementAt(int n) {
        return (Element)this.V.elementAt(n);
    }

    public synchronized void save(PrintWriter o) {
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            Element el = (Element)e2.nextElement();
            o.println(el.getElementString());
        }
    }

    public void setListingBackground(Color c2) {
        this.ListingBackground = c2;
    }
}

