/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.lister;

import carmetal.rene.lister.Element;
import carmetal.rene.lister.ListerPanel;
import carmetal.rene.lister.StringElement;
import java.awt.Color;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class Lister
extends JScrollPane {
    public ListerPanel L = new ListerPanel(this);

    public Lister() {
        this.setViewportView(this.L);
        this.setVerticalScrollBarPolicy(22);
        this.setWheelScrollingEnabled(true);
        this.getVerticalScrollBar().setUnitIncrement(16);
    }

    public ListerPanel getLister() {
        return this.L;
    }

    public void addActionListener(ActionListener al) {
        this.L.addActionListener(al);
    }

    public void updateDisplay() {
        this.L.repaint();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Lister.this.L.fixsize();
            }
        });
    }

    public void removeActionListener(ActionListener al) {
        this.L.removeActionListener(al);
    }

    public void clear() {
        this.L.clear();
    }

    public void addElement(Element el) {
        this.L.add(el);
    }

    public int getSelectedIndex() {
        if (this.L.Selected.size() > 0) {
            return (Integer)this.L.Selected.elementAt(0);
        }
        return -1;
    }

    public String getSelectedItem() {
        int n = this.getSelectedIndex();
        if (n < 0) {
            return null;
        }
        return this.L.getElementAt(n).getElementString();
    }

    public int[] getSelectedIndices() {
        int[] k = new int[this.L.Selected.size()];
        for (int i = 0; i < k.length; ++i) {
            k[i] = (Integer)this.L.Selected.elementAt(i);
        }
        return k;
    }

    public void showLast() {
        this.L.showLast();
    }

    public void setMode(boolean multiple, boolean easymultiple, boolean singleclick, boolean rightmouse) {
        this.L.MultipleSelection = multiple;
        this.L.EasyMultipleSelection = easymultiple;
        this.L.ReportSingleClick = singleclick;
        this.L.RightMouseClick = rightmouse;
    }

    public void save(PrintWriter o) {
        this.L.save(o);
    }

    public void select(int sel) {
    }

    public void addElement(String name, Color col) {
        this.addElement(new StringElement(name, col));
    }

    public void addElement(String name) {
        this.addElement(new StringElement(name));
    }

    public void setState(int s) {
        this.L.setState(s);
    }

    public void setListingBackground(Color c2) {
        this.L.setListingBackground(c2);
    }
}

