/*
 * Decompiled with CFR 0.152.
 */
package carmetal.objects;

import carmetal.construction.Construction;
import carmetal.construction.Count;
import carmetal.objects.AngleObject;
import carmetal.objects.ConstructionObject;
import carmetal.objects.MoveableObject;
import carmetal.rene.gui.Global;
import carmetal.rene.util.xml.XmlWriter;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.expression.Expression;
import carmetal.rene.zirkel.expression.ExpressionString;
import carmetal.rene.zirkel.graphics.MyGraphics;
import carmetal.rene.zirkel.graphics.MyGraphics13;
import java.awt.Color;
import java.awt.FontMetrics;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Vector;

public class TextObject
extends ConstructionObject
implements MoveableObject {
    protected double X;
    protected double Y;
    Vector<String> T;
    static Count N = new Count();
    double C;
    double R;
    double W;
    double H;
    protected Expression EX;
    protected Expression EY;
    protected boolean Fixed;
    protected boolean DoShow;
    double oldx;
    double oldy;
    double startx;
    double starty;

    public TextObject(Construction c2, String text, double x, double y) {
        super(c2);
        this.X = x;
        this.Y = y;
        this.T = new Vector();
        this.setColor(this.ColorIndex, this.SpecialColor);
        this.Valid = true;
        this.setLines(text);
        this.setFixed(Double.toString(x), Double.toString(y));
    }

    public TextObject(Construction c2, double x, double y) {
        super(c2);
        this.X = x;
        this.Y = y;
        this.T = new Vector();
        this.setColor(this.ColorIndex, this.SpecialColor);
        this.Valid = true;
        this.setLines("<txt>");
        this.setFixed(Double.toString(x), Double.toString(y));
    }

    @Override
    public void setDefaults() {
        this.setShowName(true);
        this.setShowValue(true);
        this.setColor(Global.getParameter("options.text.color", 0), Global.getParameter("options.text.pcolor", (Color)null));
        this.setColorType(Global.getParameter("options.text.colortype", 0));
        this.setHidden(this.Cn.Hidden);
        this.setObtuse(this.Cn.Obtuse);
        this.setSolid(this.Cn.Solid);
        this.setLarge(this.Cn.LargeFont);
        this.setBold(this.Cn.BoldFont);
        this.setPartial(this.Cn.Partial);
    }

    @Override
    public void setTargetDefaults() {
        this.setShowName(true);
        this.setShowValue(true);
        this.setColor(Global.getParameter("options.text.color", 0), Global.getParameter("options.text.pcolor", (Color)null));
        this.setColorType(Global.getParameter("options.text.colortype", 0));
    }

    @Override
    public boolean nearto(int x, int y, ZirkelCanvas zc) {
        if (!this.displays(zc)) {
            return false;
        }
        return this.C <= (double)x && this.R <= (double)y && (double)x <= this.C + this.W && (double)y <= this.R + this.H;
    }

    @Override
    public String getTag() {
        return "Text";
    }

    @Override
    public int getN() {
        return N.next();
    }

    @Override
    public void updateText() {
        this.setText(this.getLines(), true);
    }

    @Override
    public void move(double x, double y) {
        this.X = x;
        this.Y = y;
    }

    @Override
    public void paint(MyGraphics g, ZirkelCanvas zc) {
        this.C = zc.col(this.X);
        this.R = zc.row(this.Y);
        if (this.mustHide(zc)) {
            return;
        }
        boolean hidden = this.Hidden;
        if (this.DoShow) {
            this.Hidden = false;
        }
        g.setColor(this);
        this.setFont(g);
        if (this.DoShow) {
            this.Hidden = hidden;
        }
        FontMetrics fm = g.getFontMetrics();
        this.W = this.H = (double)fm.getHeight();
        Enumeration<String> e2 = this.T.elements();
        double r = this.R;
        while (e2.hasMoreElements()) {
            String s = ((ExpressionString)((Object)e2.nextElement())).evaluate();
            boolean bold = false;
            boolean large = false;
            if (s.startsWith("***")) {
                s = s.substring(3);
                large = true;
                bold = true;
            } else if (s.startsWith("**")) {
                s = s.substring(2);
                large = true;
            } else if (s.startsWith("*")) {
                s = s.substring(1);
                bold = true;
            }
            if (g instanceof MyGraphics13) {
                if (this.isStrongSelected()) {
                    ((MyGraphics13)g).drawMarkerRect(this.C, r, 10.0, 10.0);
                    g.setColor(this);
                }
                g.setFont(large, bold);
                r += (double)((MyGraphics13)g).drawStringExtended(s, this.C, r);
                this.W = Math.max(this.W, (double)((MyGraphics13)g).getW());
                continue;
            }
            g.setFont(large, bold);
            fm = g.getFontMetrics();
            fm.getHeight();
            g.drawString(AngleObject.translateToUnicode(s), this.C, r);
            r += this.H;
        }
        this.H = r - this.R;
    }

    @Override
    public boolean mustHide(ZirkelCanvas zc) {
        return super.mustHide(zc) && (!this.Valid || !this.DoShow);
    }

    @Override
    public void validate() {
        this.Valid = true;
        if (this.Fixed && this.EX != null && this.EX.isValid()) {
            try {
                this.X = this.EX.getValue();
            }
            catch (Exception e2) {
                this.Valid = false;
                return;
            }
        }
        if (this.Fixed && this.EY != null && this.EY.isValid()) {
            try {
                this.Y = this.EY.getValue();
            }
            catch (Exception e3) {
                this.Valid = false;
                return;
            }
        }
    }

    @Override
    public String getLines() {
        String S = "";
        Enumeration<String> e2 = this.T.elements();
        while (e2.hasMoreElements()) {
            String s = ((ExpressionString)((Object)e2.nextElement())).toString();
            S = S + s;
            if (!e2.hasMoreElements()) continue;
            S = S + "\n";
        }
        return S;
    }

    @Override
    public void setLines(String o) {
        if (o.equals("")) {
            o = "<txt>";
        }
        Vector<ExpressionString> w = new Vector<ExpressionString>();
        try {
            String s;
            BufferedReader in = new BufferedReader(new StringReader(o));
            while ((s = in.readLine()) != null) {
                w.addElement(new ExpressionString(s, this));
            }
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.T = w;
        this.updateText();
    }

    @Override
    public String getDisplayValue() {
        return "(" + this.roundDisplay(this.X) + "," + this.roundDisplay(this.Y) + ")";
    }

    @Override
    public double getX() {
        return this.X;
    }

    @Override
    public double getY() {
        return this.Y;
    }

    @Override
    public void printArgs(XmlWriter xml) {
        if (this.Fixed && this.EX != null && this.EX.isValid()) {
            xml.printArg("x", this.EX.toString());
        } else {
            xml.printArg("x", "" + this.X);
        }
        if (this.Fixed && this.EY != null && this.EY.isValid()) {
            xml.printArg("y", this.EY.toString());
        } else {
            xml.printArg("y", "" + this.Y);
        }
        if (this.Fixed) {
            xml.printArg("fixed", "true");
        }
    }

    @Override
    public boolean moveable() {
        return !this.Fixed;
    }

    @Override
    public boolean fixed() {
        return this.Fixed;
    }

    @Override
    public void setFixed(boolean flag) {
        this.Fixed = flag;
        if (!this.Fixed) {
            this.EY = null;
            this.EX = null;
        }
        this.updateText();
    }

    @Override
    public void setFixed(String x, String y) {
        this.Fixed = true;
        this.EX = new Expression(x, this.getConstruction(), this);
        this.EY = new Expression(y, this.getConstruction(), this);
        this.updateText();
    }

    @Override
    public String getEX() {
        if (this.EX != null) {
            return this.EX.toString();
        }
        return "" + this.round(this.X);
    }

    @Override
    public String getEY() {
        if (this.EY != null) {
            return this.EY.toString();
        }
        return "" + this.round(this.Y);
    }

    public void setDoShow(boolean flag) {
        this.DoShow = flag;
    }

    @Override
    public void snap(ZirkelCanvas zc) {
        double d2 = zc.getGridSize() / 2.0;
        this.X = (double)Math.round(this.X / d2) * d2;
        this.Y = (double)Math.round(this.Y / d2) * d2;
    }

    @Override
    public void translate() {
        if (this.Fixed) {
            try {
                this.setFixed(this.EX.toString(), this.EY.toString());
                this.EX.translate();
                this.EY.translate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public Enumeration depending() {
        super.depending();
        Enumeration<String> e2 = this.T.elements();
        while (e2.hasMoreElements()) {
            ((ExpressionString)((Object)e2.nextElement())).addDep(this);
        }
        if (this.Fixed) {
            if (this.EX != null) {
                this.EX.addDep(this);
            }
            if (this.EY != null) {
                this.EY.addDep(this);
            }
        }
        return DL.elements();
    }

    @Override
    public boolean canDisplayName() {
        return false;
    }

    @Override
    public void startDrag(double x, double y) {
        this.oldx = this.X;
        this.oldy = this.Y;
        this.startx = x;
        this.starty = y;
    }

    @Override
    public void dragTo(double x, double y) {
        this.move(this.oldx + (x - this.startx), this.oldy + (y - this.starty));
    }

    @Override
    public double getOldX() {
        return this.oldx;
    }

    @Override
    public double getOldY() {
        return this.oldy;
    }
}

