/*
 * Decompiled with CFR 0.152.
 */
package carmetal.objects;

import carmetal.construction.Construction;
import carmetal.objects.AreaObject;
import carmetal.objects.ConstructionObject;
import carmetal.objects.DriverObject;
import carmetal.objects.ExpressionObject;
import carmetal.objects.FunctionObject;
import carmetal.objects.HeavyObject;
import carmetal.objects.PointObject;
import carmetal.objects.PrimitiveCircleObject;
import carmetal.objects.PrimitiveLineObject;
import carmetal.objects.QuadricObject;
import carmetal.objects.RayObject;
import carmetal.objects.SegmentObject;
import carmetal.objects.TrackObject;
import carmetal.rene.gui.Global;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.graphics.MyGraphics;
import carmetal.rene.zirkel.graphics.PolygonDrawer;
import carmetal.rene.zirkel.structures.Coordinates;
import java.util.Enumeration;
import java.util.Vector;

public class JLocusTrackObject
extends TrackObject
implements HeavyObject {
    Coordinates C;
    PolygonDrawer pd;
    double c0;
    double r0;
    double c;
    double r;
    ExpressionObject EO;
    Vector RefreshList = new Vector();
    Vector DriverObjectList = new Vector();
    boolean Special = false;
    double cx;
    double cy;
    double ww;
    double wh;
    long time = 0L;
    private static double a = 5.0;
    private static double b = 6.0;
    private static double xmin = -b + 1.0E-4;
    private Coordinates oldC = new Coordinates();

    public JLocusTrackObject(Construction c2, ConstructionObject p, ConstructionObject[] po, int pn, ConstructionObject o, PointObject pm) {
        super(c2);
        this.P = p;
        this.PN = pn;
        for (int i = 0; i < this.PN; ++i) {
            this.PO[i] = po[i];
        }
        this.O = o;
        this.PM = pm;
        this.validate();
        this.updateText();
        this.cx = c2.getX();
        this.cy = c2.getY();
        this.ww = c2.getW();
        this.wh = c2.getH();
        this.searchDependencies(c2);
    }

    @Override
    public void searchDependencies(Construction c2) {
        this.RefreshList.clear();
        this.DriverObjectList.clear();
        if (this.O instanceof SegmentObject) {
            this.searchDependencies(c2, this, this.PM);
        } else if (this.O instanceof ExpressionObject) {
            this.searchDependencies(c2, this, null);
        } else if (this.O instanceof RayObject) {
            this.searchDependencies(c2, this, this.PM);
        } else if (this.O instanceof PrimitiveLineObject) {
            this.searchDependencies(c2, this, this.PM);
        } else if (this.O instanceof PrimitiveCircleObject) {
            this.searchDependencies(c2, this, this.PM);
        } else if (this.O instanceof QuadricObject) {
            this.searchDependencies(c2, this, this.PM);
        } else if (this.O instanceof TrackObject) {
            this.searchDependencies(c2, this, this.PM);
        } else if (this.O instanceof AreaObject) {
            this.searchDependencies(c2, this, this.PM);
        } else if (this.O instanceof FunctionObject) {
            this.searchDependencies(c2, this, this.PM);
        }
        this.NeedsRecompute = true;
    }

    public void searchDependencies(Construction c2, ConstructionObject o, ConstructionObject avoid) {
        if (o.RekValidating) {
            return;
        }
        o.RekValidating = true;
        Enumeration e2 = c2.elements();
        while (e2.hasMoreElements()) {
            ((ConstructionObject)e2.nextElement()).setRekFlag(false);
        }
        this.recursiveSearchDependencies(o, avoid);
        e2 = c2.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject oc = (ConstructionObject)e2.nextElement();
            if (!oc.isRekFlag()) continue;
            this.RefreshList.addElement(oc);
            if (oc == this.P || !oc.isDriverObject()) continue;
            this.DriverObjectList.addElement(oc);
        }
        o.RekValidating = false;
    }

    public void recursiveSearchDependencies(ConstructionObject o, ConstructionObject avoid) {
        ConstructionObject[] d2;
        if (o.isRekFlag() || o == avoid) {
            return;
        }
        o.setRekFlag(true);
        for (ConstructionObject element : d2 = o.getDepArray()) {
            this.recursiveSearchDependencies(element, avoid);
        }
    }

    @Override
    public boolean needsToRecompute() {
        boolean needs = false;
        Enumeration pl = this.DriverObjectList.elements();
        while (pl.hasMoreElements()) {
            DriverObject oc = (DriverObject)pl.nextElement();
            if (!oc.somethingChanged()) continue;
            Global.addClearList(oc);
            needs = true;
        }
        if (this.Cn.getX() != this.cx || this.Cn.getY() != this.cy || this.Cn.getW() != this.ww || this.Cn.getH() != this.wh) {
            this.cx = this.Cn.getX();
            this.cy = this.Cn.getY();
            this.ww = this.Cn.getW();
            this.wh = this.Cn.getH();
            needs = true;
        }
        if (this.NeedsRecompute) {
            this.NeedsRecompute = false;
            return true;
        }
        return needs;
    }

    public synchronized void refresh() {
        Enumeration e2 = this.RefreshList.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject oc = (ConstructionObject)e2.nextElement();
            oc.NeedsRecompute = true;
            oc.validate();
        }
    }

    private static void setConstants(Construction c2) {
        double r;
        double dx = c2.getW() * 2.0;
        double dy = c2.getH();
        a = r = Math.sqrt(dx * dx + dy * dy);
        b = 1.5 * a;
        xmin = -b + (b - a) / 1000.0;
    }

    public static double fline(double x) {
        if (Math.abs(x) < a) {
            return x;
        }
        double s = Math.signum(x);
        return s * (2.0 * a - b) + (b - a) * (b - a) / (s * b - x);
    }

    @Override
    public void addCoordinates(Vector v, ConstructionObject p) {
        if (p.valid()) {
            this.oldC = new Coordinates(p.getX(), p.getY());
            v.addElement(this.oldC);
        } else if (!Double.isNaN(this.oldC.X)) {
            this.oldC = new Coordinates();
            v.addElement(this.oldC);
        }
    }

    public synchronized void docomputeCircle() {
        double dt;
        double a1;
        PrimitiveCircleObject CO = (PrimitiveCircleObject)this.O;
        double x = CO.getX();
        double y = CO.getY();
        double RO = CO.getR();
        if (CO.hasRange()) {
            double d2;
            a1 = CO.getA1();
            double a2 = CO.getA2();
            for (d2 = a2 - a1; d2 < 0.0; d2 += Math.PI * 2) {
            }
            while (d2 >= Math.PI * 2) {
                d2 -= Math.PI * 2;
            }
            dt = d2 * this.DMin;
            a1 += 1.0E-11;
        } else {
            dt = Math.PI * 2 * this.DMin;
            a1 = 0.0;
        }
        int nbsteps = (int)Math.round(1.0 / this.DMin) + 1;
        for (int i = 0; i < nbsteps; ++i) {
            this.PM.move(x + RO * Math.cos(a1 + (double)i * dt), y + RO * Math.sin(a1 + (double)i * dt));
            this.refresh();
            this.addCoordinates(this.V, this.P);
        }
    }

    public synchronized void docomputeLine() {
        this.Cn.shouldSwitch(false);
        PrimitiveLineObject l = (PrimitiveLineObject)this.O;
        JLocusTrackObject.setConstants(this.Cn);
        double da = -2.0 * xmin * this.DMin;
        double lx = l.getX();
        double ly = l.getY();
        double ldx = l.getDX();
        double ldy = l.getDY();
        int nbsteps = (int)Math.round(1.0 / this.DMin) + 1;
        for (int i = 0; i < nbsteps; ++i) {
            double delta = JLocusTrackObject.fline(xmin + (double)i * da);
            this.PM.move(lx + ldx * delta, ly + ldy * delta);
            this.refresh();
            this.addCoordinates(this.V, this.P);
        }
    }

    public synchronized void docomputeRay() {
        this.Cn.shouldSwitch(false);
        PrimitiveLineObject l = (PrimitiveLineObject)this.O;
        JLocusTrackObject.setConstants(this.Cn);
        double da = -xmin * this.DMin;
        double lx = l.getX();
        double ly = l.getY();
        double ldx = l.getDX();
        double ldy = l.getDY();
        int nbsteps = (int)Math.round(1.0 / this.DMin) + 1;
        for (int i = 0; i < nbsteps; ++i) {
            double delta = JLocusTrackObject.fline((double)i * da);
            this.PM.move(lx + ldx * delta, ly + ldy * delta);
            this.refresh();
            this.addCoordinates(this.V, this.P);
        }
    }

    public synchronized void docomputeSegments() {
        this.Cn.shouldSwitch(false);
        PrimitiveLineObject l = (PrimitiveLineObject)this.O;
        double r = ((SegmentObject)l).getLength();
        double lx = l.getX();
        double ly = l.getY();
        double ldx = r * l.getDX() * this.DMin;
        double ldy = r * l.getDY() * this.DMin;
        int nbsteps = (int)Math.round(1.0 / this.DMin) + 1;
        for (int i = 0; i < nbsteps; ++i) {
            this.PM.move(lx + ldx * (double)i, ly + ldy * (double)i);
            this.refresh();
            this.addCoordinates(this.V, this.P);
        }
    }

    public synchronized void docomputeQuadric() {
        this.Cn.shouldSwitch(false);
        QuadricObject q = (QuadricObject)this.O;
        double A = q.X[0];
        double B = q.X[1];
        double C = q.X[2];
        double D = q.X[3];
        double E = q.X[4];
        double F = q.X[5];
        double dt = Math.PI * this.DMin;
        double X1 = q.P[0].getX();
        double Y1 = q.P[0].getY();
        double M = 0.0;
        double N2 = 0.0;
        double P1 = 0.0;
        int nbsteps = (int)Math.round(1.0 / this.DMin) + 1;
        for (int i = 0; i < nbsteps; ++i) {
            M = -Math.sin((double)i * dt + 0.01);
            N2 = Math.cos((double)i * dt + 0.01);
            P1 = -(M * X1 + N2 * Y1);
            double x1 = 0.0;
            double x2 = 0.0;
            double y1 = 0.0;
            double y2 = 0.0;
            double part1 = -2.0 * B * M * P1 - C * N2 * N2 + D * M * N2 + E * N2 * P1;
            double part2 = Math.abs(N2) * Math.sqrt(-2.0 * M * D * N2 * C + 4.0 * P1 * D * A * N2 + 4.0 * P1 * M * B * C + 4.0 * E * M * N2 * F - 2.0 * E * P1 * N2 * C - 2.0 * E * P1 * M * D - 4.0 * M * M * B * F - 4.0 * P1 * P1 * A * B - 4.0 * A * N2 * N2 * F + N2 * N2 * C * C + M * M * D * D + E * E * P1 * P1);
            double part3 = 2.0 * A * N2 * N2 + 2.0 * B * M * M + -2.0 * E * M * N2;
            x1 = (part1 + part2) / part3;
            y1 = (-M * x1 - P1) / N2;
            x2 = (part1 - part2) / part3;
            y2 = (-M * x2 - P1) / N2;
            if ((x2 - x1) / N2 < 0.0) {
                double c1 = x1;
                double r1 = y1;
                x1 = x2;
                y1 = y2;
                x2 = c1;
                y2 = r1;
            }
            if (Math.abs(X1 - x1) < 1.0E-10 && Math.abs(X1 - x1) < 1.0E-10) {
                this.PM.move(x2, y2);
            } else {
                this.PM.move(x1, y1);
            }
            this.refresh();
            this.addCoordinates(this.V, this.P);
        }
    }

    public synchronized void docomputeExpression() {
        this.Cn.shouldSwitch(false);
        this.EO = (ExpressionObject)this.O;
        if (!this.EO.isSlider()) {
            return;
        }
        int nbsteps = (int)Math.round(1.0 / this.DMin) + 1;
        for (int i = 0; i < nbsteps; ++i) {
            this.EO.setSliderPosition(this.DMin * (double)i);
            this.refresh();
            this.addCoordinates(this.V, this.P);
        }
    }

    public synchronized void docomputeTrack() {
        this.Cn.shouldSwitch(false);
        JLocusTrackObject TR = (JLocusTrackObject)this.O;
        if (this.DMin != TR.DMin) {
            TR.DMin = this.DMin;
            TR.compute();
        }
        Enumeration e2 = TR.V.elements();
        while (e2.hasMoreElements()) {
            this.C = (Coordinates)e2.nextElement();
            this.PM.move(this.C.X, this.C.Y);
            this.refresh();
            this.addCoordinates(this.V, this.P);
        }
    }

    public synchronized void docomputeFunction() {
        this.Cn.shouldSwitch(false);
        FunctionObject FO = (FunctionObject)this.O;
        Enumeration e2 = FO.V.elements();
        while (e2.hasMoreElements()) {
            this.C = (Coordinates)e2.nextElement();
            this.PM.move(this.C.X, this.C.Y);
            this.refresh();
            this.addCoordinates(this.V, this.P);
        }
    }

    public synchronized void docomputeArea() {
        double yB;
        double xB;
        double yA;
        double xA;
        PointObject ORIGIN;
        this.Cn.shouldSwitch(false);
        AreaObject poly = (AreaObject)this.O;
        int NVertex = poly.V.size();
        int nbsteps = (int)Math.round(1.0 / (this.DMin * (double)NVertex));
        if (nbsteps < 2) {
            nbsteps = 2;
        }
        PointObject A = ORIGIN = poly.V.get(0);
        PointObject B = null;
        for (int n = 1; n < NVertex; ++n) {
            B = poly.V.get(n);
            xA = A.getX();
            yA = A.getY();
            xB = B.getX();
            yB = B.getY();
            for (int i = 0; i <= nbsteps; ++i) {
                this.PM.move(xA + (double)i * (xB - xA) / (double)nbsteps, yA + (double)i * (yB - yA) / (double)nbsteps);
                this.refresh();
                this.addCoordinates(this.V, this.P);
            }
            A = B;
        }
        xA = A.getX();
        yA = A.getY();
        xB = ORIGIN.getX();
        yB = ORIGIN.getY();
        for (int i = 0; i <= nbsteps; ++i) {
            this.PM.move(xA + (double)i * (xB - xA) / (double)nbsteps, yA + (double)i * (yB - yA) / (double)nbsteps);
            this.refresh();
            this.addCoordinates(this.V, this.P);
        }
    }

    @Override
    public synchronized void compute(ZirkelCanvas zc) {
        this.compute();
    }

    @Override
    public synchronized void compute() {
        if (this.Fixed && !this.StartFix) {
            return;
        }
        this.V = new Vector();
        this.oldC = new Coordinates();
        this.StartFix = false;
        double x = 0.0;
        double y = 0.0;
        if (this.PM != null) {
            x = this.PM.getX();
            y = this.PM.getY();
        }
        this.Cn.clearSwitches();
        this.Cn.shouldSwitch(true);
        this.DontProject = true;
        if (this.O instanceof SegmentObject) {
            this.docomputeSegments();
        } else if (this.O instanceof QuadricObject) {
            this.docomputeQuadric();
        } else if (this.O instanceof JLocusTrackObject) {
            this.docomputeTrack();
        } else if (this.O instanceof AreaObject) {
            this.docomputeArea();
        } else if (this.O instanceof ExpressionObject) {
            this.docomputeExpression();
        } else if (this.O instanceof RayObject) {
            this.docomputeRay();
        } else if (this.O instanceof PrimitiveCircleObject) {
            this.docomputeCircle();
        } else if (this.O instanceof PrimitiveLineObject) {
            this.docomputeLine();
        } else if (this.O instanceof FunctionObject) {
            this.docomputeFunction();
        }
        this.DontProject = false;
        if (this.PM != null) {
            this.PM.move(x, y);
            this.refresh();
        }
        this.Cn.dovalidate();
    }

    @Override
    public void paint(MyGraphics g, ZirkelCanvas zc) {
        if (!this.Valid || this.mustHide(zc)) {
            return;
        }
        Enumeration e2 = this.V.elements();
        if (this.indicated()) {
            boolean sel = this.P.indicated();
            this.P.setIndicated(true);
            g.setColor(this.P);
            this.P.setIndicated(sel);
        } else {
            g.setColor(this);
        }
        if (this.Special) {
            while (e2.hasMoreElements()) {
                Coordinates C = (Coordinates)e2.nextElement();
                PointObject.drawPoint(g, zc, this, C.X, C.Y, this.Type);
            }
        } else {
            Coordinates C;
            PolygonDrawer pd = new PolygonDrawer(g, this);
            if (e2.hasMoreElements()) {
                C = (Coordinates)e2.nextElement();
                this.c0 = zc.col(C.X);
                this.r0 = zc.row(C.Y);
                pd.startPolygon(this.c0, this.r0);
            }
            while (e2.hasMoreElements()) {
                C = (Coordinates)e2.nextElement();
                double c2 = zc.col(C.X);
                double r = zc.row(C.Y);
                if (Math.abs(pd.c() - c2) < 1000.0 && Math.abs(pd.r() - r) < 1000.0) {
                    pd.drawTo(c2, r);
                    continue;
                }
                pd.finishPolygon();
                pd.startPolygon(c2, r);
            }
            pd.finishPolygon();
        }
    }

    @Override
    public boolean isSpecial() {
        return this.Special;
    }

    @Override
    public void setSpecial(boolean f2) {
        this.Special = f2;
    }

    @Override
    public boolean equals(ConstructionObject o) {
        if (!(o instanceof JLocusTrackObject) || !o.valid()) {
            return false;
        }
        JLocusTrackObject loc = (JLocusTrackObject)o;
        if (this.V.size() != loc.V.size()) {
            return false;
        }
        Enumeration e1 = this.V.elements();
        Enumeration e2 = loc.V.elements();
        while (e1.hasMoreElements()) {
            Coordinates C1 = (Coordinates)e1.nextElement();
            Coordinates C2 = (Coordinates)e2.nextElement();
            if (!(Math.abs(C1.X - C2.X) > 1.0E-8) && !(Math.abs(C1.Y - C2.Y) > 1.0E-8)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ConstructionObject copy(double x, double y) {
        PointObject newPM = null;
        if (this.PM != null) {
            newPM = (PointObject)this.PM.getTranslation();
        }
        JLocusTrackObject jl = new JLocusTrackObject(this.Cn.getTranslation(), this.P.getTranslation(), this.PO, this.PN, this.O.getTranslation(), newPM);
        jl.setTargetDefaults();
        return jl;
    }
}

