/*
 * Decompiled with CFR 0.152.
 */
package carmetal.objects;

import carmetal.construction.Construction;
import carmetal.construction.ConstructionException;
import carmetal.construction.Count;
import carmetal.objects.AngleObject;
import carmetal.objects.ConstructionObject;
import carmetal.objects.InsideObject;
import carmetal.objects.MoveableObject;
import carmetal.objects.PointObject;
import carmetal.objects.PrimitiveLineObject;
import carmetal.objects.SimulationObject;
import carmetal.rene.gui.Global;
import carmetal.rene.util.xml.XmlWriter;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.expression.Expression;
import carmetal.rene.zirkel.expression.InvalidException;
import carmetal.rene.zirkel.graphics.MyGraphics;
import carmetal.rene.zirkel.graphics.MyGraphics13;
import java.awt.Color;
import java.util.Enumeration;

public class FixedAngleObject
extends PrimitiveLineObject
implements MoveableObject,
SimulationObject,
InsideObject {
    protected PointObject P2;
    static Count N = new Count();
    double A;
    double A1;
    double A2;
    double AA;
    Expression E;
    boolean Filled = false;
    boolean Inverse = false;
    boolean EditAborted = false;
    boolean Dragable = false;
    boolean Reduced = false;
    public static final int NORMALSIZE = 1;
    public static final int SMALL = 0;
    public static final int LARGER = 2;
    public static final int LARGE = 3;
    public static final int RECT = 4;
    protected int DisplaySize = 1;
    double[] xx = new double[4];
    double[] yy = new double[4];

    public FixedAngleObject(Construction c2, PointObject p1, PointObject p2, double x, double y) {
        super(c2);
        this.P1 = p1;
        this.P2 = p2;
        this.init(c2, x, y);
        this.Unit = Global.getParameter("unit.angle", "\u00b0");
    }

    @Override
    public void setDefaults() {
        this.setShowName(Global.getParameter("options.angle.shownames", false));
        this.setShowValue(Global.getParameter("options.angle.showvalues", false));
        this.setColor(Global.getParameter("options.angle.color", 0), Global.getParameter("options.angle.pcolor", (Color)null));
        this.setColorType(Global.getParameter("options.angle.colortype", 0));
        this.setFilled(Global.getParameter("options.angle.filled", false));
        this.setHidden(this.Cn.Hidden);
        this.setObtuse(Global.getParameter("options.angle.obtuse", false));
        this.setSolid(this.Cn.Solid);
        this.setLarge(this.Cn.LargeFont);
        this.setBold(this.Cn.BoldFont);
        this.setPartial(this.Cn.Partial);
    }

    @Override
    public void setTargetDefaults() {
        this.setShowName(Global.getParameter("options.angle.shownames", false));
        this.setShowValue(Global.getParameter("options.angle.showvalues", false));
        this.setColor(Global.getParameter("options.angle.color", 0), Global.getParameter("options.angle.pcolor", (Color)null));
        this.setColorType(Global.getParameter("options.angle.colortype", 0));
        this.setFilled(Global.getParameter("options.angle.filled", false));
        this.setObtuse(Global.getParameter("options.angle.obtuse", false));
    }

    public void init(Construction c2, double x, double y, boolean invert) {
        double dx = this.P1.getX() - this.P2.getX();
        double dy = this.P1.getY() - this.P2.getY();
        this.A1 = Math.atan2(dy, dx);
        dx = x - this.P2.getX();
        dy = y - this.P2.getY();
        this.A2 = Math.atan2(dy, dx);
        this.A = this.A2 - this.A1;
        if (this.A < 0.0) {
            this.A += Math.PI * 2;
        } else if (this.A > Math.PI * 2) {
            this.A -= Math.PI * 2;
        }
        if (this.Inverse && this.Obtuse) {
            this.A = Math.PI * 2 - this.A;
        }
        if (invert && !this.Obtuse) {
            if (this.A > Math.PI) {
                this.A = Math.PI * 2 - this.A;
                this.Inverse = true;
            } else {
                this.Inverse = false;
            }
        }
        this.E = new Expression("" + this.round(this.A / Math.PI * 180.0, ZirkelCanvas.EditFactor), c2, this);
        this.validate();
        this.setColor(this.ColorIndex, this.SpecialColor);
        this.updateText();
    }

    public void init(Construction c2, double x, double y) {
        this.init(c2, x, y, true);
    }

    @Override
    public void paint(MyGraphics g, ZirkelCanvas zc) {
        double dx2;
        double dy1;
        double dx1;
        if (!this.Valid || this.mustHide(zc)) {
            return;
        }
        double xm = (zc.minX() + zc.maxX()) / 2.0;
        double ym = (zc.minY() + zc.maxY()) / 2.0;
        double d2 = (xm - this.X1) * this.DY - (ym - this.Y1) * this.DX;
        double x = xm - d2 * this.DY;
        double y = ym + d2 * this.DX;
        double a2 = Math.max(zc.maxX() - zc.minX(), zc.maxY() - zc.minY());
        if (Math.abs(d2) > a2) {
            return;
        }
        double b2 = (x - this.X1) * this.DX + (y - this.Y1) * this.DY;
        double k1 = b2 - a2;
        double k2 = b2 + a2;
        if (k1 < 0.0) {
            k1 = 0.0;
        }
        if (k1 >= k2) {
            return;
        }
        double c1 = zc.col(this.X1 + k1 * this.DX);
        double c2 = zc.col(this.X1 + k2 * this.DX);
        double r1 = zc.row(this.Y1 + k1 * this.DY);
        double r2 = zc.row(this.Y1 + k2 * this.DY);
        g.setColor(this);
        if (!this.Reduced) {
            g.drawLine(c1, r1, c2, r2, this);
        }
        double R = zc.col(this.getDisplaySize(zc)) - zc.col(0.0);
        c1 = zc.col(this.X1) - R;
        r1 = zc.row(this.Y1) - R;
        String s = AngleObject.translateToUnicode(this.getDisplayText());
        double DA = this.A / Math.PI * 180.0;
        if (DA < 0.0) {
            DA += 360.0;
        } else if (DA >= 360.0) {
            DA -= 360.0;
        }
        if (this.isStrongSelected() && g instanceof MyGraphics13) {
            ((MyGraphics13)g).drawMarkerArc(c1 + R, r1 + R, R, this.A1 / Math.PI * 180.0, DA);
        }
        g.setColor(this);
        if (this.Filled) {
            if (Math.abs(DA - 90.0) < 1.0E-7) {
                dx1 = Math.cos(this.A1);
                dy1 = Math.sin(this.A1);
                dx2 = Math.cos(this.A1 + DA / 180.0 * Math.PI);
                double dy2 = Math.sin(this.A1 + DA / 180.0 * Math.PI);
                double dx3 = dx1 + dx2;
                double dy3 = dy1 + dy2;
                this.xx[0] = c1;
                this.yy[0] = r1;
                this.xx[0] = c1 + R;
                this.yy[0] = r1 + R;
                this.xx[1] = c1 + R + R * dx1;
                this.yy[1] = r1 + R - R * dy1;
                this.xx[2] = c1 + R + R * dx3;
                this.yy[2] = r1 + R - R * dy3;
                this.xx[3] = c1 + R + R * dx2;
                this.yy[3] = r1 + R - R * dy2;
                g.fillPolygon(this.xx, this.yy, 4, false, this.getColorType() != 1, this);
                g.setColor(this);
                g.drawLine(this.xx[1], this.yy[1], this.xx[2], this.yy[2]);
                g.drawLine(this.xx[2], this.yy[2], this.xx[3], this.yy[3]);
            } else {
                g.fillArc(c1, r1, 2.0 * R + 1.0, 2.0 * R + 1.0, this.A1 / Math.PI * 180.0, DA, this.Selected || this.getColorType() == 0, this.getColorType() != 1, true, this);
            }
        } else if (this.DisplaySize == 4) {
            dx1 = Math.cos(this.A1);
            dy1 = Math.sin(this.A1);
            dx2 = Math.cos(this.A1 + DA / 180.0 * Math.PI);
            double dy2 = Math.sin(this.A1 + DA / 180.0 * Math.PI);
            g.drawLine(c1 + R + R * dx1, r1 + R - R * dy1, c1 + R + R * (dx1 + dx2), r1 + R - R * (dy1 + dy2));
            g.drawLine(c1 + R + R * (dx1 + dx2), r1 + R - R * (dy1 + dy2), c1 + R + R * dx2, r1 + R - R * dy2);
        } else if (Math.abs(DA - 90.0) < 1.0E-7) {
            dx1 = Math.cos(this.A1);
            dy1 = Math.sin(this.A1);
            dx2 = Math.cos(this.A1 + DA / 180.0 * Math.PI);
            double dy2 = Math.sin(this.A1 + DA / 180.0 * Math.PI);
            double dx3 = dx1 + dx2;
            double dy3 = dy1 + dy2;
            this.xx[1] = c1 + R + R * dx1;
            this.yy[1] = r1 + R - R * dy1;
            this.xx[2] = c1 + R + R * dx3;
            this.yy[2] = r1 + R - R * dy3;
            this.xx[3] = c1 + R + R * dx2;
            this.yy[3] = r1 + R - R * dy2;
            g.setColor(this);
            g.drawLine(this.xx[1], this.yy[1], this.xx[2], this.yy[2]);
            g.drawLine(this.xx[2], this.yy[2], this.xx[3], this.yy[3]);
        } else {
            g.drawCircleArc(c1 + R, r1 + R, R, this.A1 / Math.PI * 180.0, DA, this);
        }
        if (!s.equals("")) {
            g.setLabelColor(this);
            this.setFont(g);
            this.DisplaysText = true;
            double dx = Math.cos(this.A1 + this.A / 2.0);
            double dy = Math.sin(this.A1 + this.A / 2.0);
            if (this.KeepClose) {
                double dof = Math.sqrt(this.XcOffset * this.XcOffset + this.YcOffset * this.YcOffset);
                this.drawCenteredLabel(g, s, zc, this.X1 + dof * dx, this.Y1 + dof * dy, 0.0, 0.0);
            } else {
                this.drawCenteredLabel(g, s, zc, this.X1 + zc.dx(R * 0.66) * dx, this.Y1 + zc.dy(R * 0.66) * dy, this.XcOffset, this.YcOffset);
            }
        }
    }

    @Override
    public boolean canKeepClose() {
        return true;
    }

    @Override
    public void setKeepClose(double x, double y) {
        this.KeepClose = true;
        this.XcOffset = x - this.X1;
        this.YcOffset = y - this.Y1;
    }

    double getDisplaySize(ZirkelCanvas zc) {
        double R = zc.dx((int)(12.0 * zc.pointSize()));
        if (this.DisplaySize == 0 || this.DisplaySize == 4) {
            R /= 2.0;
        } else if (this.DisplaySize == 2) {
            R *= 2.0;
        } else if (this.DisplaySize == 3) {
            double dx = this.P1.getX() - this.X1;
            double dy = this.P1.getY() - this.Y1;
            R = Math.sqrt(dx * dx + dy * dy);
        }
        return R;
    }

    @Override
    public String getTag() {
        return "Angle";
    }

    @Override
    public int getN() {
        return N.next();
    }

    @Override
    public void updateText() {
        if (this.E == null || !this.E.isValid()) {
            return;
        }
        this.setText(FixedAngleObject.text3(Global.name("text.fixedangle"), this.P1.getName(), this.P2.getName(), this.E.toString()));
    }

    @Override
    public String getDisplayValue() {
        return Global.getLocaleNumber(this.A / Math.PI * 180.0, "angles");
    }

    @Override
    public void validate() {
        double dy;
        if (!this.P1.valid() || !this.P2.valid()) {
            this.Valid = false;
            return;
        }
        this.X1 = this.P2.getX();
        this.Y1 = this.P2.getY();
        double dx = this.P1.getX() - this.X1;
        if (Math.sqrt(dx * dx + (dy = this.P1.getY() - this.Y1) * dy) < 1.0E-9) {
            this.Valid = false;
            return;
        }
        this.A1 = Math.atan2(dy, dx);
        boolean Negative = false;
        try {
            if (this.E != null && this.E.isValid()) {
                this.A = this.E.getValue() / 180.0 * Math.PI;
            }
            if (this.Obtuse) {
                if (this.Inverse) {
                    this.A = -this.A;
                }
            } else {
                if (this.Inverse && Math.sin(this.A) > 0.0) {
                    this.A = -this.A;
                }
                if (!this.Inverse && Math.sin(this.A) < 0.0) {
                    this.A = -this.A;
                }
            }
            if (this.A < 0.0) {
                Negative = true;
            }
            while (this.A < 0.0) {
                this.A += Math.PI * 2;
            }
            while (this.A >= Math.PI * 2) {
                this.A -= Math.PI * 2;
            }
            this.A2 = this.A1 + this.A;
            this.DX = Math.cos(this.A2);
            this.DY = Math.sin(this.A2);
            this.AA = this.A;
        }
        catch (Exception e2) {
            this.Valid = false;
            return;
        }
        if (!this.Obtuse && this.A > Math.PI) {
            this.A1 = this.A2;
            this.A = Math.PI * 2 - this.A;
            this.A2 = this.A1 + this.A;
        } else if (this.Obtuse && Negative) {
            this.A1 = this.A2;
            this.A = Math.PI * 2 - this.A;
            this.A2 = this.A1 + this.A;
        }
        this.Valid = true;
    }

    public double getLength() {
        return this.A;
    }

    @Override
    public void setFixed(String s) {
        this.E = new Expression(s, this.getConstruction(), this);
        this.updateText();
    }

    @Override
    public void round() {
        try {
            this.setFixed(this.round(this.E.getValue(), ZirkelCanvas.AnglesFactor) + "");
            this.validate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setEditFixed(String s) {
        this.E = new Expression(s, this.getConstruction(), this);
        this.updateText();
    }

    @Override
    public boolean canFix() {
        return true;
    }

    @Override
    public void printArgs(XmlWriter xml) {
        xml.printArg("first", this.P1.getName());
        xml.printArg("root", this.P2.getName());
        if (this.DisplaySize == 0) {
            xml.printArg("display", "small");
        }
        if (this.DisplaySize == 3) {
            xml.printArg("display", "large");
        }
        if (this.DisplaySize == 2) {
            xml.printArg("display", "larger");
        }
        if (this.DisplaySize == 4) {
            xml.printArg("display", "rectangle");
        }
        if (this.Filled) {
            xml.printArg("filled", "true");
        }
        if (this.E.isValid()) {
            xml.printArg("fixed", this.E.toString());
        } else {
            xml.printArg("fixed", "" + this.A / Math.PI * 180.0);
        }
        if (!this.Obtuse) {
            xml.printArg("acute", "true");
        }
        if (this.Inverse) {
            xml.printArg("inverse", "true");
        }
        if (this.Reduced) {
            xml.printArg("reduced", "true");
        }
        if (this.Dragable) {
            xml.printArg("dragable", "true");
        }
        super.printArgs(xml);
    }

    @Override
    public boolean nearto(int c2, int r, ZirkelCanvas zc) {
        boolean near;
        if (!this.Valid && this.P2.valid()) {
            return this.P2.nearto(c2, r, zc);
        }
        if (!this.displays(zc)) {
            return false;
        }
        double x = zc.x(c2);
        double y = zc.y(r);
        double d2 = (x - this.X1) * this.DY - (y - this.Y1) * this.DX;
        double e2 = (x - this.X1) * this.DX + (y - this.Y1) * this.DY;
        this.Value = Math.abs(zc.col(zc.minX() + d2) - zc.col(zc.minX()));
        if (!this.Reduced && this.Value < zc.selectionSize() && e2 > 0.0) {
            return true;
        }
        double dx = zc.x(c2) - this.X1;
        double dy = zc.y(r) - this.Y1;
        double size = zc.dx((int)zc.selectionSize());
        double rd = this.getDisplaySize(zc);
        double rr = Math.sqrt(dx * dx + dy * dy);
        if (this.Filled || this.DisplaySize == 4) {
            near = rr < rd + size;
        } else {
            boolean bl = near = Math.abs(rr - rd) < size;
        }
        if (!near) {
            return false;
        }
        if (rd < size) {
            return near;
        }
        double a2 = Math.atan2(dy, dx);
        if (a2 < 0.0) {
            a2 += Math.PI * 2;
        }
        double cc = 0.05;
        if (this.A1 - 0.05 < a2 && this.A2 + 0.05 > a2) {
            return true;
        }
        if (this.A1 - 0.05 < (a2 -= Math.PI * 2) && this.A2 + 0.05 > a2) {
            return true;
        }
        return this.A1 - 0.05 < (a2 += Math.PI * 4) && this.A2 + 0.05 > a2;
    }

    @Override
    public void setDisplaySize(int i) {
        this.DisplaySize = i;
    }

    @Override
    public int getDisplaySize() {
        return this.DisplaySize;
    }

    @Override
    public Enumeration depending() {
        super.depending();
        this.depset(this.P1, this.P2);
        Enumeration e2 = this.E.getDepList().elements();
        while (e2.hasMoreElements()) {
            DL.add((ConstructionObject)e2.nextElement());
        }
        return DL.elements();
    }

    @Override
    public void translate() {
        this.P1 = (PointObject)this.P1.getTranslation();
        this.P2 = (PointObject)this.P2.getTranslation();
        try {
            this.setFixed(this.E.toString());
            this.E.translate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getE() {
        return this.E.toString();
    }

    @Override
    public double getValue() throws ConstructionException {
        if (!this.Valid) {
            throw new InvalidException("exception.invalid");
        }
        return this.A / Math.PI * 180.0;
    }

    @Override
    public void setFilled(boolean flag) {
        this.Filled = flag;
    }

    @Override
    public boolean isFilled() {
        return this.Filled;
    }

    @Override
    public boolean isFilledForSelect() {
        return false;
    }

    @Override
    public boolean contains(double x, double y) {
        double a2 = (x - this.X1) * this.DX + (y - this.Y1) * this.DY;
        return !(a2 < 1.0E-9);
    }

    @Override
    public double project(double x, double y) {
        double h = super.project(x, y);
        if (h < 0.0) {
            return 0.0;
        }
        return h;
    }

    @Override
    public Enumeration points() {
        super.depending();
        return this.depset(this.P2);
    }

    @Override
    public void move(double x, double y) {
        this.init(this.getConstruction(), x, y, true);
    }

    @Override
    public boolean moveable() {
        return this.Dragable;
    }

    @Override
    public boolean isFixed() {
        return true;
    }

    public boolean getInverse() {
        return this.Inverse;
    }

    public void setInverse(boolean inverse) {
        this.Inverse = inverse;
    }

    public boolean isEditAborted() {
        return this.EditAborted;
    }

    @Override
    public boolean isDragable() {
        return this.Dragable;
    }

    @Override
    public void setDragable(boolean f2) {
        this.Dragable = f2;
    }

    public boolean isReduced() {
        return this.Reduced;
    }

    public void setReduced(boolean f2) {
        this.Reduced = f2;
    }

    public boolean fixedByNumber() {
        return this.E != null && this.E.isNumber();
    }

    @Override
    public void setSimulationValue(double x) {
        this.A = x / 180.0 * Math.PI;
        Expression OldE = this.E;
        this.E = null;
        this.validate();
        this.E = OldE;
    }

    @Override
    public void resetSimulationValue() {
        this.validate();
    }

    @Override
    public void startDrag(double x, double y) {
    }

    @Override
    public void dragTo(double x, double y) {
        this.move(x, y);
    }

    @Override
    public double getOldX() {
        return 0.0;
    }

    @Override
    public double getOldY() {
        return 0.0;
    }

    @Override
    public double containsInside(PointObject P) {
        double dx = P.getX() - this.X1;
        double dy = P.getY() - this.Y1;
        double a2 = Math.atan2(dy, dx);
        if (a2 < this.A1) {
            a2 += Math.PI * 2;
        }
        double c2 = 1.0E-5;
        if (a2 > this.A1 && a2 < this.A1 + this.A) {
            return 1.0;
        }
        if (a2 > this.A1 - 1.0E-5 && a2 < this.A1 + this.A + 1.0E-5) {
            return 0.5;
        }
        return 0.0;
    }

    @Override
    public boolean keepInside(PointObject P) {
        double yh;
        double xh;
        double dist;
        double y2;
        double dy;
        double r;
        if (this.containsInside(P) > 0.0) {
            return true;
        }
        double x = P.getX();
        double y = P.getY();
        double x1 = this.X1;
        double y1 = this.Y1;
        double xmin = x1;
        double ymin = y1;
        double dmin = 1.0E20;
        double x2 = this.X1 + Math.cos(this.A1);
        double dx = x2 - x1;
        double h = dx * (x - x1) / (r = dx * dx + (dy = (y2 = this.Y1 + Math.sin(this.A1)) - y1) * dy) + dy * (y - y1) / r;
        if (h < 0.0) {
            h = 0.0;
        }
        if ((dist = Math.sqrt((x - (xh = x1 + h * dx)) * (x - xh) + (y - (yh = y1 + h * dy)) * (y - yh))) < dmin) {
            dmin = dist;
            xmin = xh;
            ymin = yh;
        }
        if ((h = (dx = (x2 = this.X1 + Math.cos(this.A2)) - x1) * (x - x1) / (r = dx * dx + (dy = (y2 = this.Y1 + Math.sin(this.A2)) - y1) * dy) + dy * (y - y1) / r) < 0.0) {
            h = 0.0;
        }
        if ((dist = Math.sqrt((x - (xh = x1 + h * dx)) * (x - xh) + (y - (yh = y1 + h * dy)) * (y - yh))) < dmin) {
            dmin = dist;
            xmin = xh;
            ymin = yh;
        }
        P.move(xmin, ymin);
        return false;
    }
}

