/*
 * Decompiled with CFR 0.152.
 */
package carmetal.objects;

import carmetal.construction.Construction;
import carmetal.objects.PointObject;
import carmetal.objects.PrimitiveLineObject;
import carmetal.rene.util.xml.XmlWriter;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.graphics.MyGraphics;
import java.util.Enumeration;

public class AxisObject
extends PrimitiveLineObject {
    double x1;
    double y1;
    double x2;
    double y2;
    double x3;
    double y3;

    public AxisObject(Construction c2, boolean xaxis) {
        super(c2, xaxis ? "xAxis" : "yAxis");
        this.X1 = 0.0;
        this.Y1 = 0.0;
        if (xaxis) {
            this.DX = 1.0;
            this.DY = 0.0;
        } else {
            this.DX = 0.0;
            this.DY = 1.0;
        }
        this.updateText();
    }

    @Override
    public void setName() {
    }

    @Override
    public boolean nearto(int c2, int r, ZirkelCanvas zc) {
        if (!this.displays(zc)) {
            return false;
        }
        if (!zc.getAxis_show()) {
            return false;
        }
        double x = zc.x(c2);
        double y = zc.y(r);
        double d2 = (x - this.X1) * this.DY - (y - this.Y1) * this.DX;
        this.Value = Math.abs(zc.col(zc.minX() + d2) - zc.col(zc.minX()));
        return this.Value < zc.selectionSize() * 2.0;
    }

    @Override
    public void printArgs(XmlWriter xml) {
        if (this.DX == 1.0) {
            xml.printArg("xaxis", "true");
        } else {
            xml.printArg("yaxis", "true");
        }
    }

    @Override
    public Enumeration depending() {
        DL.reset();
        return DL.elements();
    }

    public double getLength() {
        return 0.0;
    }

    @Override
    public void translate() {
        this.P1 = (PointObject)this.P1.getTranslation();
    }

    @Override
    public boolean contains(PointObject p) {
        return false;
    }

    @Override
    public void paint(MyGraphics g, ZirkelCanvas zc) {
        if (!this.Valid || this.mustHide(zc)) {
            return;
        }
        if (zc.getAxis_show() && this.indicated()) {
            g.setColor(this);
            if (this.DX == 1.0) {
                g.drawLine(0.0, zc.row(0.0), zc.IW, zc.row(0.0), this);
            } else {
                g.drawLine(zc.col(0.0), 0.0, zc.col(0.0), zc.IH, this);
            }
        }
    }

    @Override
    public void updateText() {
        if (this.DX == 1.0) {
            this.setText("X axis");
        } else {
            this.setText("Y axis");
        }
    }

    public void dragTo(double x, double y) {
    }

    @Override
    public void move(double x, double y) {
    }

    public boolean moveable() {
        return false;
    }

    public void startDrag(double x, double y) {
    }

    @Override
    public void snap(ZirkelCanvas zc) {
    }

    public double getOldX() {
        return 0.0;
    }

    public double getOldY() {
        return 0.0;
    }
}

