/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric.controls;

import carmetal.eric.controls.JCanvasPanel;
import carmetal.objects.ExpressionObject;
import carmetal.rene.gui.Global;
import carmetal.rene.util.xml.XmlWriter;
import carmetal.rene.zirkel.ZirkelCanvas;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalComboBoxUI;

public class JCanvasPopup
extends JCanvasPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    MyJComboBox JCB;

    public JCanvasPopup(ZirkelCanvas zc, ExpressionObject o) {
        super(zc, o);
        this.JSL = new MyJComboBox();
        this.JCB = (MyJComboBox)this.JSL;
        this.JCB.setUI((ComboBoxUI)MyComboBoxUI.createUI(this.JCB));
        this.JCB.addMouseListener(this);
        this.JCB.addMouseMotionListener(this);
        this.JCB.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                if (JCanvasPopup.this.isEditMode()) {
                    JCanvasPopup.this.JCB.hidePopup();
                }
            }
        });
        this.addMouseEvents();
        this.JCB.addActionListener(this);
        this.showval = false;
        this.showunit = false;
        this.showcom = true;
        this.setComment(Global.Loc("props.expl") + " ");
        this.setVal(1.0);
        this.add(this.JCPlabel);
        this.add(this.JCB);
        this.add(this.JCPresize);
        zc.add(this);
    }

    public void addMouseEvents() {
        for (int i = 0; i < this.JCB.getComponentCount(); ++i) {
            this.JCB.getComponent(i).addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e2) {
                    if (JCanvasPopup.this.isEditMode()) {
                        JCanvasPopup.this.JCB.hidePopup();
                    }
                }
            });
            this.JCB.getComponent(i).addMouseListener(this);
            this.JCB.getComponent(i).addMouseMotionListener(this);
        }
    }

    public String getItems() {
        String s = "";
        for (int i = 0; i < this.JCB.getItemCount() - 1; ++i) {
            s = s + this.JCB.getItemAt(i) + "\n";
        }
        s = s + this.JCB.getItemAt(this.JCB.getItemCount() - 1);
        return s;
    }

    public void setItems(String s) {
        String[] itms;
        this.JCB.removeAllItems();
        for (String itm : itms = s.split("\n")) {
            this.JCB.addItem(itm);
        }
        this.setDims();
    }

    @Override
    public double getVal() {
        return this.JCB.getSelectedIndex() + 1;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (e2.getSource() == this.JCB) {
            int selectedIndex = this.JCB.getSelectedIndex() + 1;
            try {
                this.setVal(selectedIndex);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void PrintXmlTags(XmlWriter xml) {
        xml.startTagStart("CTRLpopup");
        super.PrintXmlTags(xml);
        String s = this.getItems().replace("\n", "@@@");
        xml.printArg("Items", "" + s);
        xml.finishTagNewLine();
    }

    class MyJComboBox
    extends JComboBox {
        private static final long serialVersionUID = 1L;

        MyJComboBox() {
            this.setFocusable(false);
            this.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3"}));
        }
    }

    static class MyComboBoxUI
    extends MetalComboBoxUI {
        MyComboBoxUI() {
        }

        public static ComponentUI createUI(JComponent c2) {
            return new MyComboBoxUI();
        }
    }
}

