/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric;

import carmetal.construction.Construction;
import carmetal.construction.ConstructionDisplayPanel;
import carmetal.eric.FileTools;
import carmetal.eric.GUI.palette.PaletteManager;
import carmetal.eric.GUI.pipe_tools;
import carmetal.eric.GUI.themes;
import carmetal.eric.GUI.window.comments;
import carmetal.eric.GUI.window.tab_canvas_panel;
import carmetal.eric.GUI.window.tab_main_panel;
import carmetal.eric.JHelpPanel;
import carmetal.eric.JPointName;
import carmetal.eric.macros.MacroTools;
import carmetal.eric.macros.MacrosList;
import carmetal.objects.PointObject;
import carmetal.rene.gui.Global;
import carmetal.rene.util.FileName;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.ZirkelFrame;
import carmetal.rene.zirkel.dialogs.Replay;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class JZirkelCanvas
extends JPanel {
    private ZirkelFrame ZF = null;
    private JPointName PointLabel;
    private Replay Dreplay;
    private static boolean restrictedsession = false;
    private byte[] byteinputfile = null;
    private static String workbookFileName = null;
    private static JHelpPanel InfoPanel = new JHelpPanel();
    private static MacrosList MacroPanel = null;

    @Override
    public void paintComponent(Graphics g) {
    }

    public JZirkelCanvas() {
        this.setLayout(new BorderLayout());
        this.ZF = new ZirkelFrame(pipe_tools.isApplet());
        this.ZF.ZC.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (Global.getParameter("smartboard", false)) {
                    return;
                }
                JZirkelCanvas.this.PointLabel.getBetterName(null, true);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (!Global.getParameter("smartboard", false)) {
                    return;
                }
                JZirkelCanvas.this.PointLabel.getBetterName(null, true);
            }
        });
        this.add(this.ZF.ZC);
        this.newReplay();
        this.PointLabel = new JPointName(this);
        PointObject.setPointLabel(this.PointLabel);
        MacroTools.setDefaultMacros(this.ZF.ZC);
        this.ZF.ZC.getLocalPreferences();
    }

    public void init() {
        Rectangle r = new Rectangle(0, 0, pipe_tools.getWindowSize().width - themes.getLeftPanelWidth() - themes.getVerticalPanelBorderWidth() - themes.getTotalRightPanelWidth() - 2 * themes.getVerticalBorderWidth() - themes.getTabLeftBorderWidth() - themes.getTabRightBorderWidth(), pipe_tools.getWindowSize().height - themes.getTitleBarHeight() - themes.getMenuBarHeight() - themes.getMainTabPanelHeight() - themes.getCommentsHeight() - themes.getStatusBarHeight());
        this.setBounds(r);
        this.ZF.ZC.setBounds(r);
        this.ZF.ZC.initRestrictDialog();
        this.ZF.ZC.initJobCreationDialog();
    }

    public byte[] getByteArrayInputFile() {
        return this.byteinputfile;
    }

    public void createByteArrayInputFile(InputStream in) {
        if (this.byteinputfile == null) {
            this.byteinputfile = FileTools.copyToByteArray(in);
        }
    }

    public void setInputFile(InputStream in) {
        if (in != null) {
            this.createByteArrayInputFile(in);
        }
    }

    public void setInputFile(byte[] in) {
        this.byteinputfile = in;
    }

    public static void getCurrentLocalPreferences() {
        if (JZirkelCanvas.getCurrentZC() != null) {
            JZirkelCanvas.getCurrentZC().getLocalPreferences();
        }
    }

    public void onTabActivate() {
        if (this.byteinputfile != null) {
            FileTools.openFile("", new ByteArrayInputStream(this.byteinputfile), false);
            this.byteinputfile = null;
        }
        this.ZF.ZC.setLocalPreferences();
        PointObject.setPointLabel(this.PointLabel);
        this.ZF.ZC.updateDigits();
        this.ZF.ZC.paint(this.ZF.ZC.getGraphics());
        PaletteManager.refresh();
    }

    public static boolean isWorkBook() {
        return workbookFileName != null;
    }

    public static String getWorkBookFileName() {
        return workbookFileName;
    }

    public static String getFileName() {
        try {
            if (JZirkelCanvas.isWorkBook()) {
                return JZirkelCanvas.getWorkBookFileName();
            }
            return JZirkelCanvas.getCurrentZF().Filename;
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static void setWorkBookFileName(String s, boolean force) {
        if (force || workbookFileName == null) {
            workbookFileName = s;
            if (!pipe_tools.isApplet()) {
                pipe_tools.setTitle(Global.Loc("program.name") + " - " + Global.Loc("workbook.workbookmode") + " : " + FileName.filename(s));
                pipe_tools.TabHaveChanged(false);
            }
        }
    }

    public static boolean isRestrictedSession() {
        return restrictedsession;
    }

    public Replay getReplay() {
        return this.Dreplay;
    }

    public void disposeReplay() {
        this.Dreplay.dispose();
    }

    public void newReplay() {
        this.Dreplay = new Replay(null, this.ZF.ZC);
    }

    public JPointName getPointLabel() {
        return this.PointLabel;
    }

    public ZirkelFrame getZF() {
        return this.ZF;
    }

    public ZirkelCanvas getZC() {
        return this.ZF.ZC;
    }

    public static String ToolTip(String s) {
        String ToolTipText = "";
        String purename = s.startsWith("bi_") ? s.substring(3) : s;
        try {
            ToolTipText = Global.Loc("palette.info." + purename);
        }
        catch (Exception e1) {
            try {
                ToolTipText = Global.Loc("palette.info." + s);
            }
            catch (Exception e2) {
                ToolTipText = Global.name("iconhelp." + purename);
            }
        }
        return ToolTipText;
    }

    public static String FilteredStatus(String status) {
        String newstatus = status;
        int index = status.indexOf("@builtin@/syma");
        if (index > 0) {
            newstatus = newstatus.substring(index);
            newstatus = newstatus.replaceAll("\\Q@builtin@/syma\\E", Global.Loc("palette.info.bi_syma"));
        } else {
            index = status.indexOf("@builtin@/symc");
            if (index > 0) {
                newstatus = newstatus.substring(index);
                newstatus = newstatus.replaceAll("\\Q@builtin@/symc\\E", Global.Loc("palette.info.bi_symc"));
            } else {
                index = status.indexOf("@builtin@/trans");
                if (index > 0) {
                    newstatus = newstatus.substring(index);
                    newstatus = newstatus.replaceAll("\\Q@builtin@/trans\\E", Global.Loc("palette.info.bi_trans"));
                } else {
                    index = status.indexOf("@builtin@/med");
                    if (index > 0) {
                        newstatus = newstatus.substring(index);
                        newstatus = newstatus.replaceAll("\\Q@builtin@/med\\E", Global.Loc("palette.info.bi_med"));
                    } else {
                        index = status.indexOf("@builtin@/biss");
                        if (index > 0) {
                            newstatus = newstatus.substring(index);
                            newstatus = newstatus.replaceAll("\\Q@builtin@/biss\\E", Global.Loc("palette.info.bi_biss"));
                        } else {
                            index = status.indexOf("@builtin@/circ");
                            if (index > 0) {
                                newstatus = newstatus.substring(index);
                                newstatus = newstatus.replaceAll("\\Q@builtin@/circ\\E", Global.Loc("palette.info.bi_circ"));
                            } else {
                                index = status.indexOf("@builtin@/arc");
                                if (index > 0) {
                                    newstatus = newstatus.substring(index);
                                    newstatus = newstatus.replaceAll("\\Q@builtin@/arc\\E", Global.Loc("palette.info.bi_arc"));
                                } else {
                                    index = status.indexOf("@builtin@/function_u");
                                    if (index > 0) {
                                        newstatus = newstatus.substring(index);
                                        newstatus = newstatus.replaceAll("\\Q@builtin@/function_u\\E", JZirkelCanvas.ToolTip("bi_function_u"));
                                    } else {
                                        index = status.indexOf("@builtin@/t_align");
                                        if (index > 0) {
                                            newstatus = newstatus.substring(index);
                                            newstatus = newstatus.replaceAll("\\Q@builtin@/t_align\\E", Global.Loc("palette.info.bi_t_align"));
                                        } else {
                                            index = status.indexOf("@builtin@/t_para");
                                            if (index > 0) {
                                                newstatus = newstatus.substring(index);
                                                newstatus = newstatus.replaceAll("\\Q@builtin@/t_para\\E", Global.Loc("palette.info.bi_t_para"));
                                            } else {
                                                index = status.indexOf("@builtin@/t_perp");
                                                if (index > 0) {
                                                    newstatus = newstatus.substring(index);
                                                    newstatus = newstatus.replaceAll("\\Q@builtin@/t_perp\\E", Global.Loc("palette.info.bi_t_perp"));
                                                } else {
                                                    index = status.indexOf("@builtin@/t_equi");
                                                    if (index > 0) {
                                                        newstatus = newstatus.substring(index);
                                                        newstatus = newstatus.replaceAll("\\Q@builtin@/t_equi\\E", Global.Loc("palette.info.bi_t_equi"));
                                                    } else {
                                                        index = status.indexOf("@builtin@/t_app");
                                                        if (index > 0) {
                                                            newstatus = newstatus.substring(index);
                                                            newstatus = newstatus.replaceAll("\\Q@builtin@/t_app\\E", Global.Loc("palette.info.bi_t_app"));
                                                        } else {
                                                            index = status.indexOf("@builtin@/t_conf");
                                                            if (index > 0) {
                                                                newstatus = newstatus.substring(index);
                                                                newstatus = newstatus.replaceAll("\\Q@builtin@/t_conf\\E", Global.Loc("palette.info.bi_t_conf"));
                                                            } else {
                                                                index = status.indexOf("@builtin@/3Dcoords");
                                                                if (index > 0) {
                                                                    newstatus = newstatus.substring(index);
                                                                    newstatus = newstatus.replaceAll("\\Q@builtin@/3Dcoords\\E", Global.Loc("palette.info.bi_3Dcoords"));
                                                                } else {
                                                                    index = status.indexOf("@builtin@/3Dcube");
                                                                    if (index > 0) {
                                                                        newstatus = newstatus.substring(index);
                                                                        newstatus = newstatus.replaceAll("\\Q@builtin@/3Dcube\\E", Global.Loc("palette.info.bi_3Dcube"));
                                                                    } else {
                                                                        index = status.indexOf("@builtin@/3Darete");
                                                                        if (index > 0) {
                                                                            newstatus = newstatus.substring(index);
                                                                            newstatus = newstatus.replaceAll("\\Q@builtin@/3Darete\\E", Global.Loc("palette.info.bi_3Darete"));
                                                                        } else {
                                                                            index = status.indexOf("@builtin@/3Dtetra");
                                                                            if (index > 0) {
                                                                                newstatus = newstatus.substring(index);
                                                                                newstatus = newstatus.replaceAll("\\Q@builtin@/3Dtetra\\E", Global.Loc("palette.info.bi_3Dtetra"));
                                                                            } else {
                                                                                index = status.indexOf("@builtin@/3Ddode");
                                                                                if (index > 0) {
                                                                                    newstatus = newstatus.substring(index);
                                                                                    newstatus = newstatus.replaceAll("\\Q@builtin@/3Ddode\\E", Global.Loc("palette.info.bi_3Ddode"));
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return newstatus;
    }

    public static boolean workbookHaveChanged() {
        boolean changed = false;
        for (int i = 0; i < tab_main_panel.getBTNSsize(); ++i) {
            if (!tab_main_panel.getBTN(i).getPanel().getZC().changed()) continue;
            return true;
        }
        return changed;
    }

    private boolean close() {
        return this.ZF.close();
    }

    public static void setFactoryProperties() {
        Global.setParameter("colorbackground", new Color(245, 245, 245));
        Global.setParameter("colorbackgroundx", 139);
        Global.setParameter("colorbackgroundy", 9);
        Global.setParameter("colorbackgroundPal", 4);
    }

    public static boolean closeCurrent() {
        if (JZirkelCanvas.getCurrentJZF() == null) {
            return false;
        }
        boolean b2 = JZirkelCanvas.getCurrentJZF().close();
        if (b2) {
            if (tab_main_panel.getBTNSsize() == 1) {
                JZirkelCanvas.setFactoryProperties();
                Global.saveProperties("CaR Properties");
                MacroTools.saveLibraryToDisk();
                JZirkelCanvas.exit();
            } else {
                tab_main_panel.removeBtnAndSelect(tab_main_panel.getActiveBtn());
            }
        }
        return b2;
    }

    public static void quitAll() {
        if (JZirkelCanvas.isWorkBook()) {
            if (JZirkelCanvas.workbookHaveChanged()) {
                int rep = JOptionPane.showConfirmDialog(JZirkelCanvas.getCurrentJZF(), Global.Loc("workbook.savequestion"));
                if (rep == 2) {
                    return;
                }
                if (rep == 0) {
                    FileTools.saveWorkBook(JZirkelCanvas.getWorkBookFileName());
                }
            }
            JZirkelCanvas.setFactoryProperties();
            Global.saveProperties("CaR Properties");
            MacroTools.saveLibraryToDisk();
            JZirkelCanvas.exit();
        } else {
            while (JZirkelCanvas.closeCurrent()) {
            }
        }
    }

    public static int getZCsSize() {
        return tab_main_panel.getBTNSsize();
    }

    public static ZirkelCanvas getZC(int i) {
        try {
            tab_canvas_panel jzf = tab_main_panel.getPanel(i);
            return jzf.getZC();
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static void exit() {
    }

    public static String getFilePath(Construction c2) {
        for (int i = 0; i < JZirkelCanvas.getZCsSize(); ++i) {
            tab_canvas_panel jzf = tab_main_panel.getPanel(i);
            if (!c2.equals(jzf.getZC().getConstruction())) continue;
            return FileName.pathAndSeparator(jzf.getZF().Filename);
        }
        return null;
    }

    public static JZirkelCanvas getCurrentJZF() {
        try {
            tab_canvas_panel zf = tab_main_panel.getActivePanel();
            return zf;
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static ZirkelFrame getCurrentZF() {
        try {
            return JZirkelCanvas.getCurrentJZF().getZF();
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static ZirkelCanvas getCurrentZC() {
        try {
            return JZirkelCanvas.getCurrentZF().ZC;
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static boolean isPaintCalled() {
        ZirkelCanvas zc = JZirkelCanvas.getCurrentZC();
        if (zc != null) {
            return zc.isPaintCalled();
        }
        return false;
    }

    public static boolean getCurrent3dMode() {
        try {
            return JZirkelCanvas.getCurrentZC().is3D();
        }
        catch (Exception e2) {
            return false;
        }
    }

    public static void repaintZC() {
        ZirkelCanvas zc = JZirkelCanvas.getCurrentZC();
        if (zc != null) {
            zc.repaint();
        }
    }

    public static void setCurrent3dMode(boolean bool) {
        try {
            JZirkelCanvas.getCurrentZC().set3D(bool);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setinfo(String s, boolean WithTxtFocus) {
        JHelpPanel.Subject = s;
        if (InfoPanel != null) {
            InfoPanel.clearSearchTxtField();
            InfoPanel.fill(WithTxtFocus);
        }
    }

    public static JHelpPanel getNewInfoPanel() {
        InfoPanel = null;
        InfoPanel = new JHelpPanel();
        return InfoPanel;
    }

    public static ConstructionDisplayPanel getNewCDPPanel() {
        ZirkelCanvas zc = JZirkelCanvas.getCurrentZC();
        if (zc != null) {
            return zc.getNewCDP();
        }
        return null;
    }

    public static MacrosList getNewMacroPanel() {
        MacroPanel = new MacrosList(JZirkelCanvas.getCurrentZF());
        return MacroPanel;
    }

    public void setComments() {
        String s = this.getZC().getJobComment();
        if (s == null) {
            s = "";
        }
        comments.setLabelText(s);
    }

    public static void ActualiseMacroPanel() {
        if (MacroPanel == null) {
            MacroPanel = JZirkelCanvas.getNewMacroPanel();
        }
        MacroPanel.initTreeFromZCMacros();
    }

    public static void removeLeftPanelContent() {
        ZirkelCanvas zc = JZirkelCanvas.getCurrentZC();
        if (zc != null) {
            zc.removeCDP();
            InfoPanel = null;
        }
    }
}

