/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric;

import carmetal.eric.bar.JProperties;
import carmetal.objects.ConstructionObject;
import carmetal.rene.gui.Global;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.expression.Expression;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JMacroPrompt
extends JDialog {
    private static final long serialVersionUID = 1L;
    JTextField T = new JTextField();
    String InitValue = "";
    ConstructionObject OC;
    ZirkelCanvas ZC;
    int WindowEventCount = 0;
    Color TitleColor = new Color(200, 200, 200);
    Color TxtColor = new Color(250, 250, 250);
    Color DlogColor = new Color(90, 90, 90);

    private void fixsize(JComponent cp, int w, int h) {
        Dimension d2 = new Dimension(w, h);
        cp.setMaximumSize(d2);
        cp.setMinimumSize(d2);
        cp.setPreferredSize(d2);
        cp.setSize(d2);
    }

    private JPanel margin(int w) {
        JPanel mypan = new JPanel();
        this.fixsize(mypan, w, 1);
        mypan.setOpaque(false);
        mypan.setFocusable(false);
        return mypan;
    }

    private boolean isValidExpression(String myexp) {
        boolean bool = true;
        try {
            Expression exp = new Expression(myexp, this.OC.getConstruction(), this.OC);
            if (!exp.isValid()) {
                bool = false;
            }
        }
        catch (Exception ex) {
            bool = false;
        }
        return bool;
    }

    public JMacroPrompt(Frame f2, ZirkelCanvas zc, String oName, ConstructionObject oc) {
        super(f2, true);
        this.OC = oc;
        this.ZC = zc;
        try {
            this.InitValue = String.valueOf(this.OC.getValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        JPanel content = (JPanel)this.getContentPane();
        this.setUndecorated(true);
        content.setLayout(new BoxLayout(content, 1));
        content.setBackground(this.DlogColor);
        JLabel p1 = new JLabel(Global.name("macro.prompt.prompt") + " :");
        p1.setHorizontalAlignment(0);
        this.fixsize(p1, 300, 15);
        p1.setAlignmentX(0.5f);
        p1.setOpaque(false);
        p1.setFont(new Font(Global.GlobalFont, 1, 12));
        p1.setForeground(this.TitleColor);
        JPanel p2 = new JPanel();
        p2.setLayout(new BoxLayout(p2, 0));
        JLabel p21 = new JLabel(oName);
        JButton okbtn = new JButton();
        okbtn.setIcon(new ImageIcon(this.getClass().getResource("/carmetal.eric/GUI/icons/palette/Mvalid.png")));
        okbtn.setBorder(BorderFactory.createEmptyBorder());
        okbtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                JMacroPrompt.this.doclose();
            }
        });
        okbtn.setContentAreaFilled(false);
        JButton cancelbtn = new JButton();
        cancelbtn.setIcon(new ImageIcon(this.getClass().getResource("/carmetal.eric/GUI/icons/palette/Mcancel.png")));
        cancelbtn.setBorder(BorderFactory.createEmptyBorder());
        cancelbtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                JMacroPrompt.this.T.setText(JMacroPrompt.this.InitValue);
                try {
                    JMacroPrompt.this.OC.setExpression(JMacroPrompt.this.T.getText(), JMacroPrompt.this.OC.getConstruction());
                    JMacroPrompt.this.OC.setSlider(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                JMacroPrompt.this.ZC.recompute();
                JMacroPrompt.this.ZC.validate();
                JMacroPrompt.this.ZC.repaint();
                JMacroPrompt.this.T.requestFocus();
                JMacroPrompt.this.T.selectAll();
            }
        });
        cancelbtn.setContentAreaFilled(false);
        this.fixsize(p21, 120, 18);
        this.fixsize(this.T, 118, 18);
        p2.add(this.margin(5));
        p2.add(p21);
        p2.add(this.margin(10));
        p2.add(this.T);
        p2.add(this.margin(5));
        p2.add(cancelbtn);
        p2.add(this.margin(5));
        p2.add(okbtn);
        p2.add(this.margin(5));
        this.fixsize(p2, 300, 30);
        p2.setAlignmentX(0.5f);
        p2.setOpaque(false);
        p21.setOpaque(false);
        p21.setFont(new Font(Global.GlobalFont, 1, 12));
        this.T.setFont(new Font(Global.GlobalFont, 1, 12));
        p21.setForeground(this.TxtColor);
        this.T.setText(JProperties.Point_To_Comma(this.InitValue, this.OC.getConstruction(), true));
        content.add(p1);
        content.add(p2);
        this.T.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e2) {
                if (e2.getKeyCode() == 10 || e2.getKeyCode() == 27) {
                    JMacroPrompt.this.doclose();
                }
            }

            @Override
            public void keyReleased(KeyEvent e2) {
                String e1 = JProperties.Comma_To_Point(JMacroPrompt.this.T.getText(), JMacroPrompt.this.OC.getConstruction(), true);
                String myexp = JMacroPrompt.this.isValidExpression(e1) ? e1 : "invalid";
                try {
                    JMacroPrompt.this.OC.setExpression(myexp, JMacroPrompt.this.OC.getConstruction());
                    JMacroPrompt.this.OC.setSlider(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                JMacroPrompt.this.ZC.recompute();
                JMacroPrompt.this.ZC.validate();
                JMacroPrompt.this.ZC.repaint();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e2) {
                JMacroPrompt.this.T.requestFocus();
                JMacroPrompt.this.T.selectAll();
            }
        });
        this.pack();
        Point pt = zc.getLocationOnScreen();
        pt.x += zc.getSize().width / 2 - this.getSize().width / 2;
        pt.y += zc.getSize().height - this.getSize().height;
        this.setLocation(pt);
        this.setVisible(true);
    }

    public void doclose() {
        String e1 = JProperties.Comma_To_Point(this.T.getText(), this.OC.getConstruction(), true);
        String myexp = this.isValidExpression(e1) ? e1 : this.InitValue;
        try {
            this.OC.setExpression(myexp, this.OC.getConstruction());
            this.OC.setSlider(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ZC.recompute();
        this.ZC.validate();
        this.ZC.repaint();
        this.setVisible(false);
        this.dispose();
    }
}

