/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric.GUI.window;

import carmetal.eric.GUI.pipe_tools;
import carmetal.eric.GUI.themes;
import carmetal.eric.GUI.window.ContentPane;
import carmetal.eric.GUI.window.tab_btn_label;
import carmetal.eric.GUI.window.tab_canvas_panel;
import carmetal.eric.GUI.window.tab_close_btn;
import carmetal.eric.GUI.window.tab_main_panel;
import carmetal.eric.GUI.windowComponent;
import carmetal.eric.JZirkelCanvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class tab_btn
extends windowComponent
implements Comparable<tab_btn>,
PopupMenuListener {
    private tab_canvas_panel panel;
    private Point origin;
    private Point current;
    private Point btnloc;
    private boolean active = true;
    private boolean over = false;
    private tab_close_btn CloseBtn;
    private tab_btn_label Label;
    private String Tooltip = "";
    private static Image on_btn_right = themes.getImage("tab_btn_on_right_border.gif");
    private static Image on_btn_left = themes.getImage("tab_btn_on_left_border.gif");
    private static Image on_btn = themes.getImage("tab_btn_on.gif");
    private static Image off_btn_right = themes.getImage("tab_btn_off_right_border.gif");
    private static Image off_btn_left = themes.getImage("tab_btn_off_left_border.gif");
    private static Image off_btn = themes.getImage("tab_btn_off.gif");
    private static Image off_over_btn_right = themes.getImage("tab_btn_off_over_right_border.gif");
    private static Image off_over_btn_left = themes.getImage("tab_btn_off_over_left_border.gif");
    private static Image off_over_btn = themes.getImage("tab_btn_off_over.gif");
    private static Image file_icon = themes.getImage("tab_file_icon.png");
    private boolean Changed = false;

    @Override
    public void paintComponent(Graphics g) {
        Dimension d2 = this.getSize();
        Graphics2D g2 = windowComponent.getGraphics2D(g);
        g2.drawImage(this.getBackgroundImage(), 0, 0, d2.width, d2.height, this);
        g2.drawImage(this.getLeftBorder(), 0, 0, themes.getTabCornerWidth(), d2.height, this);
        g2.drawImage(this.getRightBorder(), d2.width - themes.getTabCornerWidth(), 0, themes.getTabCornerWidth(), d2.height, this);
        if (!JZirkelCanvas.isWorkBook()) {
            g2.drawImage(file_icon, 4, 2, this);
        }
    }

    public tab_btn(String label, String tooltip) {
        label = pipe_tools.processTabName(label);
        this.Label = new tab_btn_label(label);
        this.Tooltip = tooltip;
        this.setLayout(null);
        this.CloseBtn = new tab_close_btn();
        this.panel = new tab_canvas_panel(this);
        this.add(this.CloseBtn);
        this.add(this.Label);
        this.setOpaque(true);
    }

    public tab_btn(String label) {
        this(label, label);
    }

    public void setChanged(boolean b2) {
        this.Changed = b2;
        this.Label.setChanged(b2);
        this.repaint();
    }

    public void setActive(boolean act) {
        this.active = act;
        if (this.active) {
            ContentPane.setCurrentPanel(this.panel);
        }
    }

    public boolean getActive() {
        return this.active;
    }

    public void setOver(boolean ov) {
        this.over = ov;
    }

    public tab_close_btn getTabCloseBtn() {
        return this.CloseBtn;
    }

    public tab_btn_label getTabLabel() {
        return this.Label;
    }

    public tab_canvas_panel getPanel() {
        return this.panel;
    }

    public void setTabName(String name, String tooltip) {
        name = pipe_tools.processTabName(name);
        this.Label.setLabelText(name);
        this.Tooltip = tooltip;
        this.setToolTipText(this.Tooltip);
    }

    public String getTabName() {
        return this.Label.getLabelText();
    }

    public void editName() {
        if (pipe_tools.isTabEditAccepted()) {
            this.Label.edit();
        }
    }

    public void init() {
        this.setToolTipText(this.Tooltip);
        this.getTabCloseBtn().init();
        this.getTabLabel().init();
        this.getPanel().init();
    }

    private Image getRightBorder() {
        if (this.active) {
            return on_btn_right;
        }
        if (this.over) {
            return off_over_btn_right;
        }
        return off_btn_right;
    }

    private Image getLeftBorder() {
        if (this.active) {
            return on_btn_left;
        }
        if (this.over) {
            return off_over_btn_left;
        }
        return off_btn_left;
    }

    private Image getBackgroundImage() {
        if (this.active) {
            return on_btn;
        }
        if (this.over) {
            return off_over_btn;
        }
        return off_btn;
    }

    @Override
    public Point getToolTipLocation(MouseEvent event) {
        return new Point(0, this.getSize().height + 2);
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        this.origin = pipe_tools.getWindow().getMouseLoc();
        this.btnloc = this.getLocation();
        tab_main_panel.setActiveBtn(this);
        this.repaint();
        if (e2.getModifiers() == 4) {
            JPopupMenu popup = tab_main_panel.getCtrlPopup();
            popup.removePopupMenuListener(this);
            popup.addPopupMenuListener(this);
            popup.show(this, (this.getSize().width - popup.getPreferredSize().width) / 2, -2 - popup.getPreferredSize().height);
            this.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
        tab_main_panel.setOverBtn(this);
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e2) {
        this.over = false;
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        tab_main_panel.reorderBTNS(null);
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
        this.getParent().setComponentZOrder(this, 0);
        this.current = pipe_tools.getWindow().getMouseLoc();
        if (this.current == null) {
            return;
        }
        this.setLocation(this.btnloc.x + this.current.x - this.origin.x, this.btnloc.y);
        tab_main_panel.reorderBTNS(this);
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
        tab_main_panel.setOverBtn(this);
        this.repaint();
    }

    @Override
    public int compareTo(tab_btn o) {
        int middle = (2 * this.getBounds().x + this.getBounds().width) / 2;
        if (middle > o.getBounds().x) {
            return 1;
        }
        if (middle < o.getBounds().x) {
            return -1;
        }
        return 0;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e2) {
        this.removeMouseListener(this);
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e2) {
        this.repaint();
        final tab_btn btn = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                tab_btn.this.addMouseListener(btn);
            }
        });
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e2) {
    }
}

