/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric.GUI.window;

import carmetal.eric.GUI.pipe_tools;
import carmetal.eric.GUI.window.ContentPane;
import carmetal.eric.GUI.window.comments;
import carmetal.rene.gui.Global;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class comments_area
extends JScrollPane {
    private static int margins = 3;
    private static int marginLeft = 0;
    private static int marginTop = 0;
    private static int marginRight = 0;
    private static int scrollBarWidth = 15;
    private static Font commentFont = new Font("Verdana", 0, 14);
    private static Color commentColor = new Color(20, 20, 20);
    JLabel text_area = new JLabel(""){

        @Override
        public Dimension getPreferredSize() {
            Dimension superPreferred = super.getPreferredSize();
            Container p = this.getParent();
            return new Dimension(p.getBounds().width - 2 * margins - scrollBarWidth, superPreferred.height);
        }
    };
    private JLabel inviteLabel;
    private static MouseAdapter ma = null;
    private String label = "";

    public comments_area() {
        this.setViewportView(this.text_area);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                comments_area.this.edit();
            }
        });
        this.text_area.setOpaque(false);
        this.text_area.setVerticalTextPosition(1);
        this.text_area.setHorizontalTextPosition(2);
        this.text_area.setHorizontalAlignment(2);
        this.text_area.setVerticalAlignment(1);
        this.text_area.setFont(commentFont);
        this.text_area.setForeground(commentColor);
        this.text_area.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setOpaque(false);
        this.getViewport().setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(margins, margins, margins, margins));
        JScrollBar vsb = this.getVerticalScrollBar();
        Dimension newsbsize = new Dimension(scrollBarWidth, 0);
        vsb.setUI(new BasicScrollBarUI());
        vsb.setPreferredSize(newsbsize);
        vsb.setUnitIncrement(16);
        this.setHorizontalScrollBarPolicy(31);
        this.inviteLabel = new JLabel(Global.Loc("comment.emptycomment"));
        this.inviteLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.inviteLabel.setVerticalTextPosition(0);
        this.inviteLabel.setHorizontalTextPosition(0);
        this.inviteLabel.setHorizontalAlignment(0);
        this.inviteLabel.setVerticalAlignment(0);
        this.inviteLabel.setOpaque(false);
        this.inviteLabel.setFont(commentFont);
        this.inviteLabel.setForeground(commentColor);
        this.text_area.add(this.inviteLabel);
        this.setInviteLabel();
        ma = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                final Component cp = e2.getComponent();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        cp.requestFocus();
                    }
                });
            }
        };
    }

    void init() {
        Container p = this.getParent();
        if (p != null) {
            this.setBounds(0, 0, p.getBounds().width, p.getBounds().height);
            this.inviteLabel.setBounds(0, 0, p.getBounds().width - 2 * margins - scrollBarWidth, p.getBounds().height - 2 * margins);
            this.setLabelText(this.label);
        }
    }

    public void setLabelText(String s) {
        Container p = this.getParent();
        if (p != null) {
            this.label = s;
            int pix = 10 * (p.getBounds().width - 2 * margins - scrollBarWidth) / 13 - 1;
            this.text_area.setText("<html><div style=\"width: " + pix + "px; text-align: justify;\">" + s + "</div></html>");
            this.setInviteLabel();
        }
    }

    public String getLabelText() {
        return this.label;
    }

    public void setInviteLabel() {
        this.inviteLabel.setVisible(this.label.equals(""));
    }

    public void implementMouseAdapter() {
        ContentPane pane = pipe_tools.getContent();
        this.implementMouseAdapter(pane);
    }

    public void implementMouseAdapter(Container comp) {
        if (!(comp instanceof JLabel)) {
            comp.addMouseListener(ma);
        }
        for (int i = 0; i < comp.getComponentCount(); ++i) {
            Container cp = (Container)comp.getComponent(i);
            this.implementMouseAdapter(cp);
        }
    }

    public void removeMouseAdapter() {
        if (ma != null) {
            ContentPane pane = pipe_tools.getContent();
            this.removeMouseAdapter(pane);
        }
    }

    public void removeMouseAdapter(Container comp) {
        if (!(comp instanceof JLabel)) {
            comp.removeMouseListener(ma);
        }
        for (int i = 0; i < comp.getComponentCount(); ++i) {
            Container cp = (Container)comp.getComponent(i);
            this.removeMouseAdapter(cp);
        }
    }

    public void edit() {
        final comments com = (comments)this.getParent();
        final JTextArea jtf = new JTextArea();
        jtf.setOpaque(false);
        jtf.setText(this.label);
        jtf.setBounds(this.getBounds());
        jtf.setFont(commentFont);
        jtf.setForeground(commentColor);
        jtf.setLineWrap(true);
        com.removeMouseListener(com);
        this.implementMouseAdapter();
        jtf.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e2) {
                if (e2.getKeyCode() == 10) {
                    jtf.replaceSelection("<br>");
                } else if (e2.getKeyCode() == 27) {
                    comments_area.this.removeMouseAdapter();
                    com.remove(jtf);
                    com.revalidate();
                    com.repaint();
                }
            }

            @Override
            public void keyReleased(KeyEvent e2) {
                pipe_tools.setComments(jtf.getText());
                comments_area.this.setLabelText(jtf.getText());
            }
        });
        jtf.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                comments_area.this.setViewportView(comments_area.this.text_area);
                com.remove(jtf);
                com.revalidate();
                com.repaint();
                com.addMouseListener(com);
                comments_area.this.removeMouseAdapter();
                comments_area.this.revalidate();
                comments_area.this.validate();
                comments_area.this.repaint();
            }
        });
        this.setViewportView(jtf);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jtf.requestFocus();
            }
        });
    }
}

