/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric.GUI.palette;

import carmetal.eric.GUI.palette.PaletteManager;
import carmetal.eric.GUI.themes;
import carmetal.eric.GUI.windowComponent;
import carmetal.rene.gui.Global;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class PaletteZoneTitle
extends windowComponent {
    private static Image offimage = themes.getImage("PaletteTitleBarN.png");
    private static Image onimage = themes.getImage("PaletteTitleBarH.png");
    private static Image rightTriangle = themes.getPaletteImage("PaletteTriangleDroite");
    private static Image bottomTriangle = themes.getPaletteImage("PaletteTriangleBas");
    private static boolean active = false;
    private JLabel title = new JLabel();

    @Override
    public void paintComponent(Graphics g) {
        Dimension d2 = this.getSize();
        if (active) {
            g.drawImage(onimage, 0, 0, d2.width, d2.height, this);
        } else {
            g.drawImage(offimage, 0, 0, d2.width, d2.height, this);
        }
    }

    public void init() {
        PaletteManager.fixsize(this, themes.getRightPanelWidth(), themes.getPaletteZoneTitleHeight());
    }

    public PaletteZoneTitle(String name) {
        this.setLayout(new BoxLayout(this, 1));
        this.setAlignmentX(0.0f);
        this.title.setText(name);
        this.title.setIcon(new ImageIcon(bottomTriangle));
        this.setHide(Global.getParameter("hidepalette." + name, true));
        this.title.setIconTextGap(7);
        this.title.setFont(new Font(Global.GlobalFont, 0, 11));
        this.title.setHorizontalAlignment(2);
        PaletteManager.fixsize(this.title, themes.getRightPanelWidth() - themes.getPaletteZoneTitleHeight(), themes.getPaletteZoneTitleHeight());
        this.add(this.title);
    }

    public void setHide(boolean b2) {
        if (b2) {
            this.title.setIcon(new ImageIcon(rightTriangle));
        } else {
            this.title.setIcon(new ImageIcon(bottomTriangle));
        }
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        active = true;
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        active = false;
        this.repaint();
    }
}

