/*
 * Decompiled with CFR 0.152.
 */
package carmetal.constructors;

import carmetal.construction.Construction;
import carmetal.construction.ConstructionException;
import carmetal.constructors.ObjectConstructor;
import carmetal.eric.bar.JPropertiesBar;
import carmetal.objects.ConstructionObject;
import carmetal.objects.PointObject;
import carmetal.objects.PrimitiveCircleObject;
import carmetal.objects.PrimitiveLineObject;
import carmetal.rene.gui.Global;
import carmetal.rene.util.xml.XmlTag;
import carmetal.rene.util.xml.XmlTree;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.expression.Expression;
import java.awt.event.MouseEvent;

public class PointConstructor
extends ObjectConstructor {
    boolean Fix;
    PointObject P;
    boolean ShowsValue;
    boolean ShowsName;

    @Override
    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        zc.y(e2.getY());
        PointObject o = zc.selectCreatePoint(e2.getX(), e2.getY(), false, true, e2.isAltDown());
        this.Dragging = false;
        if (o == null) {
            return;
        }
        if (o.isPointOn()) {
            if (e2.isShiftDown() && zc.isNewPoint()) {
                o.setUseAlpha(true);
            }
        } else if (o.moveable() && zc.isNewPoint() && !zc.getAxis_show()) {
            this.P = o;
            this.Fix = e2.isShiftDown();
            this.ShowsValue = this.P.showValue();
            this.ShowsName = this.P.showName();
            this.Dragging = true;
            zc.repaint();
        } else if (o.moveable() && zc.isNewPoint() && zc.getAxis_show() && e2.isShiftDown()) {
            this.P = o;
            try {
                this.P.setFixed("" + this.P.round(this.P.getX(), ZirkelCanvas.LengthsFactor), "" + this.P.round(this.P.getY(), ZirkelCanvas.LengthsFactor));
                this.P.edit(zc, true, true);
                this.P.validate();
            }
            catch (Exception exception) {}
        } else if (e2.isShiftDown() && !zc.isNewPoint()) {
            PointObject p = new PointObject(zc.getConstruction(), o.getX(), o.getY());
            zc.addObject(p);
            p.setFixed(true);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e2, ZirkelCanvas zc) {
        if (!this.Dragging) {
            return;
        }
        if (Global.getParameter("options.movename", false)) {
            this.P.setShowValue(true);
            this.P.setShowName(true);
        }
        this.P.move(zc.x(e2.getX()), zc.y(e2.getY()));
        zc.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e2, ZirkelCanvas zc) {
        if (!this.Dragging) {
            return;
        }
        this.Dragging = false;
        this.P.setShowValue(this.ShowsValue);
        this.P.setShowName(this.ShowsName);
        this.P.updateText();
        zc.repaint();
        if (this.Fix) {
            try {
                this.P.setFixed("" + this.P.round(this.P.getX(), ZirkelCanvas.LengthsFactor), "" + this.P.round(this.P.getY(), ZirkelCanvas.LengthsFactor));
                JPropertiesBar.EditObject(this.P);
                this.P.validate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void showStatus(ZirkelCanvas zc) {
        zc.showStatus(Global.name("message.point", "Point: Set a point!"));
    }

    @Override
    public boolean construct(XmlTree tree, Construction c2) throws ConstructionException {
        if (!this.testTree(tree, "Point")) {
            return false;
        }
        XmlTag tag = tree.getTag();
        if (!tag.hasParam("x") || !tag.hasParam("y")) {
            throw new ConstructionException("Point coordinates missing!");
        }
        double x = 0.0;
        double y = 0.0;
        try {
            if (tag.hasParam("actx")) {
                x = new Double(tag.getValue("actx"));
            }
            if (tag.hasParam("acty")) {
                y = new Double(tag.getValue("acty"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        PointObject p = new PointObject(c2, x, y);
        try {
            x = new Expression(tag.getValue("x"), c2, p).getValue();
            y = new Expression(tag.getValue("y"), c2, p).getValue();
            p.move(x, y);
        }
        catch (Exception exception) {
            // empty catch block
        }
        PointConstructor.setType(tag, p);
        this.setName(tag, p);
        this.set(tree, p);
        c2.add(p);
        this.setConditionals(tree, c2, p);
        if (tag.hasParam("fixed")) {
            p.setFixed(tag.getValue("x"), tag.getValue("y"));
        }
        if (tag.hasParam("increment")) {
            try {
                p.setIncrement(new Double(tag.getValue("increment")));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (tag.hasParam("magnetobjs")) {
            c2.magnet.add(p);
            c2.magnet.add(tag.getValue("magnetobjs"));
            p.setMagnetRayExp(tag.getValue("magnetd"));
        }
        return true;
    }

    public static void setType(XmlTag tag, PointObject p) {
        if (tag.hasParam("shape")) {
            String s = tag.getValue("shape");
            if (s.equals("square")) {
                p.setType(0);
            }
            if (s.equals("diamond")) {
                p.setType(1);
            }
            if (s.equals("circle")) {
                p.setType(2);
            }
            if (s.equals("dot")) {
                p.setType(3);
            }
            if (s.equals("cross")) {
                p.setType(4);
            }
            if (s.equals("dcross")) {
                p.setType(5);
            }
        }
    }

    @Override
    public String getTag() {
        return "Point";
    }

    @Override
    public void construct(Construction c2, String name, String[] params, int nparams) throws ConstructionException {
        if (nparams == 0) {
            PointObject p = new PointObject(c2, c2.getX() + (Math.random() - 0.5) * c2.getW(), c2.getY() + (Math.random() - 0.5) * c2.getW());
            if (!name.equals("")) {
                p.setNameCheck(name);
            }
            c2.add(p);
            p.setDefaults();
            return;
        }
        if (nparams == 1) {
            ConstructionObject o = c2.find(params[0]);
            if (o == null) {
                throw new ConstructionException(Global.name("exception.notfound") + " " + params[0]);
            }
            if (!(o instanceof PrimitiveLineObject) && !(o instanceof PrimitiveCircleObject)) {
                throw new ConstructionException(Global.name("exception.type") + " " + params[0]);
            }
            PointObject p = new PointObject(c2, c2.getX() + (Math.random() - 0.5) * c2.getW(), c2.getY() + (Math.random() - 0.5) * c2.getW(), o);
            if (!name.equals("")) {
                p.setNameCheck(name);
            }
            c2.add(p);
            p.setDefaults();
            return;
        }
        if (nparams != 2) {
            throw new ConstructionException(Global.name("exception.nparams"));
        }
        Expression e1 = new Expression(params[0], c2, null);
        Expression e2 = new Expression(params[1], c2, null);
        if (!e1.isValid() || !e2.isValid()) {
            throw new ConstructionException(Global.name("exception.expression"));
        }
        PointObject p = new PointObject(c2, 0.0, 0.0);
        try {
            double x = new Double(params[0]);
            double y = new Double(params[1]);
            p.move(x, y);
        }
        catch (Exception e3) {
            p.setFixed(params[0], params[1]);
        }
        c2.add(p);
        p.validate();
        p.setDefaults();
        if (!name.equals("")) {
            p.setNameCheck(name);
        }
    }

    @Override
    public void reset(ZirkelCanvas zc) {
        super.reset(zc);
        zc.setPrompt(Global.name("prompt.point"));
    }
}

