/*
 * Decompiled with CFR 0.152.
 */
package carmetal.constructors;

import carmetal.construction.Construction;
import carmetal.construction.ConstructionException;
import carmetal.construction.Selector;
import carmetal.constructors.ObjectConstructor;
import carmetal.objects.ConstructionObject;
import carmetal.objects.InsideObject;
import carmetal.objects.PointObject;
import carmetal.objects.PointonObject;
import carmetal.rene.gui.Global;
import carmetal.rene.util.xml.XmlTag;
import carmetal.rene.util.xml.XmlTree;
import carmetal.rene.zirkel.ZirkelCanvas;
import java.awt.event.MouseEvent;

public class BoundedPointConstructor
extends ObjectConstructor
implements Selector {
    boolean Control;

    @Override
    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        if (!zc.Visual) {
            return;
        }
        this.Control = e2.isControlDown();
        ConstructionObject o = zc.selectWithSelector(e2.getX(), e2.getY(), this);
        if (o == null) {
            return;
        }
        PointObject p = new PointObject(zc.getConstruction(), zc.x(e2.getX()), zc.y(e2.getY()), o);
        if (!e2.isShiftDown()) {
            p.setUseAlpha(true);
        }
        if (o instanceof InsideObject) {
            p.setInside(true);
        }
        zc.addObject(p);
        p.validate();
        p.setDefaults();
    }

    @Override
    public void mouseMoved(MouseEvent e2, ZirkelCanvas zc, boolean simple) {
        this.Control = e2.isControlDown();
        zc.indicateWithSelector(e2.getX(), e2.getY(), this);
    }

    @Override
    public void showStatus(ZirkelCanvas zc) {
        zc.showStatus(Global.name("message.boundedpoint", "Bounded Point: Choose a circle or line!"));
    }

    @Override
    public boolean isAdmissible(ZirkelCanvas zc, ConstructionObject o) {
        return o instanceof InsideObject;
    }

    @Override
    public boolean construct(XmlTree tree, Construction c2) throws ConstructionException {
        if (!this.testTree(tree, "PointOn")) {
            return false;
        }
        XmlTag tag = tree.getTag();
        if (!tag.hasParam("on")) {
            throw new ConstructionException("Point bound missing!");
        }
        try {
            PointObject p;
            ConstructionObject o = c2.find(tag.getValue("on"));
            if (o != null && !(o instanceof PointonObject) && !(o instanceof InsideObject)) {
                throw new ConstructionException("");
            }
            double x = 0.0;
            double y = 0.0;
            try {
                x = new Double(tag.getValue("x"));
                y = new Double(tag.getValue("y"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (o != null) {
                p = new PointObject(c2, x, y, o);
            } else {
                p = new PointObject(c2, x, y);
                p.setLaterBind(tag.getValue("on"));
            }
            p.setInside(tag.hasTrueParam("inside"));
            try {
                ConstructionObject on;
                double alpha = new Double(tag.getValue("alpha"));
                p.setAlpha(alpha);
                p.setUseAlpha(true);
                if (tag.hasParam("on") && (on = c2.find(tag.getValue("on"))) != null) {
                    p.project(on, alpha);
                }
            }
            catch (Exception alpha) {
                // empty catch block
            }
            if (tag.hasParam("shape")) {
                String s = tag.getValue("shape");
                if (s.equals("square")) {
                    p.setType(0);
                }
                if (s.equals("diamond")) {
                    p.setType(1);
                }
                if (s.equals("circle")) {
                    p.setType(2);
                }
                if (s.equals("dot")) {
                    p.setType(3);
                }
                if (s.equals("cross")) {
                    p.setType(4);
                }
                if (s.equals("dcross")) {
                    p.setType(5);
                }
            }
            if (tag.hasParam("boundorder")) {
                p.setBoundOrder(Double.valueOf(tag.getValue("boundorder")));
            }
            this.setName(tag, p);
            this.set(tree, p);
            c2.add(p);
            this.setConditionals(tree, c2, p);
            if (tag.hasParam("fixed")) {
                p.setFixed(tag.getValue("x"), tag.getValue("y"));
            }
            if (tag.hasParam("increment")) {
                try {
                    p.setIncrement(new Double(tag.getValue("increment")));
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new ConstructionException("Illegal point bound!");
        }
        return true;
    }

    @Override
    public void reset(ZirkelCanvas zc) {
        super.reset(zc);
        zc.setPrompt(Global.name("prompt.pointon"));
    }
}

