/*
 * Decompiled with CFR 0.152.
 */
package carmetal.construction;

import carmetal.construction.Construction;
import carmetal.objects.AngleObject;
import carmetal.objects.ConstructionObject;
import carmetal.objects.ExpressionObject;
import carmetal.objects.FixedAngleObject;
import carmetal.objects.FunctionObject;
import carmetal.objects.PointObject;
import carmetal.objects.PrimitiveCircleObject;
import carmetal.objects.PrimitiveLineObject;
import carmetal.rene.gui.ButtonAction;
import carmetal.rene.gui.CheckboxMenuItemAction;
import carmetal.rene.gui.ChoiceAction;
import carmetal.rene.gui.DoActionListener;
import carmetal.rene.gui.Global;
import carmetal.rene.gui.MenuItemAction;
import carmetal.rene.lister.Lister;
import carmetal.rene.lister.ListerMouseEvent;
import carmetal.rene.zirkel.ZirkelCanvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.PopupMenu;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ConstructionDisplayPanel
extends JPanel
implements DoActionListener,
ActionListener,
ClipboardOwner {
    private static final long serialVersionUID = 1L;
    private static int control_height = 25;
    private JPanel controls;
    public Lister V;
    public Vector W;
    Construction C;
    ZirkelCanvas ZC;
    JComboBox Ch;
    CheckboxMenuItemAction Visible;
    boolean ShowVisible = true;
    CheckboxMenuItemAction Sort;
    CheckboxMenuItemAction Description;
    CheckboxMenuItemAction Size;
    CheckboxMenuItemAction Formula;
    public static String[] Choices = new String[]{"all", "points", "lines", "circles", "angles", "expressions", "other"};
    public int State = 0;
    PopupMenu PM;
    JButton Menu;

    @Override
    public void paintComponent(Graphics g) {
        Dimension d2 = this.getSize();
        g.setColor(Color.white);
        g.fillRect(0, 0, d2.width, d2.height);
        super.paintComponent(g);
    }

    public ConstructionDisplayPanel(ZirkelCanvas zc) {
        this.ZC = zc;
        this.C = this.ZC.getConstruction();
        this.V = new Lister();
        this.V.setMode(true, false, true, true);
        this.V.addActionListener(this);
        this.State = Global.getParameter("constructiondisplay.state", 0);
        this.setLayout(new BoxLayout(this, 1));
        this.setOpaque(false);
        this.controls = new JPanel();
        this.controls.setLayout(new BoxLayout(this.controls, 0));
        this.controls.setOpaque(false);
        this.Ch = new ChoiceAction(this, "choices");
        for (String choice : Choices) {
            this.Ch.addItem(Global.name("constructiondisplay." + choice));
        }
        this.controls.add(this.Ch);
        this.Menu = new ButtonAction(this, "?", "Menu");
        this.controls.add(this.Menu);
        this.add(this.controls);
        this.setListerState();
        this.makePopup();
        this.add(this.V);
    }

    public void fixPanelSize(int w, int h) {
        ConstructionDisplayPanel.fixsize(this, w, h);
        ConstructionDisplayPanel.fixsize(this.V, w, h - control_height);
        ConstructionDisplayPanel.fixsize(this.controls, w, control_height);
        this.controls.revalidate();
    }

    private static void fixsize(JComponent cp, int w, int h) {
        Dimension d2 = new Dimension(w, h);
        cp.setMaximumSize(d2);
        cp.setMinimumSize(d2);
        cp.setPreferredSize(d2);
        cp.setSize(d2);
    }

    public void reload() {
        this.V.clear();
        this.C = this.ZC.getConstruction();
        Enumeration e2 = null;
        e2 = Global.getParameter("constructiondisplay.sort", true) ? this.C.getSortedElements() : this.C.elements();
        this.W = new Vector();
        block9: while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (this.ShowVisible && o.mustHide(this.ZC) || this.ZC.job_isTargets() && o.isSuperHidden() || this.ZC.isRestricted() && o.isSuperHidden()) continue;
            switch (this.State) {
                case 0: {
                    break;
                }
                case 1: {
                    if (o instanceof PointObject) break;
                    continue block9;
                }
                case 2: {
                    if (o instanceof PrimitiveLineObject && !(o instanceof FixedAngleObject)) break;
                    continue block9;
                }
                case 3: {
                    if (o instanceof PrimitiveCircleObject) break;
                    continue block9;
                }
                case 4: {
                    if (o instanceof AngleObject || o instanceof FixedAngleObject) break;
                    continue block9;
                }
                case 5: {
                    if (o instanceof ExpressionObject || o instanceof FunctionObject) break;
                    continue block9;
                }
                case 6: {
                    if (!(o instanceof PointObject) && !(o instanceof PrimitiveLineObject) && !(o instanceof PrimitiveCircleObject) && !(o instanceof AngleObject) && !(o instanceof ExpressionObject) && !(o instanceof FunctionObject)) break;
                    continue block9;
                }
            }
            this.V.addElement(o);
            this.W.addElement(o);
        }
        this.V.showLast();
        this.updateDisplay();
    }

    public void updateDisplay() {
        this.V.updateDisplay();
    }

    @Override
    public void doAction(String o) {
        if (o.equals("Edit")) {
            int[] selected = this.V.getSelectedIndices();
            if (selected.length == 0) {
                return;
            }
            if (selected.length == 1) {
                ((ConstructionObject)this.W.elementAt(selected[0])).edit(this.ZC, true, false);
            } else {
                Vector v = new Vector();
                for (int element : selected) {
                    v.addElement(this.W.elementAt(element));
                }
                this.ZC.validate();
            }
            this.ZC.repaint();
        } else if (o.equals("Copy")) {
            try {
                ByteArrayOutputStream ba = new ByteArrayOutputStream(50000);
                PrintWriter po = new PrintWriter((Writer)new OutputStreamWriter(ba), true);
                this.V.save(po);
                po.close();
                String S = ba.toString();
                Clipboard clip = this.getToolkit().getSystemClipboard();
                StringSelection sel = new StringSelection(S);
                clip.setContents(sel, this);
            }
            catch (Exception ba) {}
        } else if (o.equals("Delete")) {
            int[] selected = this.V.getSelectedIndices();
            if (selected.length == 0) {
                return;
            }
            Vector v = new Vector();
            for (int element : selected) {
                v.addElement(this.W.elementAt(element));
            }
            this.ZC.delete(v);
            this.ZC.repaint();
            this.ZC.reset();
            this.reload();
        } else if (o.equals("Hide")) {
            int[] selected = this.V.getSelectedIndices();
            if (selected.length == 0) {
                return;
            }
            for (int element : selected) {
                ConstructionObject oc;
                oc.setHidden(!(oc = (ConstructionObject)this.W.elementAt(element)).isHidden());
            }
            this.ZC.repaint();
            this.updateDisplay();
        } else if (o.equals("SuperHide")) {
            int[] selected = this.V.getSelectedIndices();
            if (selected.length == 0) {
                return;
            }
            for (int element : selected) {
                ConstructionObject oc = (ConstructionObject)this.W.elementAt(element);
                oc.setSuperHidden(true);
            }
            this.ZC.repaint();
            this.updateDisplay();
        } else if (o.equals("HighLight")) {
            int[] selected = this.V.getSelectedIndices();
            if (selected.length == 0) {
                return;
            }
            for (int element : selected) {
                ConstructionObject oc = (ConstructionObject)this.W.elementAt(element);
                oc.setStrongSelected(true);
            }
            Graphics g = this.ZC.getGraphics();
            if (g != null) {
                this.ZC.paint(g);
                g.dispose();
                try {
                    Thread.sleep(400L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (int element : selected) {
                ConstructionObject oc = (ConstructionObject)this.W.elementAt(element);
                oc.setStrongSelected(false);
            }
            this.ZC.repaint();
        } else if (o.equals("Menu")) {
            this.displayPopup(this.V.L, 10, 10);
        }
        this.ZC.requestFocus();
    }

    public void itemToggleAction(String o) {
        if (o.equals("Sort")) {
            this.Sort.setState(!this.Sort.getState());
            this.itemAction("Sort", this.Sort.getState());
        } else if (o.equals("Visible")) {
            this.Visible.setState(!this.Visible.getState());
            this.itemAction("Visible", this.Visible.getState());
        }
    }

    @Override
    public void itemAction(String o, boolean flag) {
        if (o.equals("Sort")) {
            Global.setParameter("constructiondisplay.sort", this.Sort.getState());
            this.reload();
        } else if (o.equals("Visible")) {
            this.ShowVisible = this.Visible.getState();
            this.reload();
        } else if (o.equals("Description")) {
            Global.setParameter("constructiondisplay.listerstate", 0);
            this.setListerState();
            this.updateDisplay();
        } else if (o.equals("Size")) {
            Global.setParameter("constructiondisplay.listerstate", 2);
            this.setListerState();
            this.updateDisplay();
        } else if (o.equals("Formula")) {
            Global.setParameter("constructiondisplay.listerstate", 1);
            this.setListerState();
            this.updateDisplay();
        } else if (flag) {
            this.State = this.Ch.getSelectedIndex();
            Global.setParameter("constructiondisplay.state", this.State);
            this.reload();
        }
    }

    public void setListerState() {
        int state = Global.getParameter("constructiondisplay.listerstate", 2);
        this.V.setState(state);
        if (this.PM != null) {
            this.Description.setState(state == 0);
            this.Size.setState(state == 2);
            this.Formula.setState(state == 1);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (e2.getSource() == this.V && e2 instanceof ListerMouseEvent) {
            ListerMouseEvent em = (ListerMouseEvent)e2;
            if (em.rightMouse()) {
                this.displayPopup(em.getEvent().getComponent(), em.getEvent().getX(), em.getEvent().getY());
            } else if (em.clickCount() >= 2) {
                this.doAction("Edit");
            } else {
                this.doAction("HighLight");
            }
        }
    }

    public void displayPopup(Component c2, int x, int y) {
        this.PM.show(c2, x, y);
    }

    public void makePopup() {
        this.PM = new PopupMenu();
        this.PM.add(new MenuItemAction(this, Global.name("constructiondisplay.edit"), "Edit"));
        this.PM.addSeparator();
        this.PM.add(new MenuItemAction(this, Global.name("constructiondisplay.hide"), "Hide"));
        this.PM.add(new MenuItemAction(this, Global.name("constructiondisplay.superhide"), "SuperHide"));
        this.PM.addSeparator();
        this.PM.add(new MenuItemAction(this, Global.name("constructiondisplay.delete"), "Delete"));
        this.PM.addSeparator();
        this.Description = new CheckboxMenuItemAction(this, Global.name("constructiondisplay.description"), "Description");
        this.Description.setState(Global.getParameter("constructiondisplay.description", false));
        this.PM.add(this.Description);
        this.Size = new CheckboxMenuItemAction(this, Global.name("constructiondisplay.size"), "Size");
        this.Description.setState(Global.getParameter("constructiondisplay.size", true));
        this.PM.add(this.Size);
        this.Formula = new CheckboxMenuItemAction(this, Global.name("constructiondisplay.formula"), "Formula");
        this.Description.setState(Global.getParameter("constructiondisplay.formula", false));
        this.PM.add(this.Formula);
        this.PM.addSeparator();
        this.PM.add(new MenuItemAction(this, Global.name("constructiondisplay.copy"), "Copy"));
        this.V.L.add(this.PM);
        this.PM.addSeparator();
        this.Visible = new CheckboxMenuItemAction(this, Global.name("constructiondisplay.visible"), "Visible");
        this.Visible.setState(true);
        this.PM.add(this.Visible);
        this.Sort = new CheckboxMenuItemAction(this, Global.name("constructiondisplay.sorted"), "Sort");
        this.Sort.setState(Global.getParameter("constructiondisplay.sort", true));
        this.PM.add(this.Sort);
        this.setListerState();
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void setListingBackground(Color c2) {
        this.V.setListingBackground(c2);
    }
}

