/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class SimpleStringNumberReader {
    char commentChar;
    Reader input;
    char[] buffer = new char[1024];
    List<Object> sequence;
    int where;
    Object current;

    public SimpleStringNumberReader(char commentChar) {
        this.commentChar = commentChar;
    }

    public boolean read(Reader input) {
        this.input = input;
        try {
            this.sequence = new ArrayList<Object>();
            this.where = 0;
            int v = input.read();
            while (v >= 0) {
                if (v == this.commentChar) {
                    this.skipLine();
                } else {
                    this.parseLine(v);
                }
                v = input.read();
            }
        }
        catch (IOException e) {
            return false;
        }
        this.input = null;
        return true;
    }

    public int remainingTokens() {
        return this.sequence.size() - this.where;
    }

    public boolean next() {
        if (this.sequence.size() > this.where) {
            this.current = this.sequence.get(this.where++);
            return true;
        }
        return false;
    }

    public boolean isString() {
        return this.current instanceof String;
    }

    public String getString() {
        return (String)this.current;
    }

    public double getDouble() {
        return (Double)this.current;
    }

    public String nextString() {
        if (!this.next()) {
            throw new RuntimeException("There is no next token!");
        }
        if (!this.isString()) {
            throw new RuntimeException("The token is a double not a string. " + this.current);
        }
        return (String)this.current;
    }

    public double nextDouble() {
        if (!this.next()) {
            throw new RuntimeException("There is no next token!");
        }
        if (this.isString()) {
            throw new RuntimeException("The token is a string not a double. " + this.current);
        }
        return (Double)this.current;
    }

    private void parseLine(int v) throws IOException {
        int size = 0;
        while (v >= 0 && v != 10) {
            if (Character.isWhitespace(v)) {
                if (size > 0) {
                    this.addString(new String(this.buffer, 0, size));
                    size = 0;
                }
            } else {
                this.buffer[size++] = (char)v;
            }
            v = this.input.read();
        }
        if (size > 0) {
            this.addString(new String(this.buffer, 0, size));
        }
    }

    private void skipLine() throws IOException {
        int v = this.input.read();
        while (v >= 0 && v != 10) {
            v = this.input.read();
        }
    }

    private void addString(String s) {
        try {
            this.sequence.add(Double.parseDouble(s));
        }
        catch (NumberFormatException e) {
            this.sequence.add(s);
        }
    }

    public char getCommentChar() {
        return this.commentChar;
    }
}

