/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.learning;

import boofcv.gui.image.ShowImages;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.Random;
import javax.swing.JPanel;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.RandomMatrices;

public class ConfusionMatrixPanel
extends JPanel {
    DenseMatrix64F temp = new DenseMatrix64F(1, 1);
    DenseMatrix64F confusion = new DenseMatrix64F(1, 1);
    boolean dirty = false;
    boolean gray = false;
    boolean showNumbers = true;
    boolean showZeros = true;

    public ConfusionMatrixPanel(DenseMatrix64F M, int width, boolean gray) {
        this(width, width);
        this.setMatrix(M);
        this.gray = gray;
    }

    public ConfusionMatrixPanel(int width, int height) {
        this.setPreferredSize(new Dimension(width, height));
        this.setMinimumSize(new Dimension(width, height));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMatrix(DenseMatrix64F A) {
        ConfusionMatrixPanel confusionMatrixPanel = this;
        synchronized (confusionMatrixPanel) {
            this.temp.set((D1Matrix64F)A);
            this.dirty = true;
        }
        this.repaint();
    }

    public boolean isGray() {
        return this.gray;
    }

    public void setGray(boolean gray) {
        this.gray = gray;
    }

    public boolean isShowNumbers() {
        return this.showNumbers;
    }

    public void setShowNumbers(boolean showNumbers) {
        this.showNumbers = showNumbers;
    }

    public boolean isShowZeros() {
        return this.showZeros;
    }

    public void setShowZeros(boolean showZeros) {
        this.showZeros = showZeros;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void paint(Graphics g) {
        ConfusionMatrixPanel confusionMatrixPanel = this;
        synchronized (confusionMatrixPanel) {
            if (this.dirty) {
                this.confusion.set((D1Matrix64F)this.temp);
                this.dirty = false;
            }
        }
        Graphics2D g2 = (Graphics2D)g;
        int numRows = this.confusion.getNumRows();
        int numCols = this.confusion.getNumCols();
        int height = this.getHeight();
        int width = this.getWidth();
        Font font = new Font("Serif", 1, (int)(0.6 * (double)width / (double)numCols));
        g2.setFont(font);
        FontMetrics metrics = g2.getFontMetrics(font);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (int i = 0; i < numRows; ++i) {
            int y0 = i * height / (numRows - 1);
            int y1 = (i + 1) * height / (numRows - 1);
            for (int j = 0; j < numCols; ++j) {
                int red;
                int green;
                int blue;
                int x0 = j * width / (numCols - 1);
                int x1 = (j + 1) * width / (numCols - 1);
                double value = this.confusion.unsafe_get(i, j);
                if (this.gray) {
                    green = blue = (int)(255.0 * (1.0 - value));
                    red = blue;
                } else {
                    green = 0;
                    red = (int)(255.0 * value);
                    blue = (int)(255.0 * (1.0 - value));
                }
                g2.setColor(new Color(red, green, blue));
                g2.fillRect(x0, y0, x1 - x0, y1 - y0);
                if (!this.showNumbers || !this.showZeros && value == 0.0) continue;
                int a = (red + green + blue) / 3;
                String text = "" + (int)(value * 100.0 + 0.5);
                Rectangle2D r = metrics.getStringBounds(text, null);
                float adjX = (float)(r.getX() * 2.0 + r.getWidth()) / 2.0f;
                float adjY = (float)(r.getY() * 2.0 + r.getHeight()) / 2.0f;
                float x = (float)(x1 + x0) / 2.0f - adjX;
                float y = (float)(y1 + y0) / 2.0f - adjY;
                int gray = a > 127 ? 0 : 255;
                g2.setColor(new Color(gray, gray, gray));
                g2.drawString(text, x, y);
            }
        }
    }

    public static void main(String[] args) {
        DenseMatrix64F m = RandomMatrices.createRandom((int)5, (int)5, (double)0.0, (double)1.0, (Random)new Random(234L));
        ShowImages.showWindow(new ConfusionMatrixPanel(m, 300, true), "Window", true);
    }
}

