/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui;

import boofcv.io.MediaManager;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.SimpleImageSequence;
import boofcv.io.image.UtilImageIO;
import boofcv.io.wrapper.DefaultMediaManager;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import java.awt.BorderLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;

public abstract class DemonstrationBase<T extends ImageBase>
extends JPanel {
    protected JMenuBar menuBar;
    JMenuItem menuFile;
    JMenuItem menuWebcam;
    JMenuItem menuQuit;
    final JFileChooser fc = new JFileChooser();
    protected InputMethod inputMethod = InputMethod.NONE;
    ImageSequenceThread sequenceThread;
    volatile boolean waitingToOpenImage = false;
    final Object waitingLock = new Object();
    volatile boolean processRunning = false;
    volatile boolean processRequested = false;
    final Object processLock = new Object();
    BufferedImage imageCopy0;
    BufferedImage imageCopy1;
    T boofCopy1;
    protected ImageType<T> imageType;
    T input;
    BufferedImage inputBuffered;
    MediaManager media = new DefaultMediaManager();

    public DemonstrationBase(List<String> exampleInputs, ImageType<T> imageType) {
        super(new BorderLayout());
        this.createMenuBar(exampleInputs);
        this.input = imageType.createImage(1, 1);
        this.imageType = imageType;
        this.boofCopy1 = imageType.createImage(1, 1);
    }

    private void createMenuBar(List<String> exampleInputs) {
        this.menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        this.menuBar.add(menu);
        ActionListener listener = this.createActionListener();
        this.menuFile = new JMenuItem("Open File", 79);
        this.menuFile.addActionListener(listener);
        this.menuFile.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.menuWebcam = new JMenuItem("Open Webcam", 87);
        this.menuWebcam.addActionListener(listener);
        this.menuWebcam.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.menuQuit = new JMenuItem("Quit", 81);
        this.menuQuit.addActionListener(listener);
        this.menuQuit.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        menu.add(this.menuFile);
        menu.add(this.menuWebcam);
        menu.addSeparator();
        menu.add(this.menuQuit);
        menu = new JMenu("Examples");
        this.menuBar.add(menu);
        for (final String path : exampleInputs) {
            JMenuItem menuItem = new JMenuItem(new File(path).getName());
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DemonstrationBase.this.openFile(new File(path));
                }
            });
            menu.add(menuItem);
        }
        this.add("North", this.menuBar);
    }

    public abstract void processImage(BufferedImage var1, T var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processImageThread(BufferedImage buffered, T input) {
        Object object = this.processLock;
        synchronized (object) {
            if (this.processRunning) {
                if (buffered != null) {
                    this.imageCopy1 = this.checkCopyBuffered(buffered, this.imageCopy1);
                    ((ImageBase)this.boofCopy1).setTo(input);
                } else {
                    this.imageCopy1 = null;
                }
                this.processRequested = true;
                return;
            }
            this.processRunning = true;
            this.processRequested = false;
            this.imageCopy0 = buffered != null ? this.checkCopyBuffered(buffered, this.imageCopy0) : null;
        }
        new Thread((ImageBase)input){
            final /* synthetic */ ImageBase val$input;
            {
                this.val$input = imageBase;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                try {
                    while (true) {
                        Object object = DemonstrationBase.this.waitingLock;
                        // MONITORENTER : object
                        DemonstrationBase.this.waitingToOpenImage = false;
                        // MONITOREXIT : object
                        if (DemonstrationBase.this.imageCopy0 != null) {
                            DemonstrationBase.this.processImage(DemonstrationBase.this.imageCopy0, this.val$input);
                        } else {
                            DemonstrationBase.this.processImage(null, null);
                        }
                        object = DemonstrationBase.this.processLock;
                        // MONITORENTER : object
                        if (!DemonstrationBase.this.processRequested) {
                            DemonstrationBase.this.processRunning = false;
                            // MONITOREXIT : object
                            return;
                        }
                        DemonstrationBase.this.processRequested = false;
                        if (DemonstrationBase.this.imageCopy1 != null) {
                            DemonstrationBase.this.imageCopy0 = DemonstrationBase.this.checkCopyBuffered(DemonstrationBase.this.imageCopy1, DemonstrationBase.this.imageCopy0);
                            this.val$input.setTo(DemonstrationBase.this.boofCopy1);
                        } else {
                            DemonstrationBase.this.imageCopy0 = null;
                        }
                        // MONITOREXIT : object
                    }
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    System.out.println(e.getMessage());
                    System.out.println("Thread crashed!  If possible, saving image to crashed_image.png");
                    if (DemonstrationBase.this.imageCopy0 != null) {
                        UtilImageIO.saveImage(DemonstrationBase.this.imageCopy0, "crashed_image.png");
                    }
                    Object object = DemonstrationBase.this.processLock;
                    // MONITORENTER : object
                    DemonstrationBase.this.processRunning = false;
                    // MONITOREXIT : object
                    return;
                }
            }
        }.start();
    }

    private BufferedImage checkCopyBuffered(BufferedImage src, BufferedImage dst) {
        dst = DemonstrationBase.conditionalDeclare(src, dst);
        dst.createGraphics().drawImage((Image)src, 0, 0, null);
        return dst;
    }

    public static BufferedImage conditionalDeclare(BufferedImage template, BufferedImage output) {
        if (output == null || output.getWidth() != template.getWidth() || output.getHeight() != template.getHeight()) {
            int type;
            if (output == null) {
                type = template.getType();
                if (type == 0) {
                    type = 1;
                }
            } else {
                type = output.getType();
            }
            output = new BufferedImage(template.getWidth(), template.getHeight(), type);
        }
        return output;
    }

    public static BufferedImage conditionalDeclare(BufferedImage template, BufferedImage output, int type) {
        if (output == null || output.getWidth() != template.getWidth() || output.getHeight() != template.getHeight()) {
            output = new BufferedImage(template.getWidth(), template.getHeight(), type);
        }
        return output;
    }

    private void stopPreviousInput() {
        switch (this.inputMethod) {
            case WEBCAM: {
                this.stopSequenceRunning("Shutting down webcam");
                break;
            }
            case VIDEO: {
                this.stopSequenceRunning("Shutting down video");
            }
        }
    }

    private void stopSequenceRunning(String message) {
        this.sequenceThread.requestStop = true;
        WaitingThread waiting = new WaitingThread(message);
        waiting.start();
        while (this.sequenceThread.running) {
            Thread.yield();
        }
        waiting.closeRequested = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openFile(File file) {
        BufferedImage buffered;
        Object object = this.waitingLock;
        synchronized (object) {
            if (this.waitingToOpenImage) {
                System.out.println("Waiting to open an image");
                return;
            }
            this.waitingToOpenImage = true;
        }
        this.stopPreviousInput();
        String filePath = UtilIO.pathExample(file.getPath());
        BufferedImage bufferedImage = buffered = filePath.endsWith("mjpeg") ? null : UtilImageIO.loadImage(filePath);
        if (buffered == null) {
            SimpleImageSequence<T> sequence = this.media.openVideo(filePath, this.imageType);
            if (sequence != null) {
                this.inputMethod = InputMethod.VIDEO;
                this.sequenceThread = new ImageSequenceThread(sequence, 30L);
                this.sequenceThread.start();
            } else {
                this.inputMethod = InputMethod.NONE;
                this.waitingToOpenImage = false;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(DemonstrationBase.this, "Can't open file");
                    }
                });
            }
        } else {
            this.inputMethod = InputMethod.IMAGE;
            ((ImageBase)this.input).reshape(buffered.getWidth(), buffered.getHeight());
            this.inputBuffered = buffered;
            ConvertBufferedImage.convertFrom(buffered, this.input, true);
            this.processImageThread(buffered, this.input);
        }
    }

    public void waitUntilDoneProcessing() {
        while (this.processRunning) {
            Thread.yield();
        }
    }

    public void openWebcam() {
        if (this.waitingToOpenImage) {
            return;
        }
        this.stopPreviousInput();
        this.waitingToOpenImage = true;
        this.inputMethod = InputMethod.WEBCAM;
        new WaitingThread("Opening Webcam").start();
        new Thread(){

            @Override
            public void run() {
                SimpleImageSequence sequence = DemonstrationBase.this.media.openCamera(null, 640, 480, DemonstrationBase.this.imageType);
                if (sequence != null) {
                    DemonstrationBase.this.sequenceThread = new ImageSequenceThread(sequence, 0L);
                    DemonstrationBase.this.sequenceThread.start();
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(DemonstrationBase.this, "Failed to open webcam");
                        }
                    });
                }
            }
        }.start();
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DemonstrationBase.this.menuFile == e.getSource()) {
                    int returnVal = DemonstrationBase.this.fc.showOpenDialog(DemonstrationBase.this);
                    if (returnVal == 0) {
                        File file = DemonstrationBase.this.fc.getSelectedFile();
                        DemonstrationBase.this.openFile(file);
                    }
                } else if (DemonstrationBase.this.menuWebcam == e.getSource()) {
                    DemonstrationBase.this.openWebcam();
                } else if (DemonstrationBase.this.menuQuit == e.getSource()) {
                    System.exit(0);
                }
            }
        };
    }

    public void reprocessSingleImage() {
        if (this.sequenceThread == null) {
            this.processImageThread(this.inputBuffered, this.input);
        }
    }

    protected static enum InputMethod {
        NONE,
        IMAGE,
        VIDEO,
        WEBCAM;

    }

    class ImageSequenceThread
    extends Thread {
        boolean requestStop = false;
        boolean running = true;
        SimpleImageSequence<T> sequence;
        long pause;

        public ImageSequenceThread(SimpleImageSequence<T> sequence, long pause) {
            this.sequence = sequence;
            this.pause = pause;
        }

        @Override
        public void run() {
            Object input;
            long before = System.currentTimeMillis();
            while (!this.requestStop && this.sequence.hasNext() && (input = this.sequence.next()) != null) {
                BufferedImage buffered = (BufferedImage)this.sequence.getGuiImage();
                DemonstrationBase.this.processImageThread(buffered, input);
                if (this.pause > 0L) {
                    long time = Math.max(0L, this.pause - (System.currentTimeMillis() - before));
                    if (time > 0L) {
                        try {
                            Thread.sleep(time);
                        }
                        catch (InterruptedException interruptedException) {}
                    } else {
                        try {
                            Thread.sleep(5L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                } else {
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                before = System.currentTimeMillis();
            }
            this.sequence.close();
            this.running = false;
        }
    }

    class WaitingThread
    extends Thread {
        ProgressMonitor progress;
        public volatile boolean closeRequested = false;

        public WaitingThread(String message) {
            this.progress = new ProgressMonitor(DemonstrationBase.this, message, "", 0, 100);
        }

        @Override
        public void run() {
            while (DemonstrationBase.this.waitingToOpenImage && !this.closeRequested) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WaitingThread.this.progress.setProgress(0);
                    }
                });
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {}
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WaitingThread.this.progress.close();
                }
            });
        }
    }
}

