/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.tracking;

import boofcv.alg.tracker.meanshift.PixelLikelihood;
import boofcv.alg.tracker.meanshift.TrackerMeanShiftLikelihood;
import boofcv.gui.image.ShowImages;
import boofcv.gui.tracker.TrackerObjectQuadPanel;
import boofcv.io.UtilIO;
import boofcv.io.image.SimpleImageSequence;
import boofcv.io.wrapper.DefaultMediaManager;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import georegression.struct.shapes.RectangleLength2D_I32;
import java.awt.Dimension;
import java.awt.image.BufferedImage;

public class ExampleTrackerMeanShiftLikelihood {
    public static void main(String[] args) {
        DefaultMediaManager media = DefaultMediaManager.INSTANCE;
        String fileName = UtilIO.pathExample("tracking/balls_blue_red.mjpeg");
        RectangleLength2D_I32 location = new RectangleLength2D_I32(394, 247, 81, 78);
        ImageType<Planar<GrayU8>> imageType = ImageType.pl(3, GrayU8.class);
        SimpleImageSequence<Planar<GrayU8>> video = media.openVideo(fileName, imageType);
        RgbLikelihood likelihood = new RgbLikelihood(64, 71, 69);
        TrackerMeanShiftLikelihood<Planar<GrayU8>> tracker = new TrackerMeanShiftLikelihood<Planar<GrayU8>>(likelihood, 50, 0.1f);
        Planar<GrayU8> frame = video.next();
        tracker.initialize(frame, location);
        TrackerObjectQuadPanel gui = new TrackerObjectQuadPanel(null);
        gui.setPreferredSize(new Dimension(frame.getWidth(), frame.getHeight()));
        gui.setBackGround((BufferedImage)video.getGuiImage());
        gui.setTarget(location, true);
        ShowImages.showWindow(gui, "Tracking Results", true);
        while (video.hasNext()) {
            frame = video.next();
            boolean visible = tracker.process(frame);
            gui.setBackGround((BufferedImage)video.getGuiImage());
            gui.setTarget(tracker.getLocation(), visible);
            gui.repaint();
            BoofMiscOps.pause(20L);
        }
    }

    public static class RgbLikelihood
    implements PixelLikelihood<Planar<GrayU8>> {
        int targetRed;
        int targetGreen;
        int targetBlue;
        float radius = 35.0f;
        Planar<GrayU8> image;

        public RgbLikelihood(int targetRed, int targetGreen, int targetBlue) {
            this.targetRed = targetRed;
            this.targetGreen = targetGreen;
            this.targetBlue = targetBlue;
        }

        @Override
        public void setImage(Planar<GrayU8> image) {
            this.image = image;
        }

        @Override
        public boolean isInBounds(int x, int y) {
            return this.image.isInBounds(x, y);
        }

        @Override
        public void createModel(RectangleLength2D_I32 target) {
            throw new RuntimeException("Not supported");
        }

        @Override
        public float compute(int x, int y) {
            int pixelR = this.image.getBand(0).get(x, y);
            int pixelG = this.image.getBand(1).get(x, y);
            int pixelB = this.image.getBand(2).get(x, y);
            float red = Math.max(0.0f, 1.0f - (float)Math.abs(this.targetRed - pixelR) / this.radius);
            float green = Math.max(0.0f, 1.0f - (float)Math.abs(this.targetGreen - pixelG) / this.radius);
            float blue = Math.max(0.0f, 1.0f - (float)Math.abs(this.targetBlue - pixelB) / this.radius);
            return red * green * blue;
        }
    }
}

