/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.stereo;

import boofcv.abst.feature.associate.AssociateDescription;
import boofcv.abst.feature.associate.ScoreAssociation;
import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.abst.feature.detect.interest.ConfigFastHessian;
import boofcv.abst.geo.Estimate1ofEpipolar;
import boofcv.abst.geo.RefineEpipolar;
import boofcv.abst.geo.fitting.DistanceFromModelResidual;
import boofcv.abst.geo.fitting.GenerateEpipolarMatrix;
import boofcv.abst.geo.fitting.ModelManagerEpipolarMatrix;
import boofcv.alg.geo.f.FundamentalResidualSampson;
import boofcv.examples.features.ExampleAssociatePoints;
import boofcv.factory.feature.associate.FactoryAssociation;
import boofcv.factory.feature.detdesc.FactoryDetectDescribe;
import boofcv.factory.geo.EnumEpipolar;
import boofcv.factory.geo.EpipolarError;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.gui.feature.AssociationPanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.BrightFeature;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.image.GrayF32;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelGenerator;
import org.ddogleg.fitting.modelset.ModelManager;
import org.ddogleg.fitting.modelset.ransac.Ransac;
import org.ddogleg.struct.FastQueue;
import org.ejml.data.DenseMatrix64F;

public class ExampleFundamentalMatrix {
    public static DenseMatrix64F robustFundamental(List<AssociatedPair> matches, List<AssociatedPair> inliers) {
        DistanceFromModelResidual<DenseMatrix64F, AssociatedPair> errorMetric;
        ModelManagerEpipolarMatrix managerF = new ModelManagerEpipolarMatrix();
        Estimate1ofEpipolar estimateF = FactoryMultiView.computeFundamental_1(EnumEpipolar.FUNDAMENTAL_7_LINEAR, 2);
        GenerateEpipolarMatrix generateF = new GenerateEpipolarMatrix(estimateF);
        Ransac robustF = new Ransac(123123L, (ModelManager)managerF, (ModelGenerator)generateF, errorMetric = new DistanceFromModelResidual<DenseMatrix64F, AssociatedPair>(new FundamentalResidualSampson()), 6000, 0.1);
        if (!robustF.process(matches)) {
            throw new IllegalArgumentException("Failed");
        }
        inliers.addAll(robustF.getMatchSet());
        DenseMatrix64F F = new DenseMatrix64F(3, 3);
        RefineEpipolar refine = FactoryMultiView.refineFundamental(1.0E-8, 400, EpipolarError.SAMPSON);
        if (!refine.fitModel(inliers, robustF.getModelParameters(), F)) {
            throw new IllegalArgumentException("Failed");
        }
        return F;
    }

    public static DenseMatrix64F simpleFundamental(List<AssociatedPair> matches) {
        DenseMatrix64F F;
        Estimate1ofEpipolar estimateF = FactoryMultiView.computeFundamental_1(EnumEpipolar.FUNDAMENTAL_8_LINEAR, 0);
        if (!estimateF.process(matches, F = new DenseMatrix64F(3, 3))) {
            throw new IllegalArgumentException("Failed");
        }
        return F;
    }

    public static List<AssociatedPair> computeMatches(BufferedImage left, BufferedImage right) {
        DetectDescribePoint<GrayF32, BrightFeature> detDesc = FactoryDetectDescribe.surfStable(new ConfigFastHessian(1.0f, 2, 200, 1, 9, 4, 4), null, null, GrayF32.class);
        ScoreAssociation<BrightFeature> scorer = FactoryAssociation.scoreEuclidean(BrightFeature.class, true);
        AssociateDescription<BrightFeature> associate = FactoryAssociation.greedy(scorer, 1.0, true);
        ExampleAssociatePoints<GrayF32, BrightFeature> findMatches = new ExampleAssociatePoints<GrayF32, BrightFeature>(detDesc, associate, GrayF32.class);
        findMatches.associate(left, right);
        ArrayList<AssociatedPair> matches = new ArrayList<AssociatedPair>();
        FastQueue<AssociatedIndex> matchIndexes = associate.getMatches();
        for (int i = 0; i < matchIndexes.size; ++i) {
            AssociatedIndex a = (AssociatedIndex)matchIndexes.get(i);
            AssociatedPair p = new AssociatedPair(findMatches.pointsA.get(a.src), findMatches.pointsB.get(a.dst));
            matches.add(p);
        }
        return matches;
    }

    public static void main(String[] args) {
        String dir = UtilIO.pathExample("structure/");
        BufferedImage imageA = UtilImageIO.loadImage(dir, "undist_cyto_01.jpg");
        BufferedImage imageB = UtilImageIO.loadImage(dir, "undist_cyto_02.jpg");
        List<AssociatedPair> matches = ExampleFundamentalMatrix.computeMatches(imageA, imageB);
        ArrayList<AssociatedPair> inliers = new ArrayList<AssociatedPair>();
        DenseMatrix64F F = ExampleFundamentalMatrix.robustFundamental(matches, inliers);
        System.out.println("Robust");
        F.print();
        F = ExampleFundamentalMatrix.simpleFundamental(matches);
        System.out.println("Simple");
        F.print();
        AssociationPanel panel = new AssociationPanel(20);
        panel.setAssociation(inliers);
        panel.setImages(imageA, imageB);
        ShowImages.showWindow(panel, "Inlier Pairs");
    }
}

