/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.imageprocessing;

import boofcv.abst.filter.blur.BlurStorageFilter;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.filter.blur.BlurImageOps;
import boofcv.alg.filter.blur.GBlurImageOps;
import boofcv.alg.filter.derivative.DerivativeType;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.alg.filter.derivative.GradientSobel;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.core.image.border.BorderType;
import boofcv.core.image.border.FactoryImageBorderAlgs;
import boofcv.factory.filter.blur.FactoryBlurFilter;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.gui.ListDisplayPanel;
import boofcv.gui.image.ShowImages;
import boofcv.gui.image.VisualizeImageData;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import java.awt.image.BufferedImage;

public class ExampleImageFilter {
    private static int blurRadius = 10;
    private static ListDisplayPanel panel = new ListDisplayPanel();

    public static void procedural(GrayU8 input) {
        GrayU8 blurred = new GrayU8(input.width, input.height);
        GrayS16 derivX = new GrayS16(input.width, input.height);
        GrayS16 derivY = new GrayS16(input.width, input.height);
        BlurImageOps.gaussian(input, blurred, -1.0, blurRadius, null);
        GradientSobel.process(blurred, derivX, derivY, FactoryImageBorderAlgs.extend(input));
        BufferedImage outputImage = VisualizeImageData.colorizeGradient(derivX, derivY, -1);
        panel.addImage(outputImage, "Procedural Fixed Type");
    }

    public static <T extends ImageGray, D extends ImageGray> void generalized(T input) {
        Class<?> inputType = input.getClass();
        Class derivType = GImageDerivativeOps.getDerivativeType(inputType);
        ImageGray blurred = (ImageGray)input.createSameShape();
        Object derivX = GeneralizedImageOps.createSingleBand(derivType, input.width, input.height);
        Object derivY = GeneralizedImageOps.createSingleBand(derivType, input.width, input.height);
        GBlurImageOps.gaussian(input, blurred, -1.0, blurRadius, null);
        GImageDerivativeOps.gradient(DerivativeType.SOBEL, blurred, derivX, derivY, BorderType.EXTENDED);
        BufferedImage outputImage = VisualizeImageData.colorizeGradient(derivX, derivY, -1.0);
        panel.addImage(outputImage, "Generalized " + inputType.getSimpleName());
    }

    public static <T extends ImageGray, D extends ImageGray> void filter(T input) {
        Class<?> inputType = input.getClass();
        Class derivType = GImageDerivativeOps.getDerivativeType(inputType);
        ImageGray blurred = (ImageGray)input.createSameShape();
        Object derivX = GeneralizedImageOps.createSingleBand(derivType, input.width, input.height);
        Object derivY = GeneralizedImageOps.createSingleBand(derivType, input.width, input.height);
        BlurStorageFilter<?> filterBlur = FactoryBlurFilter.gaussian(inputType, -1.0, blurRadius);
        ImageGradient gradient = FactoryDerivative.sobel(inputType, derivType);
        filterBlur.process(input, blurred);
        gradient.process(blurred, derivX, derivY);
        BufferedImage outputImage = VisualizeImageData.colorizeGradient(derivX, derivY, -1.0);
        panel.addImage(outputImage, "Filter " + inputType.getSimpleName());
    }

    public static void nogenerics(ImageGray input) {
        Class<?> inputType = input.getClass();
        Class derivType = GImageDerivativeOps.getDerivativeType(inputType);
        ImageGray blurred = (ImageGray)input.createSameShape();
        Object derivX = GeneralizedImageOps.createSingleBand(derivType, input.width, input.height);
        Object derivY = GeneralizedImageOps.createSingleBand(derivType, input.width, input.height);
        GBlurImageOps.gaussian(input, blurred, -1.0, blurRadius, null);
        GImageDerivativeOps.gradient(DerivativeType.SOBEL, blurred, derivX, derivY, BorderType.EXTENDED);
        BufferedImage outputImage = VisualizeImageData.colorizeGradient(derivX, derivY, -1.0);
        panel.addImage(outputImage, "Generalized " + inputType.getSimpleName());
    }

    public static void main(String[] args) {
        BufferedImage image = UtilImageIO.loadImage(UtilIO.pathExample("standard/lena512.jpg"));
        ExampleImageFilter.procedural(ConvertBufferedImage.convertFromSingle(image, null, GrayU8.class));
        ExampleImageFilter.generalized(ConvertBufferedImage.convertFromSingle(image, null, GrayU8.class));
        ExampleImageFilter.filter(ConvertBufferedImage.convertFromSingle(image, null, GrayU8.class));
        ExampleImageFilter.nogenerics(ConvertBufferedImage.convertFromSingle(image, null, GrayU8.class));
        ExampleImageFilter.generalized(ConvertBufferedImage.convertFromSingle(image, null, GrayF32.class));
        ShowImages.showWindow(panel, "Image Filter Examples", true);
    }
}

