/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.imageprocessing;

import boofcv.alg.filter.derivative.DerivativeType;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.alg.misc.GPixelMath;
import boofcv.alg.misc.ImageStatistics;
import boofcv.core.image.ConvertImage;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.core.image.border.BorderType;
import boofcv.gui.ListDisplayPanel;
import boofcv.gui.image.ShowImages;
import boofcv.gui.image.VisualizeImageData;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import java.awt.image.BufferedImage;

public class ExampleImageConvert {
    BufferedImage image;
    GrayU8 gray;
    GrayS16 derivX;
    GrayS16 derivY;

    void convert() {
        GrayU16 imageU16 = new GrayU16(this.gray.width, this.gray.height);
        ConvertImage.convert(this.gray, imageU16);
        ConvertImage.convert(imageU16, this.gray);
        GrayU8 imageBad = new GrayU8(this.derivX.width, this.derivX.height);
        ConvertImage.convert(this.derivX, imageBad);
        GrayS16 scaledAbs = new GrayS16(this.derivX.width, this.derivX.height);
        GPixelMath.abs(this.derivX, scaledAbs);
        GPixelMath.multiply(scaledAbs, 255.0 / (double)ImageStatistics.max(scaledAbs), scaledAbs);
        BufferedImage colorX = VisualizeImageData.colorizeSign((ImageGray)this.derivX, null, -1.0);
        BufferedImage outBad = new BufferedImage(imageBad.width, imageBad.height, 1);
        BufferedImage outScaled = new BufferedImage(imageBad.width, imageBad.height, 1);
        ListDisplayPanel panel = new ListDisplayPanel();
        panel.addImage(ConvertBufferedImage.convertTo(scaledAbs, outScaled), "Scaled");
        panel.addImage(colorX, "Visualized");
        panel.addImage(ConvertBufferedImage.convertTo(imageBad, outBad), "Bad");
        ShowImages.showWindow(panel, "Image Convert", true);
    }

    public void createImages() {
        this.image = UtilImageIO.loadImage(UtilIO.pathExample("standard/barbara.jpg"));
        this.gray = ConvertBufferedImage.convertFromSingle(this.image, null, GrayU8.class);
        this.derivX = GeneralizedImageOps.createSingleBand(GrayS16.class, this.gray.getWidth(), this.gray.getHeight());
        this.derivY = GeneralizedImageOps.createSingleBand(GrayS16.class, this.gray.getWidth(), this.gray.getHeight());
        GImageDerivativeOps.gradient(DerivativeType.SOBEL, this.gray, this.derivX, this.derivY, BorderType.EXTENDED);
    }

    public static void main(String[] args) {
        ExampleImageConvert app = new ExampleImageConvert();
        app.createImages();
        app.convert();
    }
}

