/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.imageprocessing;

import boofcv.abst.transform.fft.DiscreteFourierTransform;
import boofcv.alg.filter.blur.BlurImageOps;
import boofcv.alg.misc.PixelMath;
import boofcv.alg.transform.fft.DiscreteFourierTransformOps;
import boofcv.gui.ListDisplayPanel;
import boofcv.gui.image.ImageGridPanel;
import boofcv.gui.image.ShowImages;
import boofcv.gui.image.VisualizeImageData;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.InterleavedF32;
import java.awt.image.BufferedImage;

public class ExampleFourierTransform {
    public static void applyBoxFilter(GrayF32 input) {
        GrayF32 boxImage = new GrayF32(input.width, input.height);
        InterleavedF32 boxTransform = new InterleavedF32(input.width, input.height, 2);
        InterleavedF32 transform = new InterleavedF32(input.width, input.height, 2);
        GrayF32 blurredImage = new GrayF32(input.width, input.height);
        GrayF32 spatialBlur = new GrayF32(input.width, input.height);
        DiscreteFourierTransform<GrayF32, InterleavedF32> dft = DiscreteFourierTransformOps.createTransformF32();
        PixelMath.divide(input, 255.0f, input);
        dft.forward(input, transform);
        for (int y = 0; y < 15; ++y) {
            int yy = y - 7 < 0 ? boxImage.height + (y - 7) : y - 7;
            for (int x = 0; x < 15; ++x) {
                int xx = x - 7 < 0 ? boxImage.width + (x - 7) : x - 7;
                boxImage.set(xx, yy, 0.0044444446f);
            }
        }
        dft.forward(boxImage, boxTransform);
        ExampleFourierTransform.displayTransform(transform, "Input Image");
        ExampleFourierTransform.displayTransform(boxTransform, "Box Filter");
        DiscreteFourierTransformOps.multiplyComplex(transform, boxTransform, transform);
        dft.inverse(transform, blurredImage);
        PixelMath.multiply(blurredImage, 255.0f, blurredImage);
        PixelMath.multiply(input, 255.0f, input);
        BlurImageOps.mean(input, spatialBlur, 7, null);
        BufferedImage originOut = ConvertBufferedImage.convertTo(input, null);
        BufferedImage spacialOut = ConvertBufferedImage.convertTo(spatialBlur, null);
        BufferedImage blurredOut = ConvertBufferedImage.convertTo(blurredImage, null);
        ListDisplayPanel listPanel = new ListDisplayPanel();
        listPanel.addImage(originOut, "Original Image");
        listPanel.addImage(spacialOut, "Spacial Domain Box");
        listPanel.addImage(blurredOut, "Frequency Domain Box");
        ShowImages.showWindow(listPanel, "Box Blur in Spacial and Frequency Domain of Input Image");
    }

    public static void displayTransform(InterleavedF32 transform, String name) {
        GrayF32 magnitude = new GrayF32(transform.width, transform.height);
        GrayF32 phase = new GrayF32(transform.width, transform.height);
        transform = (InterleavedF32)transform.clone();
        DiscreteFourierTransformOps.shiftZeroFrequency(transform, true);
        DiscreteFourierTransformOps.magnitude(transform, magnitude);
        DiscreteFourierTransformOps.phase(transform, phase);
        PixelMath.log(magnitude, magnitude);
        BufferedImage visualMag = VisualizeImageData.grayMagnitude((ImageGray)magnitude, null, -1.0);
        BufferedImage visualPhase = VisualizeImageData.colorizeSign((ImageGray)phase, null, Math.PI);
        ImageGridPanel dual = new ImageGridPanel(1, 2, visualMag, visualPhase);
        ShowImages.showWindow(dual, "Magnitude and Phase of " + name);
    }

    public static void main(String[] args) {
        GrayF32 input = UtilImageIO.loadImage(UtilIO.pathExample("standard/lena512.jpg"), GrayF32.class);
        ExampleFourierTransform.applyBoxFilter((GrayF32)input.clone());
    }
}

