/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.imageprocessing;

import boofcv.alg.color.ColorHsv;
import boofcv.alg.color.ColorYuv;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.Planar;
import java.awt.image.BufferedImage;

public class ExampleColorSpace {
    public static void main(String[] args) {
        BufferedImage image = UtilImageIO.loadImage(UtilIO.pathExample("sunflowers.jpg"));
        Planar<GrayF32> rgb = ConvertBufferedImage.convertFromMulti(image, null, true, GrayF32.class);
        Planar hsv = (Planar)rgb.createSameShape();
        ColorHsv.rgbToHsv_F32(rgb, hsv);
        Planar yuv = (Planar)rgb.createSameShape();
        ColorYuv.yuvToRgb_F32(rgb, yuv);
        float[] pixelHsv = new float[3];
        ColorHsv.rgbToHsv(10.0f, 50.6f, 120.0f, pixelHsv);
        System.out.printf("Found RGB->HSV = %5.2f %5.3f %5.1f\n", Float.valueOf(pixelHsv[0]), Float.valueOf(pixelHsv[1]), Float.valueOf(pixelHsv[2]));
        float[] pixelRgb = new float[3];
        ColorHsv.hsvToRgb(pixelHsv[0], pixelHsv[1], pixelHsv[2], pixelRgb);
        System.out.printf("Found HSV->RGB = %5.1f %5.1f %5.1f expected 10 50.6 120\n", Float.valueOf(pixelRgb[0]), Float.valueOf(pixelRgb[1]), Float.valueOf(pixelRgb[2]));
        float[] pixelYuv = new float[3];
        ColorYuv.rgbToYuv(10.0f, 50.6f, 120.0f, pixelYuv);
        System.out.printf("Found RGB->YUV = %5.1f %5.1f %5.1f\n", Float.valueOf(pixelYuv[0]), Float.valueOf(pixelYuv[1]), Float.valueOf(pixelYuv[2]));
        ColorYuv.yuvToRgb(pixelYuv[0], pixelYuv[1], pixelYuv[2], pixelRgb);
        System.out.printf("Found YUV->RGB = %5.1f %5.1f %5.1f expected 10 50.6 120\n", Float.valueOf(pixelRgb[0]), Float.valueOf(pixelRgb[1]), Float.valueOf(pixelRgb[2]));
    }
}

