/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.geometry;

import boofcv.abst.feature.detect.interest.ConfigGeneralDetector;
import boofcv.abst.feature.tracker.PointTracker;
import boofcv.abst.sfm.d2.ImageMotion2D;
import boofcv.abst.sfm.d2.PlToGrayMotion2D;
import boofcv.alg.sfm.d2.StitchingFromMotion2D;
import boofcv.factory.feature.tracker.FactoryPointTracker;
import boofcv.factory.sfm.FactoryMotion2D;
import boofcv.gui.image.ImageGridPanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.SimpleImageSequence;
import boofcv.io.wrapper.DefaultMediaManager;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import georegression.struct.homography.Homography2D_F64;
import georegression.struct.point.Point2D_F64;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class ExampleVideoMosaic {
    public static void main(String[] args) {
        ConfigGeneralDetector confDetector = new ConfigGeneralDetector();
        confDetector.threshold = 1.0f;
        confDetector.maxFeatures = 300;
        confDetector.radius = 3;
        PointTracker<GrayF32> tracker = FactoryPointTracker.klt(new int[]{1, 2, 4, 8}, confDetector, 3, GrayF32.class, GrayF32.class);
        ImageMotion2D<GrayF32, Homography2D_F64> motion2D = FactoryMotion2D.createMotion2D(220, 3.0, 2, 30, 0.6, 0.5, false, tracker, new Homography2D_F64());
        PlToGrayMotion2D<GrayF32, Homography2D_F64> motion2DColor = new PlToGrayMotion2D<GrayF32, Homography2D_F64>(motion2D, GrayF32.class);
        StitchingFromMotion2D<Planar<GrayF32>, Homography2D_F64> stitch = FactoryMotion2D.createVideoStitchMS(0.5, motion2DColor, GrayF32.class);
        DefaultMediaManager media = DefaultMediaManager.INSTANCE;
        String fileName = UtilIO.pathExample("mosaic/airplane01.mjpeg");
        SimpleImageSequence<Planar<GrayF32>> video = media.openVideo(fileName, ImageType.pl(3, GrayF32.class));
        Planar<GrayF32> frame = video.next();
        Homography2D_F64 shrink = new Homography2D_F64(0.5, 0.0, (double)(frame.width / 4), 0.0, 0.5, (double)(frame.height / 4), 0.0, 0.0, 1.0);
        shrink = shrink.invert(null);
        stitch.configure(frame.width, frame.height, shrink);
        stitch.process(frame);
        ImageGridPanel gui = new ImageGridPanel(1, 2);
        gui.setImage(0, 0, new BufferedImage(frame.width, frame.height, 1));
        gui.setImage(0, 1, new BufferedImage(frame.width, frame.height, 1));
        gui.setPreferredSize(new Dimension(3 * frame.width, frame.height * 2));
        ShowImages.showWindow(gui, "Example Mosaic", true);
        boolean enlarged = false;
        while (video.hasNext()) {
            frame = video.next();
            if (!stitch.process(frame)) {
                throw new RuntimeException("You should handle failures");
            }
            StitchingFromMotion2D.Corners corners = stitch.getImageCorners(frame.width, frame.height, null);
            if (ExampleVideoMosaic.nearBorder(corners.p0, stitch) || ExampleVideoMosaic.nearBorder(corners.p1, stitch) || ExampleVideoMosaic.nearBorder(corners.p2, stitch) || ExampleVideoMosaic.nearBorder(corners.p3, stitch)) {
                stitch.setOriginToCurrent();
                if (!enlarged) {
                    enlarged = true;
                    int widthOld = stitch.getStitchedImage().width;
                    int heightOld = stitch.getStitchedImage().height;
                    int widthNew = widthOld * 2;
                    int heightNew = heightOld * 2;
                    int tranX = (widthNew - widthOld) / 2;
                    int tranY = (heightNew - heightOld) / 2;
                    Homography2D_F64 newToOldStitch = new Homography2D_F64(1.0, 0.0, (double)(-tranX), 0.0, 1.0, (double)(-tranY), 0.0, 0.0, 1.0);
                    stitch.resizeStitchImage(widthNew, heightNew, newToOldStitch);
                    gui.setImage(0, 1, new BufferedImage(widthNew, heightNew, 1));
                }
                corners = stitch.getImageCorners(frame.width, frame.height, null);
            }
            ConvertBufferedImage.convertTo(frame, gui.getImage(0, 0), true);
            ConvertBufferedImage.convertTo(stitch.getStitchedImage(), gui.getImage(0, 1), true);
            Graphics2D g2 = gui.getImage(0, 1).createGraphics();
            g2.setColor(Color.RED);
            g2.drawLine((int)corners.p0.x, (int)corners.p0.y, (int)corners.p1.x, (int)corners.p1.y);
            g2.drawLine((int)corners.p1.x, (int)corners.p1.y, (int)corners.p2.x, (int)corners.p2.y);
            g2.drawLine((int)corners.p2.x, (int)corners.p2.y, (int)corners.p3.x, (int)corners.p3.y);
            g2.drawLine((int)corners.p3.x, (int)corners.p3.y, (int)corners.p0.x, (int)corners.p0.y);
            gui.repaint();
            BoofMiscOps.pause(50L);
        }
    }

    private static boolean nearBorder(Point2D_F64 p, StitchingFromMotion2D<?, ?> stitch) {
        int r = 10;
        if (p.x < (double)r || p.y < (double)r) {
            return true;
        }
        if (p.x >= (double)(((ImageBase)stitch.getStitchedImage()).width - r)) {
            return true;
        }
        return p.y >= (double)(((ImageBase)stitch.getStitchedImage()).height - r);
    }
}

