/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.geometry;

import boofcv.alg.distort.RemovePerspectiveDistortion;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import georegression.struct.point.Point2D_F64;
import java.awt.image.BufferedImage;

public class ExampleRemovePerspectiveDistortion {
    public static void main(String[] args) {
        BufferedImage buffered = UtilImageIO.loadImage(UtilIO.pathExample("goals_and_stuff.jpg"));
        Planar<GrayF32> input = ConvertBufferedImage.convertFromMulti(buffered, null, true, GrayF32.class);
        RemovePerspectiveDistortion<Planar<GrayF32>> removePerspective = new RemovePerspectiveDistortion<Planar<GrayF32>>(400, 500, ImageType.pl(3, GrayF32.class));
        if (!removePerspective.apply(input, new Point2D_F64(267.0, 182.0), new Point2D_F64(542.0, 68.0), new Point2D_F64(519.0, 736.0), new Point2D_F64(276.0, 570.0))) {
            throw new RuntimeException("Failed!?!?");
        }
        Planar<GrayF32> output = removePerspective.getOutput();
        BufferedImage flat = ConvertBufferedImage.convertTo_F32(output, null, true);
        ShowImages.showWindow(buffered, "Original Image", true);
        ShowImages.showWindow(flat, "Without Perspective Distortion", true);
    }
}

