/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.geometry;

import boofcv.alg.interpolate.TypeInterpolate;
import boofcv.alg.sfm.overhead.CreateSyntheticOverheadViewPL;
import boofcv.alg.sfm.overhead.SelectOverheadParameters;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.calib.StereoParameters;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.Planar;
import georegression.struct.se.Se3_F64;
import java.awt.image.BufferedImage;

public class ExampleOverheadView {
    public static void main(String[] args) {
        BufferedImage input = UtilImageIO.loadImage(UtilIO.pathExample("road/left01.png"));
        Planar<GrayU8> imageRGB = ConvertBufferedImage.convertFromMulti(input, null, true, GrayU8.class);
        StereoParameters stereoParam = (StereoParameters)UtilIO.loadXML(UtilIO.pathExample("road/stereo01.xml"));
        Se3_F64 groundToLeft = (Se3_F64)UtilIO.loadXML(UtilIO.pathExample("road/ground_to_left_01.xml"));
        CreateSyntheticOverheadViewPL<GrayU8> generateOverhead = new CreateSyntheticOverheadViewPL<GrayU8>(TypeInterpolate.BILINEAR, 3, GrayU8.class);
        double cellSize = 0.05;
        SelectOverheadParameters selectMapSize = new SelectOverheadParameters(cellSize, 20.0, 0.5);
        selectMapSize.process(stereoParam.left, groundToLeft);
        int overheadWidth = selectMapSize.getOverheadWidth();
        int overheadHeight = selectMapSize.getOverheadHeight();
        Planar<GrayU8> overheadRGB = new Planar<GrayU8>(GrayU8.class, overheadWidth, overheadHeight, 3);
        generateOverhead.configure(stereoParam.left, groundToLeft, selectMapSize.getCenterX(), selectMapSize.getCenterY(), cellSize, overheadRGB.width, overheadRGB.height);
        generateOverhead.process((GrayU8)((Object)imageRGB), (GrayU8)((Object)overheadRGB));
        BufferedImage output = ConvertBufferedImage.convertTo(overheadRGB, null, true);
        ShowImages.showWindow(input, "Input Image", true);
        ShowImages.showWindow(output, "Overhead Image", true);
    }
}

