/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.fiducial;

import boofcv.abst.fiducial.CalibrationFiducialDetector;
import boofcv.abst.fiducial.calib.ConfigChessboard;
import boofcv.factory.fiducial.FactoryFiducial;
import boofcv.gui.MousePauseHelper;
import boofcv.gui.d3.PointCloudViewer;
import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.SimpleImageSequence;
import boofcv.io.wrapper.DefaultMediaManager;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.ejml.data.DenseMatrix64F;

public class ExamplePoseOfCalibrationTarget {
    public static void main(String[] args) {
        IntrinsicParameters intrinsic = (IntrinsicParameters)UtilIO.loadXML(UtilIO.pathExample("calibration/mono/Sony_DSC-HX5V_Chess/intrinsic.xml"));
        String fileName = UtilIO.pathExample("tracking/chessboard_SonyDSC_01.mjpeg");
        SimpleImageSequence<GrayF32> video = DefaultMediaManager.INSTANCE.openVideo(fileName, ImageType.single(GrayF32.class));
        CalibrationFiducialDetector<GrayF32> detector = FactoryFiducial.calibChessboard(new ConfigChessboard(4, 5, 0.03), GrayF32.class);
        detector.setIntrinsic(intrinsic);
        List<Point2D_F64> calibPts = detector.getCalibrationPoints();
        JPanel gui = new JPanel();
        PointCloudViewer viewer = new PointCloudViewer(intrinsic, 0.01);
        DenseMatrix64F rotY = ConvertRotation3D_F64.rotY((double)-1.5707963267948966, null);
        viewer.setWorldToCamera(new Se3_F64(rotY, new Vector3D_F64(0.75, 0.0, 1.25)));
        ImagePanel imagePanel = new ImagePanel(intrinsic.width, intrinsic.height);
        gui.add("West", imagePanel);
        gui.add("Center", viewer);
        ShowImages.showWindow(gui, "Calibration Target Pose", true);
        MousePauseHelper pauseHelper = new MousePauseHelper(gui);
        ArrayList<Point3D_F64> path = new ArrayList<Point3D_F64>();
        Se3_F64 targetToCamera = new Se3_F64();
        while (video.hasNext()) {
            detector.detect((GrayF32)((ImageGray)video.next()));
            if (detector.totalFound() == 1) {
                detector.getFiducialToCamera(0, targetToCamera);
                viewer.reset();
                Point3D_F64 center = new Point3D_F64();
                SePointOps_F64.transform((Se3_F64)targetToCamera, (Point3D_F64)center, (Point3D_F64)center);
                path.add(center);
                for (Point3D_F64 p : path) {
                    viewer.addPoint(p.x, p.y, p.z, 65280);
                }
                for (int j = 0; j < calibPts.size(); ++j) {
                    Point3D_F64 p;
                    p = calibPts.get(j);
                    Point3D_F64 p3 = new Point3D_F64(p.x, p.y, 0.0);
                    SePointOps_F64.transform((Se3_F64)targetToCamera, (Point3D_F64)p3, (Point3D_F64)p3);
                    viewer.addPoint(p3.x, p3.y, p3.z, 0);
                }
            }
            imagePanel.setBufferedImage((BufferedImage)video.getGuiImage());
            viewer.repaint();
            imagePanel.repaint();
            BoofMiscOps.pause(30L);
            while (pauseHelper.isPaused()) {
                BoofMiscOps.pause(30L);
            }
        }
    }
}

