/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.features;

import boofcv.alg.feature.detect.template.TemplateMatching;
import boofcv.alg.feature.detect.template.TemplateMatchingIntensity;
import boofcv.alg.misc.ImageStatistics;
import boofcv.alg.misc.PixelMath;
import boofcv.factory.feature.detect.template.FactoryTemplateMatching;
import boofcv.factory.feature.detect.template.TemplateScoreType;
import boofcv.gui.image.ShowImages;
import boofcv.gui.image.VisualizeImageData;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.feature.Match;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.List;

public class ExampleTemplateMatching {
    private static List<Match> findMatches(GrayF32 image, GrayF32 template, GrayF32 mask, int expectedMatches) {
        TemplateMatching<GrayF32> matcher = FactoryTemplateMatching.createMatcher(TemplateScoreType.SUM_DIFF_SQ, GrayF32.class);
        matcher.setTemplate(template, mask, expectedMatches);
        matcher.process(image);
        return matcher.getResults().toList();
    }

    public static void showMatchIntensity(GrayF32 image, GrayF32 template, GrayF32 mask) {
        TemplateMatchingIntensity<GrayF32> matchIntensity = FactoryTemplateMatching.createIntensity(TemplateScoreType.SUM_DIFF_SQ, GrayF32.class);
        matchIntensity.process(image, template, mask);
        GrayF32 intensity = matchIntensity.getIntensity();
        float min = ImageStatistics.min(intensity);
        float max = ImageStatistics.max(intensity);
        float range = max - min;
        PixelMath.plus(intensity, -min, intensity);
        PixelMath.divide(intensity, range, intensity);
        PixelMath.multiply(intensity, 255.0f, intensity);
        BufferedImage output = new BufferedImage(image.width, image.height, 4);
        VisualizeImageData.grayMagnitude((ImageGray)intensity, output, -1.0);
        ShowImages.showWindow(output, "Match Intensity", true);
    }

    public static void main(String[] args) {
        String directory = UtilIO.pathExample("template");
        GrayF32 image = UtilImageIO.loadImage(directory, "desktop.png", GrayF32.class);
        GrayF32 templateCursor = UtilImageIO.loadImage(directory, "cursor.png", GrayF32.class);
        GrayF32 maskCursor = UtilImageIO.loadImage(directory, "cursor_mask.png", GrayF32.class);
        GrayF32 templatePaint = UtilImageIO.loadImage(directory, "paint.png", GrayF32.class);
        BufferedImage output = new BufferedImage(image.width, image.height, 4);
        ConvertBufferedImage.convertTo(image, output);
        Graphics2D g2 = output.createGraphics();
        g2.setColor(Color.RED);
        g2.setStroke(new BasicStroke(5.0f));
        ExampleTemplateMatching.drawRectangles(g2, image, templateCursor, maskCursor, 3);
        ExampleTemplateMatching.showMatchIntensity(image, templateCursor, maskCursor);
        g2.setColor(Color.BLUE);
        g2.setStroke(new BasicStroke(2.0f));
        ExampleTemplateMatching.drawRectangles(g2, image, templateCursor, null, 3);
        g2.setColor(Color.ORANGE);
        g2.setStroke(new BasicStroke(3.0f));
        ExampleTemplateMatching.drawRectangles(g2, image, templatePaint, null, 1);
        ShowImages.showWindow(output, "Found Matches", true);
    }

    private static void drawRectangles(Graphics2D g2, GrayF32 image, GrayF32 template, GrayF32 mask, int expectedMatches) {
        List<Match> found = ExampleTemplateMatching.findMatches(image, template, mask, expectedMatches);
        int r = 2;
        int w = template.width + 2 * r;
        int h = template.height + 2 * r;
        for (Match m : found) {
            int x0 = m.x - r;
            int y0 = m.y - r;
            int x1 = x0 + w;
            int y1 = y0 + h;
            g2.drawLine(x0, y0, x1, y0);
            g2.drawLine(x1, y0, x1, y1);
            g2.drawLine(x1, y1, x0, y1);
            g2.drawLine(x0, y1, x0, y0);
        }
    }
}

