/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.features;

import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.abst.feature.detect.extract.ConfigExtract;
import boofcv.abst.feature.detect.extract.NonMaxSuppression;
import boofcv.abst.feature.detect.interest.ConfigFastHessian;
import boofcv.abst.feature.orientation.OrientationIntegral;
import boofcv.alg.feature.describe.DescribePointSurfMod;
import boofcv.alg.feature.detect.interest.FastHessianFeatureDetector;
import boofcv.alg.transform.ii.GIntegralImageOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.factory.feature.describe.FactoryDescribePointAlgs;
import boofcv.factory.feature.detdesc.FactoryDetectDescribe;
import boofcv.factory.feature.detect.extract.FactoryFeatureExtractor;
import boofcv.factory.feature.orientation.FactoryOrientationAlgs;
import boofcv.io.UtilIO;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.feature.BrightFeature;
import boofcv.struct.feature.ScalePoint;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import java.util.ArrayList;
import java.util.List;

public class ExampleFeatureSurf {
    public static void easy(GrayF32 image) {
        DetectDescribePoint<GrayF32, BrightFeature> surf = FactoryDetectDescribe.surfStable(new ConfigFastHessian(0.0f, 2, 200, 2, 9, 4, 4), null, null, GrayF32.class);
        surf.detect(image);
        System.out.println("Found Features: " + surf.getNumberOfFeatures());
        System.out.println("First descriptor's first value: " + surf.getDescription((int)0).value[0]);
    }

    public static <II extends ImageGray> void harder(GrayF32 image) {
        Class integralType = GIntegralImageOps.getIntegralType(GrayF32.class);
        NonMaxSuppression extractor = FactoryFeatureExtractor.nonmax(new ConfigExtract(2, 0.0f, 5, true));
        FastHessianFeatureDetector detector = new FastHessianFeatureDetector(extractor, 200, 2, 9, 4, 4, 6);
        OrientationIntegral orientation = FactoryOrientationAlgs.sliding_ii(null, integralType);
        DescribePointSurfMod descriptor = FactoryDescribePointAlgs.surfStability(null, integralType);
        Object integral = GeneralizedImageOps.createSingleBand(integralType, image.width, image.height);
        GIntegralImageOps.transform(image, integral);
        detector.detect(integral);
        orientation.setImage(integral);
        descriptor.setImage(integral);
        List<ScalePoint> points = detector.getFoundPoints();
        ArrayList<BrightFeature> descriptions = new ArrayList<BrightFeature>();
        for (ScalePoint p : points) {
            orientation.setObjectRadius(p.scale * 2.0);
            double angle = orientation.compute(p.x, p.y);
            BrightFeature desc = descriptor.createDescription();
            descriptor.describe(p.x, p.y, angle, p.scale, desc);
            descriptions.add(desc);
        }
        System.out.println("Found Features: " + points.size());
        System.out.println("First descriptor's first value: " + ((BrightFeature)descriptions.get((int)0)).value[0]);
    }

    public static void main(String[] args) {
        GrayF32 image = UtilImageIO.loadImage(UtilIO.pathExample("particles01.jpg"), GrayF32.class);
        ExampleFeatureSurf.easy(image);
        ExampleFeatureSurf.harder(image);
        System.out.println("Done!");
    }
}

