/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.features;

import boofcv.abst.feature.associate.AssociateDescription;
import boofcv.abst.feature.associate.ScoreAssociation;
import boofcv.abst.feature.describe.ConfigBrief;
import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.abst.feature.detect.interest.ConfigFastHessian;
import boofcv.abst.feature.detect.interest.ConfigGeneralDetector;
import boofcv.abst.feature.detect.interest.InterestPointDetector;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.examples.features.ExampleAssociatePoints;
import boofcv.factory.feature.associate.FactoryAssociation;
import boofcv.factory.feature.describe.FactoryDescribeRegionPoint;
import boofcv.factory.feature.detdesc.FactoryDetectDescribe;
import boofcv.factory.feature.detect.interest.FactoryDetectPoint;
import boofcv.factory.feature.detect.interest.FactoryInterestPoint;
import boofcv.io.UtilIO;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.feature.TupleDesc_B;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import java.awt.image.BufferedImage;

public class ExampleDetectDescribe {
    public static <T extends ImageGray, TD extends TupleDesc> DetectDescribePoint<T, TD> createFromPremade(Class<T> imageType) {
        return FactoryDetectDescribe.surfStable(new ConfigFastHessian(1.0f, 2, 200, 1, 9, 4, 4), null, null, imageType);
    }

    public static <T extends ImageGray, TD extends TupleDesc> DetectDescribePoint<T, TD> createFromComponents(Class<T> imageType) {
        Class derivType = GImageDerivativeOps.getDerivativeType(imageType);
        GeneralFeatureDetector corner = FactoryDetectPoint.createShiTomasi(new ConfigGeneralDetector(1000, 5, 1.0f), false, derivType);
        InterestPointDetector detector = FactoryInterestPoint.wrapPoint(corner, 1.0, imageType, derivType);
        DescribeRegionPoint<T, TupleDesc_B> describe = FactoryDescribeRegionPoint.brief(new ConfigBrief(true), imageType);
        return FactoryDetectDescribe.fuseTogether(detector, null, describe);
    }

    public static void main(String[] args) {
        Class<GrayF32> imageType = GrayF32.class;
        DetectDescribePoint detDesc = ExampleDetectDescribe.createFromPremade(imageType);
        ScoreAssociation scorer = FactoryAssociation.defaultScore(detDesc.getDescriptionType());
        AssociateDescription associate = FactoryAssociation.greedy(scorer, Double.MAX_VALUE, true);
        ExampleAssociatePoints app = new ExampleAssociatePoints(detDesc, associate, imageType);
        BufferedImage imageA = UtilImageIO.loadImage(UtilIO.pathExample("stitch/kayak_01.jpg"));
        BufferedImage imageB = UtilImageIO.loadImage(UtilIO.pathExample("stitch/kayak_03.jpg"));
        app.associate(imageA, imageB);
    }
}

