/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.calibration;

import boofcv.abst.fiducial.calib.ConfigChessboard;
import boofcv.abst.fiducial.calib.ConfigSquareGrid;
import boofcv.abst.geo.calibration.CalibrateMonoPlanar;
import boofcv.abst.geo.calibration.CalibrationDetector;
import boofcv.factory.calib.FactoryCalibrationTarget;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.image.GrayF32;
import java.awt.image.BufferedImage;
import java.util.List;

public class ExampleCalibrateMonocular {
    CalibrationDetector detector;
    List<String> images;

    private void setupZhang99() {
        this.detector = FactoryCalibrationTarget.detectorSquareGrid(new ConfigSquareGrid(8, 8, 0.5, 0.3888888888888889));
        String directory = UtilIO.pathExample("calibration/mono/PULNiX_CCD_6mm_Zhang");
        this.images = BoofMiscOps.directoryList(directory, "CalibIm");
    }

    private void setupBumbleBee() {
        this.detector = FactoryCalibrationTarget.detectorChessboard(new ConfigChessboard(7, 5, 30.0));
        String directory = UtilIO.pathExample("calibration/stereo/Bumblebee2_Chess");
        this.images = BoofMiscOps.directoryList(directory, "left");
    }

    public void process() {
        CalibrateMonoPlanar calibrationAlg = new CalibrateMonoPlanar(this.detector);
        calibrationAlg.configure(true, 2, false);
        for (String n : this.images) {
            GrayF32 image;
            BufferedImage input = UtilImageIO.loadImage(n);
            if (n == null || calibrationAlg.addImage(image = ConvertBufferedImage.convertFrom(input, (GrayF32)null))) continue;
            System.err.println("Failed to detect target in " + n);
        }
        IntrinsicParameters intrinsic = calibrationAlg.process();
        UtilIO.saveXML(intrinsic, "intrinsic.xml");
        calibrationAlg.printStatistics();
        System.out.println();
        System.out.println("--- Intrinsic Parameters ---");
        System.out.println();
        intrinsic.print();
    }

    public static void main(String[] args) {
        ExampleCalibrateMonocular alg = new ExampleCalibrateMonocular();
        alg.setupBumbleBee();
        alg.process();
    }
}

