/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.transform.pyramid;

import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.transform.pyramid.PyramidFloatScale;
import boofcv.core.image.border.BorderType;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.gui.SelectInputPanel;
import boofcv.gui.image.ImagePyramidPanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.PathLabel;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class VisualizePyramidFloatApp<T extends ImageGray>
extends SelectInputPanel {
    double[] scales = new double[]{1.0, 1.2, 2.4, 3.6, 4.8, 6.0, 12.0, 20.0};
    Class<T> imageType;
    InterpolatePixelS<T> interp;
    ImagePyramidPanel<T> gui = new ImagePyramidPanel();
    boolean processedImage = false;

    public VisualizePyramidFloatApp(Class<T> imageType) {
        this.imageType = imageType;
        this.interp = FactoryInterpolation.bilinearPixelS(imageType, BorderType.EXTENDED);
        this.setMainGUI(this.gui);
    }

    public void process(BufferedImage input) {
        this.setInputImage(input);
        final ImageGray gray = ConvertBufferedImage.convertFromSingle(input, null, this.imageType);
        PyramidFloatScale<ImageGray> pyramid = new PyramidFloatScale<ImageGray>(this.interp, this.scales, this.imageType);
        pyramid.process(gray);
        this.gui.set(pyramid, true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VisualizePyramidFloatApp.this.gui.render();
                VisualizePyramidFloatApp.this.gui.repaint();
                VisualizePyramidFloatApp.this.setPreferredSize(new Dimension(gray.width + 50, gray.height + 20));
                VisualizePyramidFloatApp.this.processedImage = true;
            }
        });
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public synchronized void changeInput(String name, int index) {
        BufferedImage image = this.media.openImage(((PathLabel)this.inputRefs.get(index)).getPath());
        if (image != null) {
            this.process(image);
        }
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.processedImage;
    }

    public static void main(String[] args) {
        VisualizePyramidFloatApp<GrayU8> app = new VisualizePyramidFloatApp<GrayU8>(GrayU8.class);
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("boat", UtilIO.pathExample("standard/boat.jpg")));
        inputs.add(new PathLabel("shapes", UtilIO.pathExample("shapes/shapes01.png")));
        inputs.add(new PathLabel("sunflowers", UtilIO.pathExample("sunflowers.jpg")));
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Image Float Pyramid", true);
    }
}

