/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.tracker;

import boofcv.abst.feature.detect.interest.ConfigFastHessian;
import boofcv.abst.feature.detect.interest.ConfigGeneralDetector;
import boofcv.abst.feature.tracker.PointTrack;
import boofcv.abst.feature.tracker.PointTracker;
import boofcv.alg.tracker.klt.PkltConfig;
import boofcv.factory.feature.tracker.FactoryPointTracker;
import boofcv.gui.VideoProcessAppBase;
import boofcv.gui.feature.VisualizeFeatures;
import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.PathLabel;
import boofcv.io.UtilIO;
import boofcv.io.image.SimpleImageSequence;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class VideoTrackerPointFeaturesApp<I extends ImageGray, D extends ImageGray>
extends VideoProcessAppBase<I>
implements MouseListener {
    int maxFeatures = 400;
    int minFeatures = 150;
    PointTracker<I> tracker;
    ImagePanel gui = new ImagePanel();
    BufferedImage workImage;

    public VideoTrackerPointFeaturesApp(Class<I> imageType, Class<D> derivType) {
        super(1, imageType);
        PkltConfig config = new PkltConfig();
        config.templateRadius = 3;
        config.pyramidScaling = new int[]{1, 2, 4, 8};
        ConfigFastHessian configFH = new ConfigFastHessian();
        configFH.maxFeaturesPerScale = 200;
        configFH.extractRadius = 4;
        configFH.detectThreshold = 15.0f;
        this.addAlgorithm(0, "KLT", FactoryPointTracker.klt(config, new ConfigGeneralDetector(this.maxFeatures, 1, 3.0f), imageType, derivType));
        this.addAlgorithm(0, "ST-BRIEF", FactoryPointTracker.dda_ST_BRIEF(200, new ConfigGeneralDetector(this.maxFeatures, 3, 1.0f), imageType, derivType));
        this.addAlgorithm(0, "ST-NCC", FactoryPointTracker.dda_ST_NCC(new ConfigGeneralDetector(this.maxFeatures, 3, 2.0f), 5, imageType, derivType));
        this.addAlgorithm(0, "FH-SURF", FactoryPointTracker.dda_FH_SURF_Fast(configFH, null, null, imageType));
        this.addAlgorithm(0, "ST-SURF-KLT", FactoryPointTracker.combined_ST_SURF_KLT(new ConfigGeneralDetector(this.maxFeatures, 3, 1.0f), config, 50, null, null, imageType, derivType));
        this.addAlgorithm(0, "FH-SURF-KLT", FactoryPointTracker.combined_FH_SURF_KLT(config, 50, configFH, null, null, imageType));
        this.gui.addMouseListener(this);
        this.gui.requestFocus();
        this.setMainGUI(this.gui);
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public void process(SimpleImageSequence<I> sequence) {
        this.stopWorker();
        this.sequence = sequence;
        sequence.setLoop(true);
        this.doRefreshAll();
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.workImage != null;
    }

    @Override
    public void refreshAll(Object[] cookies) {
        this.setActiveAlgorithm(0, null, cookies[0]);
    }

    @Override
    public void setActiveAlgorithm(int indexFamily, String name, Object cookie) {
        if (this.sequence == null) {
            return;
        }
        this.stopWorker();
        this.tracker = (PointTracker)cookie;
        this.sequence.reset();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImageGray image = (ImageGray)VideoTrackerPointFeaturesApp.this.sequence.next();
                VideoTrackerPointFeaturesApp.this.gui.setPreferredSize(new Dimension(image.width, image.height));
                VideoTrackerPointFeaturesApp.this.workImage = new BufferedImage(image.width, image.height, 4);
                VideoTrackerPointFeaturesApp.this.gui.setBufferedImage(VideoTrackerPointFeaturesApp.this.workImage);
                VideoTrackerPointFeaturesApp.this.revalidate();
                VideoTrackerPointFeaturesApp.this.startWorkerThread();
            }
        });
    }

    void renderFeatures(BufferedImage orig, double trackerFPS) {
        int y;
        int x;
        Graphics2D g2 = this.workImage.createGraphics();
        g2.drawImage(orig, 0, 0, orig.getWidth(), orig.getHeight(), null);
        for (PointTrack p : this.tracker.getActiveTracks(null)) {
            x = (int)p.x;
            y = (int)p.y;
            VisualizeFeatures.drawPoint(g2, x, y, Color.blue);
        }
        for (PointTrack p : this.tracker.getNewTracks(null)) {
            x = (int)p.x;
            y = (int)p.y;
            VisualizeFeatures.drawPoint(g2, x, y, Color.green);
        }
        g2.setColor(Color.WHITE);
        g2.fillRect(5, 15, 140, 20);
        g2.setColor(Color.BLACK);
        g2.drawString(String.format("Tracker FPS: %3.1f", trackerFPS), 10, 30);
    }

    @Override
    protected void updateAlg(I frame, BufferedImage buffImage) {
        this.tracker.process(frame);
        if (this.tracker.getActiveTracks(null).size() < this.minFeatures) {
            this.tracker.spawnTracks();
        }
    }

    @Override
    protected void handleRunningStatus(int status) {
    }

    @Override
    protected void updateAlgGUI(ImageGray frame, BufferedImage imageGUI, double fps) {
        this.renderFeatures((BufferedImage)this.sequence.getGuiImage(), fps);
    }

    public static void main(String[] args) {
        Class<GrayF32> imageType = GrayF32.class;
        Class<GrayF32> derivType = GrayF32.class;
        VideoTrackerPointFeaturesApp<GrayF32, GrayF32> app = new VideoTrackerPointFeaturesApp<GrayF32, GrayF32>(imageType, derivType);
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("Shake", UtilIO.pathExample("shake.mjpeg")));
        inputs.add(new PathLabel("Zoom", UtilIO.pathExample("zoom.mjpeg")));
        inputs.add(new PathLabel("Rotate", UtilIO.pathExample("rotate.mjpeg")));
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Feature Tracker", true);
    }
}

