/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.tracker;

import boofcv.abst.tracker.ConfigCirculantTracker;
import boofcv.abst.tracker.ConfigComaniciu2003;
import boofcv.abst.tracker.ConfigTld;
import boofcv.abst.tracker.MeanShiftLikelihoodType;
import boofcv.abst.tracker.TrackerObjectQuad;
import boofcv.core.image.GConvertImage;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.demonstrations.tracker.TrackerQuadInfoPanel;
import boofcv.factory.tracker.FactoryTrackerObjectQuad;
import boofcv.gui.VideoProcessAppBase;
import boofcv.gui.image.ShowImages;
import boofcv.gui.tracker.TrackerObjectQuadPanel;
import boofcv.io.PathLabel;
import boofcv.io.UtilIO;
import boofcv.io.image.SimpleImageSequence;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import georegression.struct.shapes.Quadrilateral_F64;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;

public class VideoTrackerObjectQuadApp<I extends ImageGray>
extends VideoProcessAppBase<Planar<I>>
implements TrackerObjectQuadPanel.Listener,
TrackerQuadInfoPanel.Listener {
    Class<I> imageClass;
    TrackerObjectQuad tracker;
    TrackerObjectQuadPanel videoPanel;
    TrackerQuadInfoPanel infoBar;
    int whichAlg;
    I gray;
    Quadrilateral_F64 target = new Quadrilateral_F64();
    Quadrilateral_F64 targetDefault = new Quadrilateral_F64();
    boolean targetSelected = false;
    boolean selectionChanged = false;
    boolean success;
    boolean processedInputImage = false;
    boolean firstFrame = true;

    public VideoTrackerObjectQuadApp(Class<I> imageType) {
        super(1, ImageType.pl(3, imageType));
        this.imageClass = imageType;
        this.gray = GeneralizedImageOps.createSingleBand(imageType, 1, 1);
        this.addAlgorithm(0, "Circulant", 0);
        this.addAlgorithm(0, "TLD", 1);
        this.addAlgorithm(0, "Mean-Shift Region Fixed", 2);
        this.addAlgorithm(0, "Mean-Shift Region Scale", 3);
        this.addAlgorithm(0, "Mean-Shift Pixel", 4);
        this.addAlgorithm(0, "Sparse Flow Tracker", 5);
        this.videoPanel = new TrackerObjectQuadPanel(this);
        this.infoBar = new TrackerQuadInfoPanel(this);
        this.add((Component)this.infoBar, "West");
        this.add((Component)this.videoPanel, "Center");
        this.setMainGUI(this.videoPanel);
    }

    @Override
    public void process(SimpleImageSequence<Planar<I>> sequence) {
        this.stopWorker();
        this.sequence = sequence;
        sequence.setLoop(false);
        this.setPause(false);
        if (!sequence.hasNext()) {
            throw new IllegalArgumentException("Empty sequence");
        }
        this.doRefreshAll();
    }

    @Override
    public void refreshAll(Object[] cookies) {
        if (this.whichAlg == 0) {
            this.tracker = FactoryTrackerObjectQuad.circulant(new ConfigCirculantTracker(), this.imageClass);
        } else if (this.whichAlg == 1) {
            this.tracker = FactoryTrackerObjectQuad.tld(new ConfigTld(false), this.imageClass);
        } else if (this.whichAlg == 2) {
            ConfigComaniciu2003 config = new ConfigComaniciu2003();
            config.scaleChange = 0.0f;
            this.tracker = FactoryTrackerObjectQuad.meanShiftComaniciu2003(config, this.imageType);
        } else if (this.whichAlg == 3) {
            ConfigComaniciu2003 config = new ConfigComaniciu2003();
            config.scaleChange = 0.05f;
            this.tracker = FactoryTrackerObjectQuad.meanShiftComaniciu2003(config, this.imageType);
        } else if (this.whichAlg == 4) {
            this.tracker = FactoryTrackerObjectQuad.meanShiftLikelihood(30, 5, 256.0, MeanShiftLikelihoodType.HISTOGRAM, this.imageType);
        } else if (this.whichAlg == 5) {
            this.tracker = FactoryTrackerObjectQuad.sparseFlow(null, this.imageClass, null);
        } else {
            throw new RuntimeException("Unknown algorithm");
        }
        this.videoPanel.setDefaultTarget(this.targetDefault);
        this.firstFrame = true;
        this.targetSelected = true;
        this.selectionChanged = true;
        this.target.set(this.targetDefault);
        this.setPause(false);
        this.startWorkerThread();
    }

    @Override
    public void setActiveAlgorithm(int indexFamily, String name, Object cookie) {
        this.stopWorker();
        this.whichAlg = (Integer)cookie;
        this.sequence.reset();
        this.refreshAll(null);
    }

    @Override
    protected void updateAlg(Planar<I> frame, BufferedImage buffImage) {
        boolean grayScale = false;
        if (this.tracker.getImageType().getFamily() == ImageType.Family.GRAY) {
            ((ImageGray)this.gray).reshape(frame.width, frame.height);
            GConvertImage.average(frame, this.gray);
            grayScale = true;
        }
        if (this.targetSelected) {
            if (this.selectionChanged) {
                this.selectionChanged = false;
                this.success = grayScale ? this.tracker.initialize(this.gray, this.target) : this.tracker.initialize(frame, this.target);
            } else {
                this.success = grayScale ? this.tracker.process(this.gray, this.target) : this.tracker.process(frame, this.target);
            }
        }
        this.processedInputImage = true;
    }

    @Override
    protected void updateAlgGUI(Planar<I> frame, BufferedImage imageGUI, double fps) {
        if (this.firstFrame) {
            this.videoPanel.setPreferredSize(new Dimension(imageGUI.getWidth(), imageGUI.getHeight()));
            this.videoPanel.setBackGround((BufferedImage)this.sequence.getGuiImage());
            this.infoBar.setFPS(0.0);
            this.infoBar.setTracking("");
            this.firstFrame = false;
            this.setPause(true);
        } else {
            this.videoPanel.setBackGround((BufferedImage)this.sequence.getGuiImage());
            this.videoPanel.setTarget(this.target, this.success);
            this.infoBar.setFPS(fps);
            if (this.success) {
                this.infoBar.setTracking("FOUND");
            } else {
                this.infoBar.setTracking("?");
            }
            this.videoPanel.repaint();
        }
    }

    @Override
    public void selectedTarget(Quadrilateral_F64 target) {
        System.out.println(target.a.x + " " + target.a.y + " " + target.b.x + " " + target.b.y + " " + target.c.x + " " + target.c.y + " " + target.d.x + " " + target.d.y);
        this.target.set(target);
        this.targetSelected = true;
        this.selectionChanged = true;
        this.setPause(false);
    }

    @Override
    public void togglePause() {
        this.setPause(!this.isPaused);
    }

    @Override
    public void selectTarget() {
        this.setPause(true);
        this.infoBar.setTracking("");
        this.targetSelected = false;
        this.videoPanel.enterSelectMode();
    }

    @Override
    public void resetVideo() {
        this.stopWorker();
        this.sequence.reset();
        this.refreshAll(null);
    }

    @Override
    public void changeInput(String name, int index) {
        this.processedInputImage = false;
        String videoName = ((PathLabel)this.inputRefs.get(index)).getPath();
        String path = videoName.substring(0, videoName.lastIndexOf(46));
        this.parseQuad(path + "_rect.txt");
        SimpleImageSequence<Planar<I>> video = this.media.openVideo(videoName, ImageType.pl(3, this.imageClass));
        this.process(video);
    }

    private void parseQuad(String fileName) {
        Reader r = this.media.openFile(fileName);
        BufferedReader in = new BufferedReader(r);
        try {
            String[] w = in.readLine().split(" ");
            if (w.length != 8) {
                throw new RuntimeException("Unexpected number of variables in rectangle: " + w.length);
            }
            this.targetDefault.a.x = Double.parseDouble(w[0]);
            this.targetDefault.a.y = Double.parseDouble(w[1]);
            this.targetDefault.b.x = Double.parseDouble(w[2]);
            this.targetDefault.b.y = Double.parseDouble(w[3]);
            this.targetDefault.c.x = Double.parseDouble(w[4]);
            this.targetDefault.c.y = Double.parseDouble(w[5]);
            this.targetDefault.d.x = Double.parseDouble(w[6]);
            this.targetDefault.d.y = Double.parseDouble(w[7]);
            in.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void handleRunningStatus(int status) {
        if (status == 0) {
            this.infoBar.setPlay(false);
        } else if (status == 1) {
            this.infoBar.setPlay(true);
        }
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.processedInputImage;
    }

    public static void main(String[] args) {
        Class<GrayU8> type = GrayU8.class;
        VideoTrackerObjectQuadApp<GrayU8> app = new VideoTrackerObjectQuadApp<GrayU8>(type);
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("WildCat", UtilIO.pathExample("tracking/wildcat_robot.mjpeg")));
        inputs.add(new PathLabel("Tree", UtilIO.pathExample("tracking/tree.mjpeg")));
        inputs.add(new PathLabel("Book", UtilIO.pathExample("tracking/track_book.mjpeg")));
        inputs.add(new PathLabel("Face", UtilIO.pathExample("tracking/track_peter.mjpeg")));
        inputs.add(new PathLabel("Chipmunk", UtilIO.pathExample("tracking/chipmunk.mjpeg")));
        inputs.add(new PathLabel("Balls", UtilIO.pathExample("tracking/balls_blue_red.mjpeg")));
        inputs.add(new PathLabel("Driving Snow", UtilIO.pathExample("tracking/snow_follow_car.mjpeg")));
        inputs.add(new PathLabel("Driving Night", UtilIO.pathExample("tracking/night_follow_car.mjpeg")));
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Tracking Rectangle", true);
    }
}

