/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.shapes;

import boofcv.demonstrations.shapes.ShapeFitContourApp;
import boofcv.demonstrations.shapes.ThresholdControlPanel;
import boofcv.gui.StandardAlgConfigPanel;
import boofcv.struct.image.GrayU8;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ShapeFitContourPanel
extends StandardAlgConfigPanel
implements ActionListener,
ChangeListener {
    ShapeFitContourApp owner;
    JComboBox algorithmCombo;
    JComboBox imageView;
    JSpinner selectZoom;
    ThresholdControlPanel threshold;
    JSpinner selectMinimumSideFraction;
    JSpinner selectSplitFraction;
    JCheckBox showCorners;
    JCheckBox showContour;
    int selectedAlgorithm = 0;
    int selectedView = 0;
    double zoom = 1.0;
    double minimumSplitFraction = 0.01;
    double splitFraction = 0.05;
    boolean cornersVisible = false;
    boolean contoursVisible = true;

    public ShapeFitContourPanel(ShapeFitContourApp owner) {
        this.owner = owner;
        this.algorithmCombo = new JComboBox();
        this.algorithmCombo.addItem("Polygon");
        this.algorithmCombo.addItem("Oval");
        this.algorithmCombo.addActionListener(this);
        this.algorithmCombo.setMaximumSize(this.algorithmCombo.getPreferredSize());
        this.imageView = new JComboBox();
        this.imageView.addItem("Input");
        this.imageView.addItem("Binary");
        this.imageView.addItem("Black");
        this.imageView.addActionListener(this);
        this.imageView.setMaximumSize(this.imageView.getPreferredSize());
        this.selectZoom = new JSpinner(new SpinnerNumberModel(1.0, 0.1, 50.0, 1.0));
        this.selectZoom.addChangeListener(this);
        this.selectZoom.setMaximumSize(this.selectZoom.getPreferredSize());
        this.threshold = new ThresholdControlPanel(owner);
        this.selectMinimumSideFraction = new JSpinner(new SpinnerNumberModel(this.minimumSplitFraction, 0.0, 0.999, 0.0025));
        this.selectMinimumSideFraction.setEditor(new JSpinner.NumberEditor(this.selectMinimumSideFraction, "#,####0.0000;(#,####0.0000)"));
        this.selectMinimumSideFraction.addChangeListener(this);
        this.selectMinimumSideFraction.setMaximumSize(this.selectMinimumSideFraction.getPreferredSize());
        this.selectSplitFraction = new JSpinner(new SpinnerNumberModel(this.splitFraction, 0.0, 1.0, 0.01));
        this.selectSplitFraction.setEditor(new JSpinner.NumberEditor(this.selectSplitFraction, "#,##0.00;(#,##0.00)"));
        this.showCorners = new JCheckBox("Show Corners");
        this.showCorners.setSelected(this.cornersVisible);
        this.showCorners.addChangeListener(this);
        this.showContour = new JCheckBox("Show Contours");
        this.showContour.setSelected(this.contoursVisible);
        this.showContour.addChangeListener(this);
        this.selectSplitFraction.addChangeListener(this);
        this.selectSplitFraction.setMaximumSize(this.selectSplitFraction.getPreferredSize());
        this.addLabeled(this.algorithmCombo, "Type of Shape", this);
        this.addSeparator(200);
        this.addLabeled(this.imageView, "Background", this);
        this.addLabeled(this.selectZoom, "Zoom", this);
        this.addAlignCenter(this.threshold, this);
        this.addLabeled(this.selectMinimumSideFraction, "Min Side Fraction", this);
        this.addLabeled(this.selectSplitFraction, "Split Fraction", this);
        this.addAlignLeft(this.showCorners, this);
        this.addAlignLeft(this.showContour, this);
        this.addVerticalGlue(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.algorithmCombo) {
            this.selectedAlgorithm = this.algorithmCombo.getSelectedIndex();
            this.updateEnabledByAlgorithm();
        } else if (e.getSource() == this.imageView) {
            this.selectedView = this.imageView.getSelectedIndex();
            this.owner.viewUpdated();
            return;
        }
        this.owner.processImage((BufferedImage)null, (GrayU8)null);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.selectMinimumSideFraction) {
            this.minimumSplitFraction = (Double)this.selectMinimumSideFraction.getValue();
        } else if (e.getSource() == this.selectSplitFraction) {
            this.splitFraction = (Double)this.selectSplitFraction.getValue();
        } else {
            if (e.getSource() == this.selectZoom) {
                this.zoom = ((Number)this.selectZoom.getValue()).doubleValue();
                this.owner.viewUpdated();
                return;
            }
            if (e.getSource() == this.showContour) {
                this.contoursVisible = this.showContour.isSelected();
                this.owner.viewUpdated();
                return;
            }
            if (e.getSource() == this.showCorners) {
                this.cornersVisible = this.showCorners.isSelected();
                this.owner.viewUpdated();
                return;
            }
        }
        this.owner.processImage((BufferedImage)null, (GrayU8)null);
    }

    private void updateEnabledByAlgorithm() {
        if (this.selectedAlgorithm == 0) {
            this.showCorners.setEnabled(true);
            this.selectSplitFraction.setEnabled(true);
            this.selectMinimumSideFraction.setEnabled(true);
        } else {
            this.showCorners.setEnabled(false);
            this.selectSplitFraction.setEnabled(false);
            this.selectMinimumSideFraction.setEnabled(false);
        }
    }

    public int getSelectedAlgorithm() {
        return this.selectedAlgorithm;
    }

    public int getSelectedView() {
        return this.selectedView;
    }

    public double getZoom() {
        return this.zoom;
    }

    public double getMinimumSplitFraction() {
        return this.minimumSplitFraction;
    }

    public double getSplitFraction() {
        return this.splitFraction;
    }

    public boolean isCornersVisible() {
        return this.cornersVisible;
    }

    public ThresholdControlPanel getThreshold() {
        return this.threshold;
    }
}

