/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.shapes;

import boofcv.demonstrations.shapes.DetectBlackPolygonApp;
import boofcv.demonstrations.shapes.PolygonRefineType;
import boofcv.demonstrations.shapes.ThresholdControlPanel;
import boofcv.factory.shape.ConfigPolygonDetector;
import boofcv.factory.shape.ConfigRefinePolygonCornersToImage;
import boofcv.factory.shape.ConfigRefinePolygonLineToImage;
import boofcv.gui.StandardAlgConfigPanel;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DetectPolygonControlPanel
extends StandardAlgConfigPanel
implements ActionListener,
ChangeListener {
    DetectBlackPolygonApp owner;
    JComboBox imageView;
    JSpinner selectZoom;
    JCheckBox showCorners;
    JCheckBox showLines;
    JCheckBox showContour;
    JComboBox refineChoice;
    int selectedView = 0;
    boolean bShowCorners = true;
    boolean bShowLines = true;
    boolean bShowContour = false;
    ThresholdControlPanel threshold;
    JSpinner spinnerMinContourSize;
    JSpinner spinnerMinSides;
    JSpinner spinnerMaxSides;
    JSpinner spinnerMinEdge;
    JCheckBox setConvex;
    JCheckBox setBorder;
    JSpinner spinnerContourSplit;
    JSpinner spinnerContourMinSplit;
    JSpinner spinnerContourIterations;
    JSpinner spinnerSplitPenalty;
    JSpinner spinnerLineSamples;
    JSpinner spinnerCornerOffset;
    JSpinner spinnerSampleRadius;
    JSpinner spinnerRefineMaxIterations;
    JSpinner spinnerConvergeTol;
    JSpinner spinnerMaxCornerChange;
    ConfigPolygonDetector config = new ConfigPolygonDetector(3, 6);
    ConfigRefinePolygonLineToImage configLine = new ConfigRefinePolygonLineToImage();
    ConfigRefinePolygonCornersToImage configCorner = new ConfigRefinePolygonCornersToImage();
    PolygonRefineType refineType = PolygonRefineType.LINE;
    int minSides = 3;
    int maxSides = 6;
    double zoom = 1.0;

    public DetectPolygonControlPanel(DetectBlackPolygonApp owner) {
        this.owner = owner;
        this.imageView = new JComboBox();
        this.imageView.addItem("Input");
        this.imageView.addItem("Binary");
        this.imageView.addItem("Black");
        this.imageView.addActionListener(this);
        this.imageView.setMaximumSize(this.imageView.getPreferredSize());
        this.selectZoom = new JSpinner(new SpinnerNumberModel(1.0, 0.1, 50.0, 1.0));
        this.selectZoom.addChangeListener(this);
        this.selectZoom.setMaximumSize(this.selectZoom.getPreferredSize());
        this.showCorners = new JCheckBox("Corners");
        this.showCorners.addActionListener(this);
        this.showCorners.setSelected(this.bShowCorners);
        this.showLines = new JCheckBox("Lines");
        this.showLines.setSelected(this.bShowLines);
        this.showLines.addActionListener(this);
        this.showContour = new JCheckBox("Contour");
        this.showContour.addActionListener(this);
        this.showContour.setSelected(this.bShowContour);
        this.threshold = new ThresholdControlPanel(owner);
        this.refineChoice = new JComboBox();
        for (PolygonRefineType n : PolygonRefineType.values()) {
            this.refineChoice.addItem(n.name());
        }
        this.refineChoice.setSelectedIndex(this.refineType.ordinal());
        this.refineChoice.addActionListener(this);
        this.refineChoice.setMaximumSize(this.refineChoice.getPreferredSize());
        this.spinnerMinContourSize = new JSpinner(new SpinnerNumberModel(this.config.minContourImageWidthFraction, 0.0, 0.2, 0.01));
        this.configureSpinnerFloat(this.spinnerMinContourSize);
        this.spinnerMinSides = new JSpinner(new SpinnerNumberModel(this.minSides, 3, 20, 1));
        this.spinnerMinSides.setMaximumSize(this.spinnerMinSides.getPreferredSize());
        this.spinnerMinSides.addChangeListener(this);
        this.spinnerMaxSides = new JSpinner(new SpinnerNumberModel(this.maxSides, 3, 20, 1));
        this.spinnerMaxSides.setMaximumSize(this.spinnerMaxSides.getPreferredSize());
        this.spinnerMaxSides.addChangeListener(this);
        this.spinnerMinEdge = new JSpinner(new SpinnerNumberModel(this.config.minimumEdgeIntensity, 0.0, 255.0, 1.0));
        this.spinnerMinEdge.setMaximumSize(this.spinnerMinEdge.getPreferredSize());
        this.spinnerMinEdge.addChangeListener(this);
        this.spinnerContourSplit = new JSpinner(new SpinnerNumberModel(this.config.contour2Poly_splitFraction, 0.0, 1.0, 0.01));
        this.configureSpinnerFloat(this.spinnerContourSplit);
        this.spinnerContourMinSplit = new JSpinner(new SpinnerNumberModel(this.config.contour2Poly_minimumSideFraction, 0.0, 1.0, 0.001));
        this.configureSpinnerFloat(this.spinnerContourMinSplit);
        this.spinnerContourSplit.addChangeListener(this);
        this.spinnerContourIterations = new JSpinner(new SpinnerNumberModel(this.config.contour2Poly_iterations, 1, 200, 1));
        this.spinnerContourIterations.setMaximumSize(this.spinnerContourIterations.getPreferredSize());
        this.spinnerContourIterations.addChangeListener(this);
        this.spinnerSplitPenalty = new JSpinner(new SpinnerNumberModel(this.config.splitPenalty, 0.0, 100.0, 1.0));
        this.configureSpinnerFloat(this.spinnerSplitPenalty);
        this.setConvex = new JCheckBox("Convex");
        this.setConvex.addActionListener(this);
        this.setConvex.setSelected(this.config.convex);
        this.setBorder = new JCheckBox("Image Border");
        this.setBorder.addActionListener(this);
        this.setBorder.setSelected(this.config.canTouchBorder);
        this.spinnerLineSamples = new JSpinner(new SpinnerNumberModel(this.configLine.lineSamples, 5, 100, 1));
        this.spinnerLineSamples.setMaximumSize(this.spinnerLineSamples.getPreferredSize());
        this.spinnerLineSamples.addChangeListener(this);
        this.spinnerCornerOffset = new JSpinner(new SpinnerNumberModel(this.configLine.cornerOffset, 0.0, 10.0, 1.0));
        this.spinnerCornerOffset.setMaximumSize(this.spinnerCornerOffset.getPreferredSize());
        this.spinnerCornerOffset.addChangeListener(this);
        this.spinnerSampleRadius = new JSpinner(new SpinnerNumberModel(this.configLine.sampleRadius, 0, 10, 1));
        this.spinnerSampleRadius.setMaximumSize(this.spinnerCornerOffset.getPreferredSize());
        this.spinnerSampleRadius.addChangeListener(this);
        this.spinnerRefineMaxIterations = new JSpinner(new SpinnerNumberModel(this.configLine.maxIterations, 0, 200, 1));
        this.spinnerRefineMaxIterations.setMaximumSize(this.spinnerRefineMaxIterations.getPreferredSize());
        this.spinnerRefineMaxIterations.addChangeListener(this);
        this.spinnerConvergeTol = new JSpinner(new SpinnerNumberModel(this.configLine.convergeTolPixels, 0.0, 2.0, 0.005));
        this.configureSpinnerFloat(this.spinnerConvergeTol);
        this.spinnerMaxCornerChange = new JSpinner(new SpinnerNumberModel(this.configLine.maxCornerChangePixel, 0.0, 50.0, 1.0));
        this.configureSpinnerFloat(this.spinnerMaxCornerChange);
        this.addLabeled(this.imageView, "View: ", this);
        this.addLabeled(this.selectZoom, "Zoom", this);
        this.addAlignLeft(this.showCorners, this);
        this.addAlignLeft(this.showLines, this);
        this.addAlignLeft(this.showContour, this);
        this.add(this.threshold);
        this.addLabeled(this.spinnerMinContourSize, "Min Contour Size: ", this);
        this.addLabeled(this.spinnerMinSides, "Minimum Sides: ", this);
        this.addLabeled(this.spinnerMaxSides, "Maximum Sides: ", this);
        this.addLabeled(this.spinnerMinEdge, "Edge Intensity: ", this);
        this.addAlignLeft(this.setConvex, this);
        this.addAlignLeft(this.setBorder, this);
        this.addCenterLabel("Contour", this);
        this.addLabeled(this.spinnerContourSplit, "Split Fraction: ", this);
        this.addLabeled(this.spinnerContourMinSplit, "Min Split: ", this);
        this.addLabeled(this.spinnerContourIterations, "Max Iterations: ", this);
        this.addLabeled(this.spinnerSplitPenalty, "Split Penalty: ", this);
        this.addCenterLabel("Refinement", this);
        this.addLabeled(this.refineChoice, "Refine: ", this);
        this.addLabeled(this.spinnerLineSamples, "Line Samples: ", this);
        this.addLabeled(this.spinnerCornerOffset, "Corner Offset: ", this);
        this.addLabeled(this.spinnerSampleRadius, "Sample Radius: ", this);
        this.addLabeled(this.spinnerRefineMaxIterations, "Iterations: ", this);
        this.addLabeled(this.spinnerConvergeTol, "Converge Tol Pixels: ", this);
        this.addLabeled(this.spinnerMaxCornerChange, "Max Corner Change: ", this);
        this.addVerticalGlue(this);
    }

    private void configureSpinnerFloat(JSpinner spinner) {
        JSpinner.NumberEditor editor = (JSpinner.NumberEditor)spinner.getEditor();
        DecimalFormat format = editor.getFormat();
        format.setMinimumFractionDigits(3);
        format.setMinimumIntegerDigits(1);
        editor.getTextField().setHorizontalAlignment(0);
        Dimension d = spinner.getPreferredSize();
        d.width = 60;
        spinner.setPreferredSize(d);
        spinner.addChangeListener(this);
        spinner.setMaximumSize(d);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.imageView) {
            this.selectedView = this.imageView.getSelectedIndex();
            this.owner.viewUpdated();
        } else if (e.getSource() == this.showCorners) {
            this.bShowCorners = this.showCorners.isSelected();
            this.owner.viewUpdated();
        } else if (e.getSource() == this.showLines) {
            this.bShowLines = this.showLines.isSelected();
            this.owner.viewUpdated();
        } else if (e.getSource() == this.showContour) {
            this.bShowContour = this.showContour.isSelected();
            this.owner.viewUpdated();
        } else if (e.getSource() == this.refineChoice) {
            this.refineType = PolygonRefineType.values()[this.refineChoice.getSelectedIndex()];
            this.updateRefineSettings();
            this.owner.configUpdate();
        } else if (e.getSource() == this.setConvex) {
            this.config.convex = this.setConvex.isSelected();
            this.owner.configUpdate();
        } else if (e.getSource() == this.setBorder) {
            this.config.canTouchBorder = this.setBorder.isSelected();
            this.owner.configUpdate();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        PolygonRefineType refine = PolygonRefineType.values()[this.refineChoice.getSelectedIndex()];
        if (e.getSource() == this.spinnerMinEdge) {
            this.config.minimumEdgeIntensity = ((Number)this.spinnerMinEdge.getValue()).doubleValue();
        } else if (e.getSource() == this.spinnerMinSides) {
            this.minSides = ((Number)this.spinnerMinSides.getValue()).intValue();
            if (this.minSides > this.maxSides) {
                this.maxSides = this.minSides;
                this.spinnerMaxSides.setValue(this.minSides);
            }
            this.updateSidesInConfig();
        } else if (e.getSource() == this.spinnerMaxSides) {
            this.maxSides = ((Number)this.spinnerMaxSides.getValue()).intValue();
            if (this.maxSides < this.minSides) {
                this.minSides = this.maxSides;
                this.spinnerMinSides.setValue(this.minSides);
            }
            this.updateSidesInConfig();
        } else {
            if (e.getSource() == this.selectZoom) {
                this.zoom = ((Number)this.selectZoom.getValue()).doubleValue();
                this.owner.viewUpdated();
                return;
            }
            if (e.getSource() == this.spinnerMinContourSize) {
                this.config.minContourImageWidthFraction = ((Number)this.spinnerMinContourSize.getValue()).doubleValue();
            } else if (e.getSource() == this.spinnerContourSplit) {
                this.config.contour2Poly_splitFraction = ((Number)this.spinnerContourSplit.getValue()).doubleValue();
            } else if (e.getSource() == this.spinnerContourMinSplit) {
                this.config.contour2Poly_minimumSideFraction = ((Number)this.spinnerContourMinSplit.getValue()).doubleValue();
            } else if (e.getSource() == this.spinnerContourIterations) {
                this.config.contour2Poly_iterations = ((Number)this.spinnerContourIterations.getValue()).intValue();
            } else if (e.getSource() == this.spinnerSplitPenalty) {
                this.config.splitPenalty = ((Number)this.spinnerSplitPenalty.getValue()).doubleValue();
            } else if (e.getSource() == this.spinnerLineSamples) {
                if (refine == PolygonRefineType.LINE) {
                    this.configLine.lineSamples = ((Number)this.spinnerLineSamples.getValue()).intValue();
                } else {
                    this.configCorner.lineSamples = ((Number)this.spinnerLineSamples.getValue()).intValue();
                }
            } else if (e.getSource() == this.spinnerCornerOffset) {
                if (refine == PolygonRefineType.LINE) {
                    this.configLine.cornerOffset = ((Number)this.spinnerCornerOffset.getValue()).intValue();
                } else {
                    this.configCorner.cornerOffset = ((Number)this.spinnerCornerOffset.getValue()).intValue();
                }
            } else if (e.getSource() == this.spinnerSampleRadius) {
                if (refine == PolygonRefineType.LINE) {
                    this.configLine.sampleRadius = ((Number)this.spinnerSampleRadius.getValue()).intValue();
                } else {
                    this.configCorner.sampleRadius = ((Number)this.spinnerSampleRadius.getValue()).intValue();
                }
            } else if (e.getSource() == this.spinnerRefineMaxIterations) {
                if (refine == PolygonRefineType.LINE) {
                    this.configLine.maxIterations = ((Number)this.spinnerRefineMaxIterations.getValue()).intValue();
                } else {
                    this.configCorner.maxIterations = ((Number)this.spinnerRefineMaxIterations.getValue()).intValue();
                }
            } else if (e.getSource() == this.spinnerConvergeTol) {
                if (refine == PolygonRefineType.LINE) {
                    this.configLine.convergeTolPixels = ((Number)this.spinnerConvergeTol.getValue()).doubleValue();
                } else {
                    this.configCorner.convergeTolPixels = ((Number)this.spinnerConvergeTol.getValue()).doubleValue();
                }
            } else if (e.getSource() == this.spinnerMaxCornerChange) {
                if (refine == PolygonRefineType.LINE) {
                    this.configLine.maxCornerChangePixel = ((Number)this.spinnerMaxCornerChange.getValue()).doubleValue();
                } else {
                    this.configCorner.maxCornerChangePixel = ((Number)this.spinnerMaxCornerChange.getValue()).doubleValue();
                }
            }
        }
        this.owner.configUpdate();
    }

    private void updateSidesInConfig() {
        this.config.minimumSides = this.minSides;
        this.config.maximumSides = this.maxSides;
    }

    private void updateRefineSettings() {
        this.spinnerLineSamples.removeChangeListener(this);
        this.spinnerCornerOffset.removeChangeListener(this);
        this.spinnerSampleRadius.removeChangeListener(this);
        this.spinnerRefineMaxIterations.removeChangeListener(this);
        this.spinnerConvergeTol.removeChangeListener(this);
        this.spinnerMaxCornerChange.removeChangeListener(this);
        if (this.refineType == PolygonRefineType.LINE) {
            this.spinnerLineSamples.setValue(this.configLine.lineSamples);
            this.spinnerCornerOffset.setValue(this.configLine.cornerOffset);
            this.spinnerSampleRadius.setValue(this.configLine.sampleRadius);
            this.spinnerRefineMaxIterations.setValue(this.configLine.maxIterations);
            this.spinnerConvergeTol.setValue(this.configLine.convergeTolPixels);
            this.spinnerMaxCornerChange.setValue(this.configLine.maxCornerChangePixel);
        } else if (this.refineType == PolygonRefineType.CORNER) {
            this.spinnerLineSamples.setValue(this.configCorner.lineSamples);
            this.spinnerCornerOffset.setValue(this.configCorner.cornerOffset);
            this.spinnerSampleRadius.setValue(this.configCorner.sampleRadius);
            this.spinnerRefineMaxIterations.setValue(this.configCorner.maxIterations);
            this.spinnerConvergeTol.setValue(this.configCorner.convergeTolPixels);
            this.spinnerMaxCornerChange.setValue(this.configCorner.maxCornerChangePixel);
        }
        this.spinnerLineSamples.addChangeListener(this);
        this.spinnerCornerOffset.addChangeListener(this);
        this.spinnerSampleRadius.addChangeListener(this);
        this.spinnerRefineMaxIterations.addChangeListener(this);
        this.spinnerConvergeTol.addChangeListener(this);
        this.spinnerMaxCornerChange.addChangeListener(this);
    }

    public ThresholdControlPanel getThreshold() {
        return this.threshold;
    }

    public ConfigPolygonDetector getConfigPolygon() {
        return this.config;
    }

    public ConfigRefinePolygonLineToImage getConfigLine() {
        return this.configLine;
    }

    public ConfigRefinePolygonCornersToImage getConfigCorner() {
        return this.configCorner;
    }

    public PolygonRefineType getRefineType() {
        return this.refineType;
    }
}

