/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.sfm.d3;

import boofcv.abst.feature.associate.AssociateDescTo2D;
import boofcv.abst.feature.associate.ScoreAssociateHamming_B;
import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.abst.feature.detdesc.DetectDescribeMultiFusion;
import boofcv.abst.feature.detect.extract.ConfigExtract;
import boofcv.abst.feature.detect.extract.NonMaxSuppression;
import boofcv.abst.feature.detect.intensity.GeneralFeatureIntensity;
import boofcv.abst.feature.detect.interest.ConfigGeneralDetector;
import boofcv.abst.feature.detect.interest.GeneralToInterestMulti;
import boofcv.abst.feature.disparity.StereoDisparitySparse;
import boofcv.abst.feature.tracker.PointTracker;
import boofcv.abst.feature.tracker.PointTrackerToTwoPass;
import boofcv.abst.feature.tracker.PointTrackerTwoPass;
import boofcv.abst.sfm.AccessPointTracks3D;
import boofcv.abst.sfm.d3.StereoVisualOdometry;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.tracker.klt.PkltConfig;
import boofcv.demonstrations.sfm.d3.VisualOdometryPanel;
import boofcv.factory.feature.associate.FactoryAssociation;
import boofcv.factory.feature.describe.FactoryDescribeRegionPoint;
import boofcv.factory.feature.detect.extract.FactoryFeatureExtractor;
import boofcv.factory.feature.detect.intensity.FactoryIntensityPoint;
import boofcv.factory.feature.disparity.FactoryStereoDisparity;
import boofcv.factory.feature.tracker.FactoryPointTracker;
import boofcv.factory.feature.tracker.FactoryPointTrackerTwoPass;
import boofcv.factory.sfm.FactoryVisualOdometry;
import boofcv.gui.StereoVideoAppBase;
import boofcv.gui.VisualizeApp;
import boofcv.gui.d3.Polygon3DSequenceViewer;
import boofcv.gui.feature.VisualizeFeatures;
import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.PathLabel;
import boofcv.io.UtilIO;
import boofcv.io.image.SimpleImageSequence;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.feature.TupleDesc_B;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.SwingUtilities;
import org.ejml.data.DenseMatrix64F;

public class VisualizeStereoVisualOdometryApp<I extends ImageGray>
extends StereoVideoAppBase<I>
implements VisualizeApp,
VisualOdometryPanel.Listener {
    VisualOdometryPanel guiInfo;
    ImagePanel guiLeft;
    ImagePanel guiRight;
    Polygon3DSequenceViewer guiCam3D;
    StereoVisualOdometry<I> alg;
    boolean hasProcessedImage = false;
    boolean noFault;
    boolean showTracks;
    boolean showInliers;
    int numFaults;
    int numTracks;
    int numInliers;
    int whichAlg;

    public VisualizeStereoVisualOdometryApp(Class<I> imageType) {
        super(1, imageType);
        this.addAlgorithm(0, "Single Depth : KLT", 0);
        this.addAlgorithm(0, "Single Depth : ST-BRIEF", 1);
        this.addAlgorithm(0, "Single Depth : ST-SURF-KLT", 2);
        this.addAlgorithm(0, "Dual Track : KLT + SURF", 3);
        this.addAlgorithm(0, "Quad Match : ST-BRIEF", 4);
        this.guiInfo = new VisualOdometryPanel(VisualOdometryPanel.Type.STEREO);
        this.guiLeft = new ImagePanel();
        this.guiRight = new ImagePanel();
        this.guiCam3D = new Polygon3DSequenceViewer();
        this.add((Component)this.guiInfo, "West");
        this.add((Component)this.guiRight, "East");
        this.setMainGUI(this.guiLeft);
        this.guiLeft.addMouseListener(this);
        this.guiInfo.setListener(this);
    }

    private void drawFeatures(AccessPointTracks3D tracker, BufferedImage image) {
        this.numInliers = 0;
        Graphics2D g2 = image.createGraphics();
        List<Point2D_F64> points = tracker.getAllTracks();
        if (points.size() == 0) {
            return;
        }
        double[] ranges = new double[points.size()];
        for (int i = 0; i < points.size(); ++i) {
            ranges[i] = tracker.getTrackLocation((int)i).z;
        }
        Arrays.sort(ranges);
        double maxRange = ranges[(int)((double)ranges.length * 0.8)];
        for (int i = 0; i < points.size(); ++i) {
            Point2D_F64 pixel = points.get(i);
            if (this.showTracks && tracker.isNew(i)) {
                VisualizeFeatures.drawPoint(g2, (int)pixel.x, (int)pixel.y, 3, Color.GREEN);
                continue;
            }
            if (tracker.isInlier(i)) {
                if (this.showInliers) {
                    VisualizeFeatures.drawPoint(g2, (int)pixel.x, (int)pixel.y, 7, Color.BLUE, false);
                }
                ++this.numInliers;
            }
            if (!this.showTracks) continue;
            Point3D_F64 p3 = tracker.getTrackLocation(i);
            double r = p3.z / maxRange;
            if (r < 0.0) {
                r = 0.0;
            } else if (r > 1.0) {
                r = 1.0;
            }
            int color = 0xFF0000 | (int)(255.0 * r) << 8;
            VisualizeFeatures.drawPoint(g2, (int)pixel.x, (int)pixel.y, 3, new Color(color));
        }
        this.numTracks = points.size();
    }

    @Override
    protected void process(SimpleImageSequence<I> sequence1, SimpleImageSequence<I> sequence2) {
        this.stopWorker();
        sequence1.setLoop(false);
        sequence2.setLoop(false);
        this.sequence1 = sequence1;
        this.sequence2 = sequence2;
        this.doRefreshAll();
    }

    @Override
    protected void updateAlg(I frame1, BufferedImage buffImage1, I frame2, BufferedImage buffImage2) {
        if (this.config.left.width != ((ImageGray)frame1).width || this.config.left.height != ((ImageGray)frame1).height) {
            throw new IllegalArgumentException("Miss match between calibration and actual image size");
        }
        this.noFault = this.alg.process(frame1, frame2);
    }

    @Override
    protected void updateAlgGUI(I frame1, final BufferedImage buffImage1, I frame2, final BufferedImage buffImage2, final double fps) {
        if (!this.noFault) {
            ++this.numFaults;
        }
        this.showTracks = this.guiInfo.isShowAll();
        this.showInliers = this.guiInfo.isShowInliers();
        this.drawFeatures((AccessPointTracks3D)((Object)this.alg), buffImage1);
        final Se3_F64 leftToWorld = ((Se3_F64)this.alg.getCameraToWorld()).copy();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VisualizeStereoVisualOdometryApp.this.guiLeft.setBufferedImage(buffImage1);
                VisualizeStereoVisualOdometryApp.this.guiRight.setBufferedImage(buffImage2);
                VisualizeStereoVisualOdometryApp.this.guiLeft.autoSetPreferredSize();
                VisualizeStereoVisualOdometryApp.this.guiRight.autoSetPreferredSize();
                VisualizeStereoVisualOdometryApp.this.guiLeft.repaint();
                VisualizeStereoVisualOdometryApp.this.guiRight.repaint();
                VisualizeStereoVisualOdometryApp.this.guiInfo.setCameraToWorld(leftToWorld);
                VisualizeStereoVisualOdometryApp.this.guiInfo.setNumFaults(VisualizeStereoVisualOdometryApp.this.numFaults);
                VisualizeStereoVisualOdometryApp.this.guiInfo.setNumTracks(VisualizeStereoVisualOdometryApp.this.numTracks);
                VisualizeStereoVisualOdometryApp.this.guiInfo.setNumInliers(VisualizeStereoVisualOdometryApp.this.numInliers);
                VisualizeStereoVisualOdometryApp.this.guiInfo.setFps(fps);
            }
        });
        double r = this.config.getBaseline();
        Point3D_F64 p1 = new Point3D_F64(-r, -r, 0.0);
        Point3D_F64 p2 = new Point3D_F64(r, -r, 0.0);
        Point3D_F64 p3 = new Point3D_F64(r, r, 0.0);
        Point3D_F64 p4 = new Point3D_F64(-r, r, 0.0);
        SePointOps_F64.transform((Se3_F64)leftToWorld, (Point3D_F64)p1, (Point3D_F64)p1);
        SePointOps_F64.transform((Se3_F64)leftToWorld, (Point3D_F64)p2, (Point3D_F64)p2);
        SePointOps_F64.transform((Se3_F64)leftToWorld, (Point3D_F64)p3, (Point3D_F64)p3);
        SePointOps_F64.transform((Se3_F64)leftToWorld, (Point3D_F64)p4, (Point3D_F64)p4);
        this.guiCam3D.add(p1, p2, p3, p4);
        this.guiCam3D.repaint();
        this.hasProcessedImage = true;
    }

    @Override
    public void refreshAll(Object[] cookies) {
        this.numFaults = 0;
        if (cookies != null) {
            this.whichAlg = (Integer)cookies[0];
        }
        this.alg = this.createStereoDepth(this.whichAlg);
        this.alg.setCalibration(this.config);
        this.guiInfo.reset();
        this.handleRunningStatus(2);
        IntrinsicParameters right = this.config.right;
        DenseMatrix64F K = PerspectiveOps.calibrationMatrix(this.config.left, null);
        this.guiCam3D.init();
        this.guiCam3D.setK(K);
        this.guiCam3D.setStepSize(this.config.getBaseline());
        this.guiCam3D.setPreferredSize(new Dimension(right.width, right.height));
        this.guiCam3D.setMaximumSize(this.guiCam3D.getPreferredSize());
        this.startWorkerThread();
    }

    private StereoVisualOdometry<I> createStereoDepth(int whichAlg) {
        Class derivType = GImageDerivativeOps.getDerivativeType(this.imageType);
        StereoDisparitySparse disparity = FactoryStereoDisparity.regionSparseWta(2, 150, 3, 3, 30.0, -1.0, true, this.imageType);
        PkltConfig kltConfig = new PkltConfig();
        kltConfig.templateRadius = 3;
        kltConfig.pyramidScaling = new int[]{1, 2, 4, 8};
        if (whichAlg == 0) {
            ConfigGeneralDetector configDetector = new ConfigGeneralDetector(600, 3, 1.0f);
            PointTrackerTwoPass tracker = FactoryPointTrackerTwoPass.klt(kltConfig, configDetector, this.imageType, derivType);
            return FactoryVisualOdometry.stereoDepth(1.5, 120, 2, 200, 50, false, disparity, tracker, this.imageType);
        }
        if (whichAlg == 1) {
            ConfigGeneralDetector configExtract = new ConfigGeneralDetector(600, 3, 1.0f);
            GeneralFeatureDetector detector = FactoryPointTracker.createShiTomasi(configExtract, derivType);
            DescribeRegionPoint describe = FactoryDescribeRegionPoint.brief(null, this.imageType);
            ScoreAssociateHamming_B score = new ScoreAssociateHamming_B();
            AssociateDescTo2D<TupleDesc_B> associate = new AssociateDescTo2D<TupleDesc_B>(FactoryAssociation.greedy(score, 150.0, true));
            PointTrackerTwoPass tracker = FactoryPointTrackerTwoPass.dda(detector, describe, associate, null, 1.0, this.imageType);
            return FactoryVisualOdometry.stereoDepth(1.5, 80, 3, 200, 50, false, disparity, tracker, this.imageType);
        }
        if (whichAlg == 2) {
            PointTracker tracker = FactoryPointTracker.combined_ST_SURF_KLT(new ConfigGeneralDetector(600, 3, 0.0f), kltConfig, 50, null, null, this.imageType, derivType);
            PointTrackerToTwoPass twopass = new PointTrackerToTwoPass(tracker);
            return FactoryVisualOdometry.stereoDepth(1.5, 80, 3, 200, 50, false, disparity, twopass, this.imageType);
        }
        if (whichAlg == 3) {
            ConfigGeneralDetector configDetector = new ConfigGeneralDetector(600, 3, 1.0f);
            PointTracker trackerLeft = FactoryPointTracker.klt(kltConfig, configDetector, this.imageType, derivType);
            PointTracker trackerRight = FactoryPointTracker.klt(kltConfig, configDetector, this.imageType, derivType);
            DescribeRegionPoint describe = FactoryDescribeRegionPoint.surfFast(null, this.imageType);
            return FactoryVisualOdometry.stereoDualTrackerPnP(90, 2, 1.5, 1.5, 200, 50, trackerLeft, trackerRight, describe, this.imageType);
        }
        if (whichAlg == 4) {
            GeneralFeatureIntensity intensity = FactoryIntensityPoint.shiTomasi(1, false, this.imageType);
            NonMaxSuppression nonmax = FactoryFeatureExtractor.nonmax(new ConfigExtract(2, 50.0f, 0, true, false, true));
            GeneralFeatureDetector general = new GeneralFeatureDetector(intensity, nonmax);
            general.setMaxFeatures(600);
            GeneralToInterestMulti detector = new GeneralToInterestMulti(general, 2.0, this.imageType, derivType);
            DescribeRegionPoint describe = FactoryDescribeRegionPoint.surfFast(null, this.imageType);
            DetectDescribeMultiFusion detDescMulti = new DetectDescribeMultiFusion(detector, null, describe);
            return FactoryVisualOdometry.stereoQuadPnP(1.5, 0.5, 75.0, Double.MAX_VALUE, 300, 50, detDescMulti, this.imageType);
        }
        throw new RuntimeException("Unknown selection");
    }

    @Override
    public void setActiveAlgorithm(int indexFamily, String name, Object cookie) {
        this.stopWorker();
        this.whichAlg = (Integer)cookie;
        this.sequence1.reset();
        this.sequence2.reset();
        this.refreshAll(null);
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.hasProcessedImage;
    }

    @Override
    protected void handleRunningStatus(int status) {
        Color color;
        String text;
        switch (status) {
            case 0: {
                text = "RUNNING";
                color = Color.BLACK;
                break;
            }
            case 1: {
                text = "PAUSED";
                color = Color.RED;
                break;
            }
            case 2: {
                text = "FINISHED";
                color = Color.RED;
                break;
            }
            default: {
                text = "UNKNOWN";
                color = Color.BLUE;
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VisualizeStereoVisualOdometryApp.this.guiInfo.setStatus(text, color);
            }
        });
    }

    @Override
    public void eventVoPanel(final int view) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (view == 0) {
                    VisualizeStereoVisualOdometryApp.this.remove(VisualizeStereoVisualOdometryApp.this.guiCam3D);
                    VisualizeStereoVisualOdometryApp.this.add((Component)VisualizeStereoVisualOdometryApp.this.guiRight, "East");
                } else {
                    VisualizeStereoVisualOdometryApp.this.remove(VisualizeStereoVisualOdometryApp.this.guiRight);
                    VisualizeStereoVisualOdometryApp.this.add((Component)VisualizeStereoVisualOdometryApp.this.guiCam3D, "East");
                }
                VisualizeStereoVisualOdometryApp.this.revalidate();
                VisualizeStereoVisualOdometryApp.this.repaint();
            }
        });
    }

    public static void main(String[] args) throws FileNotFoundException {
        Class<GrayF32> type = GrayF32.class;
        VisualizeStereoVisualOdometryApp<GrayF32> app = new VisualizeStereoVisualOdometryApp<GrayF32>(type);
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("Inside", UtilIO.pathExample("vo/library/config.txt")));
        inputs.add(new PathLabel("Outside", UtilIO.pathExample("vo/backyard/config.txt")));
        inputs.add(new PathLabel("Urban", UtilIO.pathExample("vo/rockville/config.txt")));
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Stereo Visual Odometry", true);
    }
}

