/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.sfm.d3;

import boofcv.abst.feature.detect.interest.ConfigGeneralDetector;
import boofcv.abst.feature.tracker.PointTracker;
import boofcv.abst.sfm.AccessPointTracks3D;
import boofcv.abst.sfm.d3.MonocularPlaneVisualOdometry;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.tracker.klt.PkltConfig;
import boofcv.demonstrations.sfm.d3.VisualOdometryPanel;
import boofcv.factory.feature.tracker.FactoryPointTracker;
import boofcv.factory.sfm.FactoryVisualOdometry;
import boofcv.gui.VideoProcessAppBase;
import boofcv.gui.VisualizeApp;
import boofcv.gui.d2.PlaneView2D;
import boofcv.gui.d3.Polygon3DSequenceViewer;
import boofcv.gui.feature.VisualizeFeatures;
import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.PathLabel;
import boofcv.io.UtilIO;
import boofcv.io.image.SimpleImageSequence;
import boofcv.struct.calib.MonoPlaneParameters;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.SwingUtilities;
import org.ejml.data.DenseMatrix64F;

public class VisualizeMonocularPlaneVisualOdometryApp<I extends ImageGray>
extends VideoProcessAppBase<I>
implements VisualizeApp,
VisualOdometryPanel.Listener {
    protected MonoPlaneParameters config;
    VisualOdometryPanel guiInfo;
    ImagePanel guiLeft;
    Polygon3DSequenceViewer guiCam3D;
    PlaneView2D gui2D;
    Class<I> imageClass;
    MonocularPlaneVisualOdometry<I> alg;
    boolean hasProcessedImage = false;
    boolean noFault;
    boolean showTracks;
    boolean showInliers;
    int numFaults;
    int numTracks;
    int numInliers;
    int whichAlg;

    public VisualizeMonocularPlaneVisualOdometryApp(Class<I> imageClass) {
        super(1, imageClass);
        this.imageClass = imageClass;
        this.addAlgorithm(0, "Plane-Infinity : KLT", 0);
        this.addAlgorithm(0, "Overhead : KLT", 1);
        this.guiInfo = new VisualOdometryPanel(VisualOdometryPanel.Type.MONO_PLANE);
        this.guiLeft = new ImagePanel();
        this.guiCam3D = new Polygon3DSequenceViewer();
        this.gui2D = new PlaneView2D(0.1);
        this.add((Component)this.guiInfo, "West");
        this.add((Component)this.gui2D, "East");
        this.setMainGUI(this.guiLeft);
        this.guiLeft.addMouseListener(this);
        this.guiInfo.setListener(this);
    }

    private void drawFeatures(AccessPointTracks3D tracker, BufferedImage image) {
        this.numInliers = 0;
        Graphics2D g2 = image.createGraphics();
        List<Point2D_F64> points = tracker.getAllTracks();
        if (points.size() == 0) {
            return;
        }
        double[] ranges = new double[points.size()];
        for (int i = 0; i < points.size(); ++i) {
            ranges[i] = tracker.getTrackLocation((int)i).z;
        }
        Arrays.sort(ranges);
        double maxRange = ranges[(int)((double)ranges.length * 0.8)];
        for (int i = 0; i < points.size(); ++i) {
            Point2D_F64 pixel = points.get(i);
            if (this.showTracks && tracker.isNew(i)) {
                VisualizeFeatures.drawPoint(g2, (int)pixel.x, (int)pixel.y, 3, Color.GREEN);
                continue;
            }
            if (tracker.isInlier(i)) {
                if (this.showInliers) {
                    VisualizeFeatures.drawPoint(g2, (int)pixel.x, (int)pixel.y, 7, Color.BLUE, false);
                }
                ++this.numInliers;
            }
            if (!this.showTracks) continue;
            Point3D_F64 p3 = tracker.getTrackLocation(i);
            double r = p3.z / maxRange;
            if (r < 0.0) {
                r = 0.0;
            } else if (r > 1.0) {
                r = 1.0;
            }
            int color = 0xFF0000 | (int)(255.0 * r) << 8;
            VisualizeFeatures.drawPoint(g2, (int)pixel.x, (int)pixel.y, 3, new Color(color));
        }
        this.numTracks = points.size();
    }

    @Override
    public void changeInput(String name, int index) {
        this.stopWorker();
        Reader r = this.media.openFile(((PathLabel)this.inputRefs.get(index)).getPath());
        BufferedReader in = new BufferedReader(r);
        try {
            String path = new File(((PathLabel)this.inputRefs.get(index)).getPath()).getParent();
            String lineConfig = in.readLine();
            String line1 = in.readLine();
            if (lineConfig.charAt(0) != '/') {
                lineConfig = path + "/" + lineConfig;
            }
            if (line1.charAt(0) != '/') {
                line1 = path + "/" + line1;
            }
            this.config = (MonoPlaneParameters)UtilIO.loadXML(this.media.openFile(lineConfig));
            SimpleImageSequence video = this.media.openVideo(line1, this.imageType);
            this.process(video);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void process(SimpleImageSequence<I> sequence) {
        this.stopWorker();
        this.sequence = sequence;
        sequence.setLoop(false);
        this.doRefreshAll();
    }

    @Override
    protected void updateAlg(I frame, BufferedImage buffImage) {
        if (this.config.intrinsic.width != ((ImageGray)frame).width || this.config.intrinsic.height != ((ImageGray)frame).height) {
            throw new IllegalArgumentException("Miss match between calibration and actual image size");
        }
        this.noFault = this.alg.process(frame);
        if (!this.noFault) {
            this.alg.reset();
            this.guiCam3D.init();
        }
    }

    @Override
    protected void updateAlgGUI(I frame1, final BufferedImage buffImage1, final double fps) {
        if (!this.noFault) {
            ++this.numFaults;
            return;
        }
        this.showTracks = this.guiInfo.isShowAll();
        this.showInliers = this.guiInfo.isShowInliers();
        if (this.alg instanceof AccessPointTracks3D) {
            this.drawFeatures((AccessPointTracks3D)((Object)this.alg), buffImage1);
        }
        final Se3_F64 leftToWorld = ((Se3_F64)this.alg.getCameraToWorld()).copy();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VisualizeMonocularPlaneVisualOdometryApp.this.guiLeft.setBufferedImage(buffImage1);
                VisualizeMonocularPlaneVisualOdometryApp.this.guiLeft.autoSetPreferredSize();
                VisualizeMonocularPlaneVisualOdometryApp.this.guiLeft.repaint();
                VisualizeMonocularPlaneVisualOdometryApp.this.guiInfo.setCameraToWorld(leftToWorld);
                VisualizeMonocularPlaneVisualOdometryApp.this.guiInfo.setNumFaults(VisualizeMonocularPlaneVisualOdometryApp.this.numFaults);
                VisualizeMonocularPlaneVisualOdometryApp.this.guiInfo.setNumTracks(VisualizeMonocularPlaneVisualOdometryApp.this.numTracks);
                VisualizeMonocularPlaneVisualOdometryApp.this.guiInfo.setNumInliers(VisualizeMonocularPlaneVisualOdometryApp.this.numInliers);
                VisualizeMonocularPlaneVisualOdometryApp.this.guiInfo.setFps(fps);
            }
        });
        double r = 0.15;
        Point3D_F64 p1 = new Point3D_F64(-r, -r, 0.0);
        Point3D_F64 p2 = new Point3D_F64(r, -r, 0.0);
        Point3D_F64 p3 = new Point3D_F64(r, r, 0.0);
        Point3D_F64 p4 = new Point3D_F64(-r, r, 0.0);
        SePointOps_F64.transform((Se3_F64)leftToWorld, (Point3D_F64)p1, (Point3D_F64)p1);
        SePointOps_F64.transform((Se3_F64)leftToWorld, (Point3D_F64)p2, (Point3D_F64)p2);
        SePointOps_F64.transform((Se3_F64)leftToWorld, (Point3D_F64)p3, (Point3D_F64)p3);
        SePointOps_F64.transform((Se3_F64)leftToWorld, (Point3D_F64)p4, (Point3D_F64)p4);
        this.guiCam3D.add(p1, p2, p3, p4);
        this.guiCam3D.repaint();
        this.gui2D.addPoint(leftToWorld.T.x, leftToWorld.T.z);
        this.gui2D.repaint();
        this.hasProcessedImage = true;
    }

    @Override
    public void refreshAll(Object[] cookies) {
        this.numFaults = 0;
        if (cookies != null) {
            this.whichAlg = (Integer)cookies[0];
        }
        this.alg = this.createVisualOdometry(this.whichAlg);
        this.alg.setCalibration(this.config);
        this.guiInfo.reset();
        this.gui2D.reset();
        this.handleRunningStatus(2);
        DenseMatrix64F K = PerspectiveOps.calibrationMatrix(this.config.intrinsic, null);
        this.guiCam3D.init();
        this.guiCam3D.setK(K);
        this.guiCam3D.setStepSize(1.0);
        this.guiCam3D.setPreferredSize(new Dimension(this.config.intrinsic.width, this.config.intrinsic.height));
        this.guiCam3D.setMaximumSize(this.guiCam3D.getPreferredSize());
        this.gui2D.setPreferredSize(new Dimension(this.config.intrinsic.width, this.config.intrinsic.height));
        this.gui2D.setMaximumSize(this.gui2D.getPreferredSize());
        this.startWorkerThread();
    }

    private MonocularPlaneVisualOdometry<I> createVisualOdometry(int whichAlg) {
        Class derivType = GImageDerivativeOps.getDerivativeType(this.imageClass);
        if (whichAlg == 0) {
            PkltConfig config = new PkltConfig();
            config.pyramidScaling = new int[]{1, 2, 4, 8};
            config.templateRadius = 3;
            ConfigGeneralDetector configDetector = new ConfigGeneralDetector(600, 3, 1.0f);
            PointTracker<I> tracker = FactoryPointTracker.klt(config, configDetector, this.imageClass, derivType);
            return FactoryVisualOdometry.monoPlaneInfinity(75, 2, 1.5, 200, tracker, this.imageType);
        }
        if (whichAlg == 1) {
            PkltConfig config = new PkltConfig();
            config.pyramidScaling = new int[]{1, 2, 4, 8};
            config.templateRadius = 3;
            ConfigGeneralDetector configDetector = new ConfigGeneralDetector(600, 3, 1.0f);
            PointTracker<I> tracker = FactoryPointTracker.klt(config, configDetector, this.imageClass, derivType);
            double cellSize = 0.06;
            double inlierGroundTol = 1.5;
            return FactoryVisualOdometry.monoPlaneOverhead(cellSize, 25.0, 0.7, inlierGroundTol, 300, 2, 100, 0.5, 0.6, tracker, this.imageType);
        }
        throw new RuntimeException("Unknown selection");
    }

    @Override
    public void setActiveAlgorithm(int indexFamily, String name, Object cookie) {
        this.stopWorker();
        this.whichAlg = (Integer)cookie;
        this.sequence.reset();
        this.refreshAll(null);
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.hasProcessedImage;
    }

    @Override
    protected void handleRunningStatus(int status) {
        Color color;
        String text;
        switch (status) {
            case 0: {
                text = "RUNNING";
                color = Color.BLACK;
                break;
            }
            case 1: {
                text = "PAUSED";
                color = Color.RED;
                break;
            }
            case 2: {
                text = "FINISHED";
                color = Color.RED;
                break;
            }
            default: {
                text = "UNKNOWN";
                color = Color.BLUE;
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VisualizeMonocularPlaneVisualOdometryApp.this.guiInfo.setStatus(text, color);
            }
        });
    }

    @Override
    public void eventVoPanel(final int view) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (view == 0) {
                    VisualizeMonocularPlaneVisualOdometryApp.this.gui2D.setPreferredSize(VisualizeMonocularPlaneVisualOdometryApp.this.guiCam3D.getPreferredSize());
                    VisualizeMonocularPlaneVisualOdometryApp.this.remove(VisualizeMonocularPlaneVisualOdometryApp.this.guiCam3D);
                    VisualizeMonocularPlaneVisualOdometryApp.this.add((Component)VisualizeMonocularPlaneVisualOdometryApp.this.gui2D, "East");
                } else {
                    VisualizeMonocularPlaneVisualOdometryApp.this.guiCam3D.setPreferredSize(VisualizeMonocularPlaneVisualOdometryApp.this.gui2D.getPreferredSize());
                    VisualizeMonocularPlaneVisualOdometryApp.this.remove(VisualizeMonocularPlaneVisualOdometryApp.this.gui2D);
                    VisualizeMonocularPlaneVisualOdometryApp.this.add((Component)VisualizeMonocularPlaneVisualOdometryApp.this.guiCam3D, "East");
                }
                VisualizeMonocularPlaneVisualOdometryApp.this.revalidate();
                VisualizeMonocularPlaneVisualOdometryApp.this.repaint();
            }
        });
    }

    public static void main(String[] args) throws FileNotFoundException {
        Class<GrayF32> type = GrayF32.class;
        VisualizeMonocularPlaneVisualOdometryApp<GrayF32> app = new VisualizeMonocularPlaneVisualOdometryApp<GrayF32>(type);
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("Simulation", UtilIO.pathExample("vo/drc/config_plane.txt")));
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Monocular Plane Visual Odometry", true);
    }
}

