/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.sfm.d2;

import boofcv.abst.feature.tracker.PointTracker;
import boofcv.abst.sfm.AccessPointTracks;
import boofcv.abst.sfm.d2.ImageMotion2D;
import boofcv.abst.sfm.d2.PlToGrayMotion2D;
import boofcv.alg.sfm.d2.StitchingFromMotion2D;
import boofcv.demonstrations.sfm.d2.ImageMotionInfoPanel;
import boofcv.demonstrations.sfm.d2.Motion2DPanel;
import boofcv.factory.sfm.FactoryMotion2D;
import boofcv.gui.VideoProcessAppBase;
import boofcv.gui.VisualizeApp;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.SimpleImageSequence;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.struct.InvertibleTransform;
import georegression.struct.homography.Homography2D_F64;
import georegression.struct.point.Point2D_F64;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public abstract class VideoStitchBaseApp<I extends ImageBase, IT extends InvertibleTransform>
extends VideoProcessAppBase<I>
implements VisualizeApp {
    int inputWidth;
    int inputHeight;
    int stitchWidth;
    int stitchHeight;
    boolean showImageView;
    int borderTolerance = 30;
    IT fitModel;
    protected PointTracker<I> tracker;
    BufferedImage stitchOut;
    StitchingFromMotion2D alg;
    StitchingFromMotion2D.Corners corners;
    int totalResets;
    private static final int maxIterations = 100;
    private static final int pruneThreshold = 10;
    boolean hasProcessedImage = false;
    protected Motion2DPanel gui;
    protected ImageMotionInfoPanel infoPanel = new ImageMotionInfoPanel();
    protected int absoluteMinimumTracks;
    protected double respawnTrackFraction;
    protected double respawnCoverageFraction;
    protected double maxJumpFraction;
    protected double inlierThreshold;

    public VideoStitchBaseApp(int numAlgFamilies, Class imageType, boolean color, Motion2DPanel gui) {
        super(numAlgFamilies, color ? ImageType.pl(3, imageType) : ImageType.single(imageType));
        this.gui = gui;
        gui.addMouseListener(this);
        this.setMainGUI(gui);
        this.infoPanel.setMaximumSize(this.infoPanel.getPreferredSize());
        this.add((Component)this.infoPanel, "West");
    }

    protected void setStitchImageSize(int width, int height) {
        this.stitchWidth = width;
        this.stitchHeight = height;
        this.stitchOut = new BufferedImage(this.stitchWidth, this.stitchHeight, 1);
    }

    protected StitchingFromMotion2D createAlgorithm(PointTracker<I> tracker) {
        if (this.imageType.getFamily() == ImageType.Family.PLANAR) {
            Class imageType = this.imageType.getImageClass();
            ImageMotion2D<I, IT> motion = FactoryMotion2D.createMotion2D(100, this.inlierThreshold, 2, this.absoluteMinimumTracks, this.respawnTrackFraction, this.respawnCoverageFraction, false, tracker, this.fitModel);
            PlToGrayMotion2D<I, IT> motion2DColor = new PlToGrayMotion2D<I, IT>(motion, imageType);
            return FactoryMotion2D.createVideoStitchMS(this.maxJumpFraction, motion2DColor, imageType);
        }
        ImageMotion2D<I, IT> motion = FactoryMotion2D.createMotion2D(100, this.inlierThreshold, 2, this.absoluteMinimumTracks, this.respawnTrackFraction, this.respawnCoverageFraction, false, tracker, this.fitModel);
        return FactoryMotion2D.createVideoStitch(this.maxJumpFraction, motion, this.imageType.getImageClass());
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.alg != null;
    }

    @Override
    protected void process(SimpleImageSequence<I> sequence) {
        if (!sequence.hasNext()) {
            return;
        }
        this.stopWorker();
        this.sequence = sequence;
        sequence.setLoop(true);
        I input = sequence.next();
        this.inputWidth = ((ImageBase)input).width;
        this.inputHeight = ((ImageBase)input).height;
        this.doRefreshAll();
    }

    @Override
    protected void updateAlg(I frame, BufferedImage buffImage) {
        if (this.alg == null) {
            return;
        }
        if (!this.alg.process(frame)) {
            this.alg.reset();
            ++this.totalResets;
        }
        this.hasProcessedImage = true;
    }

    @Override
    protected void updateAlgGUI(I frame, BufferedImage imageGUI, final double fps) {
        if (!this.hasProcessedImage) {
            return;
        }
        this.corners = this.alg.getImageCorners(((ImageBase)frame).width, ((ImageBase)frame).height, null);
        ConvertBufferedImage.convertTo(this.alg.getStitchedImage(), this.stitchOut, true);
        if (this.checkLocation(this.corners)) {
            this.alg.setOriginToCurrent();
        }
        AccessPointTracks access = (AccessPointTracks)((Object)this.alg.getMotion());
        List<Point2D_F64> tracks = access.getAllTracks();
        ArrayList<Point2D_F64> inliers = new ArrayList<Point2D_F64>();
        for (int i = 0; i < tracks.size(); ++i) {
            if (!access.isInlier(i)) continue;
            inliers.add(tracks.get(i));
        }
        final int numInliers = inliers.size();
        final int numFeatures = tracks.size();
        this.showImageView = this.infoPanel.getShowView();
        this.gui.setImages(imageGUI, this.stitchOut);
        this.gui.setShowImageView(this.infoPanel.getShowView());
        this.gui.setCorners(this.corners);
        if (this.infoPanel.getShowInliers()) {
            this.gui.setInliers(inliers);
        } else {
            this.gui.setInliers(null);
        }
        if (this.infoPanel.getShowAll()) {
            this.gui.setAllTracks(tracks);
        } else {
            this.gui.setAllTracks(null);
        }
        Homography2D_F64 H = this.alg.getWorldToCurr(null).invert(null);
        this.gui.setCurrToWorld(H);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VideoStitchBaseApp.this.infoPanel.setFPS(fps);
                VideoStitchBaseApp.this.infoPanel.setNumInliers(numInliers);
                VideoStitchBaseApp.this.infoPanel.setNumTracks(numFeatures);
                VideoStitchBaseApp.this.infoPanel.setKeyFrames(VideoStitchBaseApp.this.totalResets);
                VideoStitchBaseApp.this.infoPanel.repaint();
                VideoStitchBaseApp.this.gui.repaint();
            }
        });
    }

    @Override
    public void refreshAll(Object[] cookies) {
        this.stopWorker();
        this.tracker = (PointTracker)cookies[0];
        this.fitModel = (InvertibleTransform)cookies[1];
        this.startEverything();
    }

    @Override
    public void setActiveAlgorithm(int indexFamily, String name, Object cookie) {
        if (this.sequence == null) {
            return;
        }
        this.stopWorker();
        switch (indexFamily) {
            case 0: {
                this.tracker = (PointTracker)cookie;
                break;
            }
            case 1: {
                this.fitModel = (InvertibleTransform)cookie;
            }
        }
        this.sequence.reset();
        this.startEverything();
    }

    protected void startEverything() {
        this.tracker.dropAllTracks();
        this.alg = this.createAlgorithm(this.tracker);
        this.init(this.inputWidth, this.inputHeight);
        this.totalResets = 0;
        this.startWorkerThread();
    }

    protected abstract void init(int var1, int var2);

    protected abstract boolean checkLocation(StitchingFromMotion2D.Corners var1);
}

