/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.sfm.d2;

import boofcv.alg.sfm.d2.StitchingFromMotion2D;
import boofcv.gui.feature.VisualizeFeatures;
import georegression.struct.homography.Homography2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.transform.homography.HomographyPointOps_F64;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JPanel;
import org.ddogleg.struct.FastQueue;

public abstract class Motion2DPanel
extends JPanel {
    BufferedImage stitched;
    BufferedImage input;
    int windowWidth;
    int windowHeight;
    int distortOffX;
    Homography2D_F64 currToWorld = new Homography2D_F64();
    FastQueue<Point2D_F64> inliers = new FastQueue(300, Point2D_F64.class, true);
    FastQueue<Point2D_F64> allTracks = new FastQueue(300, Point2D_F64.class, true);
    boolean showImageView;
    StitchingFromMotion2D.Corners corners;

    public void setImages(BufferedImage input, BufferedImage stitched) {
        this.input = input;
        this.stitched = stitched;
    }

    public void setCorners(StitchingFromMotion2D.Corners corners) {
        this.corners = corners;
    }

    public synchronized void setInliers(List<Point2D_F64> list) {
        this.inliers.reset();
        if (list != null) {
            for (Point2D_F64 p : list) {
                ((Point2D_F64)this.inliers.grow()).set(p);
            }
        }
    }

    public synchronized void setAllTracks(List<Point2D_F64> list) {
        this.allTracks.reset();
        if (list != null) {
            for (Point2D_F64 p : list) {
                ((Point2D_F64)this.allTracks.grow()).set(p);
            }
        }
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        int h;
        double scaleY;
        super.paintComponent(g);
        if (this.stitched == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        int w = this.getWidth();
        double scaleX = (double)w / (double)this.windowWidth;
        double scale = Math.min(scaleX, scaleY = (double)(h = this.getHeight()) / (double)this.windowHeight);
        if (scale > 1.0) {
            scale = 1.0;
        }
        this.drawImages(scale, g2);
        this.drawFeatures((float)scale, g2);
        if (this.showImageView) {
            this.drawImageBounds(g2, this.distortOffX, 0, scale);
        }
    }

    protected abstract void drawImages(double var1, Graphics2D var3);

    protected abstract void drawFeatures(float var1, Graphics2D var2);

    protected void drawFeatures(float scale, int offsetX, int offsetY, FastQueue<Point2D_F64> all, FastQueue<Point2D_F64> inliers, Homography2D_F64 currToGlobal, Graphics2D g2) {
        int i;
        Point2D_F64 distPt = new Point2D_F64();
        for (i = 0; i < all.size; ++i) {
            HomographyPointOps_F64.transform((Homography2D_F64)currToGlobal, (Point2D_F64)((Point2D_F64)all.get(i)), (Point2D_F64)distPt);
            distPt.x = (double)offsetX + distPt.x * (double)scale;
            distPt.y = (double)offsetY + distPt.y * (double)scale;
            VisualizeFeatures.drawPoint(g2, (int)distPt.x, (int)distPt.y, Color.RED);
        }
        for (i = 0; i < inliers.size; ++i) {
            HomographyPointOps_F64.transform((Homography2D_F64)currToGlobal, (Point2D_F64)((Point2D_F64)inliers.get(i)), (Point2D_F64)distPt);
            distPt.x = (double)offsetX + distPt.x * (double)scale;
            distPt.y = (double)offsetY + distPt.y * (double)scale;
            VisualizeFeatures.drawPoint(g2, (int)distPt.x, (int)distPt.y, Color.BLUE);
        }
    }

    private void drawImageBounds(Graphics2D g2, int tx, int ty, double scale) {
        StitchingFromMotion2D.Corners c = this.corners;
        if (c == null) {
            return;
        }
        g2.setColor(Color.BLUE);
        this.drawLine(g2, tx, ty, scale, c.p0, c.p1);
        this.drawLine(g2, tx, ty, scale, c.p1, c.p2);
        this.drawLine(g2, tx, ty, scale, c.p2, c.p3);
        this.drawLine(g2, tx, ty, scale, c.p3, c.p0);
    }

    private void drawLine(Graphics2D g2, int tx, int ty, double scale, Point2D_F64 p0, Point2D_F64 p1) {
        g2.drawLine((int)(p0.x * scale) + tx, (int)(p0.y * scale) + ty, (int)(p1.x * scale) + tx, (int)(p1.y * scale) + ty);
    }

    public void setCurrToWorld(Homography2D_F64 currToWorld) {
        this.currToWorld.set(currToWorld);
    }

    public void setShowImageView(boolean showImageView) {
        this.showImageView = showImageView;
    }
}

