/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.segmentation;

import boofcv.alg.segmentation.watershed.WatershedVincentSoille1991;
import boofcv.factory.segmentation.FactorySegmentationAlg;
import boofcv.gui.feature.VisualizeRegions;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.ConnectRule;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU8;
import java.awt.image.BufferedImage;

public class VisualizeWatershedApp {
    public static void main(String[] args) {
        BufferedImage image = UtilImageIO.loadImage(UtilIO.pathExample("segment/berkeley_horses.jpg"));
        GrayU8 gray = new GrayU8(image.getWidth(), image.getHeight());
        ConvertBufferedImage.convertFrom(image, gray);
        WatershedVincentSoille1991 alg = FactorySegmentationAlg.watershed(ConnectRule.FOUR);
        alg.process(gray);
        GrayS32 pixelToRegion = alg.getOutput();
        VisualizeRegions.watersheds(pixelToRegion, image, 0);
        alg.removeWatersheds();
        int numRegions = alg.getTotalRegions();
        BufferedImage outRegions = VisualizeRegions.regions(pixelToRegion, numRegions, null);
        ShowImages.showWindow(image, "Watershed");
        ShowImages.showWindow(outRegions, "Regions");
    }
}

