/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.segmentation;

import boofcv.abst.segmentation.ImageSuperpixels;
import boofcv.alg.segmentation.ComputeRegionMeanColor;
import boofcv.alg.segmentation.ImageSegmentationOps;
import boofcv.demonstrations.segmentation.SegmentConfigPanel;
import boofcv.factory.segmentation.FactoryImageSegmentation;
import boofcv.factory.segmentation.FactorySegmentationAlg;
import boofcv.gui.SelectAlgorithmAndInputPanel;
import boofcv.gui.feature.VisualizeRegions;
import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.PathLabel;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.feature.ColorQueue_F32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.ddogleg.struct.GrowQueue_I32;

public class VisualizeImageSegmentationApp<T extends ImageBase>
extends SelectAlgorithmAndInputPanel {
    ImageType<T> imageType;
    BufferedImage inputImage;
    BufferedImage outColor = new BufferedImage(1, 1, 1);
    BufferedImage outSegments = new BufferedImage(1, 1, 1);
    BufferedImage outBorder = new BufferedImage(1, 1, 1);
    ImageSuperpixels<T> alg = null;
    int activeDisplay = 0;
    T color;
    GrayS32 pixelToRegion = new GrayS32(1, 1);
    SegmentConfigPanel leftPanel;
    ImagePanel gui = new ImagePanel();
    boolean processImage = false;
    boolean busy = false;

    public VisualizeImageSegmentationApp() {
        this(ImageType.pl(3, GrayF32.class));
    }

    public VisualizeImageSegmentationApp(ImageType<T> imageType) {
        super(1);
        this.imageType = imageType;
        this.addAlgorithm(0, "FH04", 0);
        this.addAlgorithm(0, "SLIC Superpixel", 1);
        this.addAlgorithm(0, "Mean-Shift", 2);
        this.addAlgorithm(0, "Watershed", 3);
        this.color = imageType.createImage(1, 1);
        JPanel viewArea = new JPanel(new BorderLayout());
        this.leftPanel = new SegmentConfigPanel(this);
        viewArea.add((Component)this.leftPanel, "West");
        viewArea.add((Component)this.gui, "Center");
        this.declareAlgorithm(0);
        this.setMainGUI(viewArea);
    }

    public void process(final BufferedImage input) {
        this.setInputImage(input);
        this.inputImage = input;
        ((ImageBase)this.color).reshape(input.getWidth(), input.getHeight());
        this.pixelToRegion.reshape(((ImageBase)this.color).width, ((ImageBase)this.color).height);
        ConvertBufferedImage.convertFrom(input, this.color, true);
        if (input.getWidth() != this.outColor.getWidth() || input.getHeight() != this.outColor.getHeight()) {
            this.outColor = new BufferedImage(((ImageBase)this.color).width, ((ImageBase)this.color).height, 1);
            this.outSegments = new BufferedImage(((ImageBase)this.color).width, ((ImageBase)this.color).height, 1);
            this.outBorder = new BufferedImage(((ImageBase)this.color).width, ((ImageBase)this.color).height, 1);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VisualizeImageSegmentationApp.this.gui.setPreferredSize(new Dimension(((ImageBase)VisualizeImageSegmentationApp.this.color).getWidth(), ((ImageBase)VisualizeImageSegmentationApp.this.color).getHeight()));
                VisualizeImageSegmentationApp.this.gui.setBufferedImage(input);
                VisualizeImageSegmentationApp.this.gui.revalidate();
                VisualizeImageSegmentationApp.this.processImage = true;
            }
        });
        this.doRefreshAll();
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public void refreshAll(Object[] cookies) {
        this.setActiveAlgorithm(0, null, cookies[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setActiveAlgorithm(int indexFamily, String name, Object cookie) {
        if (this.inputImage == null) {
            return;
        }
        ImageType<T> imageType = this.imageType;
        synchronized (imageType) {
            this.busy = true;
            this.leftPanel.setComputing(true);
            this.declareAlgorithm((Integer)cookie);
            this.performSegmentation();
            this.updateActiveDisplay(this.activeDisplay);
            this.leftPanel.setComputing(false);
            this.busy = false;
            this.gui.repaint();
        }
    }

    private void declareAlgorithm(int which) {
        this.alg = null;
        switch (which) {
            case 0: {
                this.alg = FactoryImageSegmentation.fh04(this.leftPanel.configFh, this.imageType);
                break;
            }
            case 1: {
                this.alg = FactoryImageSegmentation.slic(this.leftPanel.configSlic, this.imageType);
                break;
            }
            case 2: {
                this.alg = FactoryImageSegmentation.meanShift(this.leftPanel.configMeanShift, this.imageType);
                break;
            }
            case 3: {
                this.alg = FactoryImageSegmentation.watershed(this.leftPanel.configWatershed, this.imageType);
                break;
            }
            default: {
                throw new RuntimeException("BUG!");
            }
        }
        this.leftPanel.switchAlgorithm(which);
    }

    @Override
    public void changeInput(String name, int index) {
        BufferedImage image = this.media.openImage(((PathLabel)this.inputRefs.get(index)).getPath());
        if (image != null) {
            this.process(image);
        }
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.processImage;
    }

    public void updateActiveDisplay(int value) {
        this.activeDisplay = value;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (VisualizeImageSegmentationApp.this.activeDisplay == 0) {
                    VisualizeImageSegmentationApp.this.gui.setBufferedImage(VisualizeImageSegmentationApp.this.outColor);
                } else if (VisualizeImageSegmentationApp.this.activeDisplay == 1) {
                    VisualizeImageSegmentationApp.this.gui.setBufferedImage(VisualizeImageSegmentationApp.this.outBorder);
                } else if (VisualizeImageSegmentationApp.this.activeDisplay == 2) {
                    VisualizeImageSegmentationApp.this.gui.setBufferedImage(VisualizeImageSegmentationApp.this.outSegments);
                }
                VisualizeImageSegmentationApp.this.gui.repaint();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    private void performSegmentation() {
        long before = System.currentTimeMillis();
        this.alg.segment(this.color, this.pixelToRegion);
        long after = System.currentTimeMillis();
        System.out.println("Total time " + (after - before));
        int numSegments = this.alg.getTotalSuperpixels();
        ImageType type = ((ImageBase)this.color).getImageType();
        ComputeRegionMeanColor<T> colorize = FactorySegmentationAlg.regionMeanColor(type);
        ColorQueue_F32 segmentColor = new ColorQueue_F32(type.getNumBands());
        segmentColor.resize(numSegments);
        GrowQueue_I32 regionMemberCount = new GrowQueue_I32();
        regionMemberCount.resize(numSegments);
        ImageSegmentationOps.countRegionPixels(this.pixelToRegion, numSegments, regionMemberCount.data);
        colorize.process(this.color, this.pixelToRegion, regionMemberCount, segmentColor);
        VisualizeRegions.regionsColor(this.pixelToRegion, segmentColor, this.outColor);
        VisualizeRegions.regions(this.pixelToRegion, segmentColor.size(), this.outSegments);
        ConvertBufferedImage.convertTo(this.color, this.outBorder, true);
        VisualizeRegions.regionBorders(this.pixelToRegion, 0, this.outBorder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recompute() {
        ImageType<T> imageType = this.imageType;
        synchronized (imageType) {
            if (this.busy) {
                return;
            }
            this.busy = true;
        }
        this.doRefreshAll();
    }

    public static void main(String[] args) {
        ImageType<Planar<GrayF32>> imageType = ImageType.pl(3, GrayF32.class);
        VisualizeImageSegmentationApp<Planar<GrayF32>> app = new VisualizeImageSegmentationApp<Planar<GrayF32>>(imageType);
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("Horses", UtilIO.pathExample("segment/berkeley_horses.jpg")));
        inputs.add(new PathLabel("Kangaroo", UtilIO.pathExample("segment/berkeley_kangaroo.jpg")));
        inputs.add(new PathLabel("Man", UtilIO.pathExample("segment/berkeley_man.jpg")));
        inputs.add(new PathLabel("Pines People", UtilIO.pathExample("segment/mountain_pines_people.jpg")));
        inputs.add(new PathLabel("Sunflowers", UtilIO.pathExample("sunflowers.jpg")));
        inputs.add(new PathLabel("Shapes", UtilIO.pathExample("shapes/shapes01.png")));
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Image Segmentation", true);
    }
}

