/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.fiducial;

import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.distort.AdjustmentType;
import boofcv.alg.distort.ImageDistort;
import boofcv.alg.distort.LensDistortionOps;
import boofcv.alg.fiducial.square.BaseDetectFiducialSquare;
import boofcv.alg.fiducial.square.DetectFiducialSquareBinary;
import boofcv.alg.fiducial.square.FoundFiducial;
import boofcv.core.image.border.BorderType;
import boofcv.factory.filter.binary.FactoryThresholdBinary;
import boofcv.factory.shape.ConfigPolygonDetector;
import boofcv.factory.shape.FactoryShapeDetector;
import boofcv.gui.ListDisplayPanel;
import boofcv.gui.binary.VisualizeBinaryData;
import boofcv.gui.feature.VisualizeShapes;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageType;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.FastQueue;

public class VisualizeSquareBinaryFiducial {
    static final int gridWidth = 4;
    static final double borderWidth = 0.25;

    public void process(String nameImage, String nameIntrinsic) {
        IntrinsicParameters intrinsic = (IntrinsicParameters)UtilIO.loadXML(nameIntrinsic);
        GrayF32 input = UtilImageIO.loadImage(nameImage, GrayF32.class);
        GrayF32 undistorted = new GrayF32(input.width, input.height);
        IntrinsicParameters paramUndist = new IntrinsicParameters();
        ImageDistort<GrayF32, GrayF32> undistorter = LensDistortionOps.imageRemoveDistortion(AdjustmentType.EXPAND, BorderType.EXTENDED, intrinsic, paramUndist, ImageType.single(GrayF32.class));
        InputToBinary<GrayF32> inputToBinary = FactoryThresholdBinary.globalOtsu(0, 255, true, GrayF32.class);
        Detector detector = new Detector(4, 0.25, inputToBinary);
        detector.configure(paramUndist, false);
        detector.setLengthSide(0.1);
        undistorter.apply(input, undistorted);
        detector.process(undistorted);
        System.out.println("Total Found: " + detector.squares.size());
        FastQueue<FoundFiducial> fiducials = detector.getFound();
        int N = Math.min(20, detector.squares.size());
        ListDisplayPanel squares = new ListDisplayPanel();
        for (int i = 0; i < N; ++i) {
            squares.addImage(VisualizeBinaryData.renderBinary(detector.squares.get(i), false, null), " " + i);
            squares.addImage(ConvertBufferedImage.convertTo(detector.squaresGray.get(i), null), " " + i);
        }
        BufferedImage output = new BufferedImage(input.width, input.height, 1);
        ConvertBufferedImage.convertTo(input, output);
        Graphics2D g2 = output.createGraphics();
        g2.setColor(Color.RED);
        g2.setStroke(new BasicStroke(2.0f));
        for (int i = 0; i < N; ++i) {
            VisualizeShapes.draw(((FoundFiducial)fiducials.get((int)i)).location, g2);
        }
        ShowImages.showWindow(output, "Binary", true);
        ShowImages.showWindow(squares, "Candidates", true);
    }

    public static void main(String[] args) {
        String directory = UtilIO.pathExample("fiducial/binary/");
        VisualizeSquareBinaryFiducial app = new VisualizeSquareBinaryFiducial();
        app.process(directory + "/image0000.jpg", directory + "/intrinsic.xml");
    }

    public static class Detector
    extends DetectFiducialSquareBinary<GrayF32> {
        public List<GrayU8> squares = new ArrayList<GrayU8>();
        public List<GrayF32> squaresGray = new ArrayList<GrayF32>();

        protected Detector(int gridWidth, double borderWidth, InputToBinary<GrayF32> inputToBinary) {
            super(gridWidth, borderWidth, 0.65, inputToBinary, FactoryShapeDetector.polygon(new ConfigPolygonDetector(false, 4, 4), GrayF32.class), GrayF32.class);
        }

        @Override
        protected boolean processSquare(GrayF32 square, BaseDetectFiducialSquare.Result result, double a, double b) {
            if (super.processSquare(square, result, a, b)) {
                this.squares.add((GrayU8)super.getBinaryInner().clone());
                this.squaresGray.add((GrayF32)super.getGrayNoBorder().clone());
                return true;
            }
            return false;
        }
    }
}

