/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.feature.flow;

import boofcv.abst.distort.FDistort;
import boofcv.abst.flow.DenseOpticalFlow;
import boofcv.factory.flow.FactoryDenseOpticalFlow;
import boofcv.gui.PanelGridPanel;
import boofcv.gui.SelectAlgorithmAndInputPanel;
import boofcv.gui.feature.VisualizeOpticalFlow;
import boofcv.gui.image.AnimatePanel;
import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.PathLabel;
import boofcv.io.ProgressMonitorThread;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.flow.ImageFlow;
import boofcv.struct.image.GrayF32;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;

public class DenseFlowApp
extends SelectAlgorithmAndInputPanel {
    PanelGridPanel gui;
    ImagePanel flowPanel;
    AnimatePanel animationPanel;
    GrayF32 unscaled = new GrayF32(1, 1);
    GrayF32 input0 = new GrayF32(1, 1);
    GrayF32 input1 = new GrayF32(1, 1);
    ImageFlow flow = new ImageFlow(1, 1);
    boolean processImage = false;
    boolean hasInputImage = false;
    DenseOpticalFlow<GrayF32> denseFlow;
    BufferedImage converted0;
    BufferedImage converted1;
    BufferedImage visualized;

    public DenseFlowApp() {
        super(1);
        Class<GrayF32> T = GrayF32.class;
        this.addAlgorithm(0, "KLT", FactoryDenseOpticalFlow.flowKlt(null, 6, T, T));
        this.addAlgorithm(0, "Region", FactoryDenseOpticalFlow.region(null, T));
        this.addAlgorithm(0, "Horn-Schunck-Pyramid", FactoryDenseOpticalFlow.hornSchunckPyramid(null, GrayF32.class));
        this.addAlgorithm(0, "Brox", FactoryDenseOpticalFlow.broxWarping(null, GrayF32.class));
        this.addAlgorithm(0, "Horn-Schunck", FactoryDenseOpticalFlow.hornSchunck(null, GrayF32.class));
        this.animationPanel = new AnimatePanel(200, null);
        this.flowPanel = new ImagePanel();
        this.gui = new PanelGridPanel(2, this.animationPanel, this.flowPanel);
        this.animationPanel.start();
        this.setMainGUI(this.gui);
    }

    @Override
    public synchronized void setActiveAlgorithm(int indexFamily, String name, Object cookie) {
        this.denseFlow = (DenseOpticalFlow)cookie;
        this.process();
    }

    @Override
    public synchronized void changeInput(String name, int index) {
        BufferedImage image0 = this.media.openImage(((PathLabel)this.inputRefs.get(index)).getPath(0));
        BufferedImage image1 = this.media.openImage(((PathLabel)this.inputRefs.get(index)).getPath(1));
        this.unscaled.reshape(image0.getWidth(), image1.getHeight());
        this.input0.reshape(this.unscaled.width / 2, this.unscaled.height / 2);
        this.input1.reshape(this.unscaled.width / 2, this.unscaled.height / 2);
        this.flow.reshape(this.unscaled.width / 2, this.unscaled.height / 2);
        ConvertBufferedImage.convertFrom(image0, this.unscaled, false);
        new FDistort(this.unscaled, this.input0).scaleExt().apply();
        ConvertBufferedImage.convertFrom(image1, this.unscaled, false);
        new FDistort(this.unscaled, this.input1).scaleExt().apply();
        this.converted0 = new BufferedImage(this.input0.width, this.input0.height, 1);
        this.converted1 = new BufferedImage(this.input0.width, this.input0.height, 1);
        this.visualized = new BufferedImage(this.input0.width, this.input0.height, 1);
        ConvertBufferedImage.convertTo(this.input0, this.converted0, true);
        ConvertBufferedImage.convertTo(this.input1, this.converted1, true);
        this.hasInputImage = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DenseFlowApp.this.flowPanel.setPreferredSize(new Dimension(DenseFlowApp.this.input0.width, DenseFlowApp.this.input0.height));
                DenseFlowApp.this.flowPanel.setBufferedImage(DenseFlowApp.this.visualized);
                DenseFlowApp.this.animationPanel.setPreferredSize(new Dimension(DenseFlowApp.this.input0.width, DenseFlowApp.this.input0.height));
                DenseFlowApp.this.animationPanel.setAnimation(DenseFlowApp.this.converted0, DenseFlowApp.this.converted1);
                DenseFlowApp.this.gui.revalidate();
            }
        });
        this.doRefreshAll();
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public void refreshAll(Object[] cookies) {
        this.setActiveAlgorithm(0, null, cookies[0]);
    }

    private synchronized void process() {
        if (this.hasInputImage && this.denseFlow != null) {
            ProcessThread progress = new ProcessThread(this);
            progress.start();
            this.denseFlow.process(this.input0, this.input1, this.flow);
            progress.stopThread();
            VisualizeOpticalFlow.colorized(this.flow, 10.0f, this.visualized);
            this.gui.repaint();
            this.processImage = true;
        }
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.processImage;
    }

    public static void main(String[] args) {
        DenseFlowApp app = new DenseFlowApp();
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("urban", UtilIO.pathExample("denseflow/Urban2_07.png"), UtilIO.pathExample("denseflow/Urban2_08.png")));
        inputs.add(new PathLabel("dog", UtilIO.pathExample("denseflow/dogdance07.png"), UtilIO.pathExample("denseflow/dogdance08.png")));
        inputs.add(new PathLabel("grove", UtilIO.pathExample("denseflow/Grove2_07.png"), UtilIO.pathExample("denseflow/Grove2_08.png")));
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Dense Optical Flow", true);
    }

    public class ProcessThread
    extends ProgressMonitorThread {
        public ProcessThread(JComponent owner) {
            super(new ProgressMonitor(owner, "Computing Flow", "", 0, 100));
        }

        @Override
        public void doRun() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProcessThread.this.monitor.setProgress(0);
                }
            });
        }
    }
}

